package JSci.maths.chaos;

import JSci.maths.*;

/**
* The LogisticMap class provides an object that encapsulates the logistic map.
* @version 1.0
* @author Mark Hale
*/
public final class LogisticMap extends Object implements Mapping {
        private Complex r;
        /**
        * 2 cycle bifurcation point.
        */
        public final static double R_2CYCLE=3.0;
        /**
        * 4 cycle bifurcation point.
        */
        public final static double R_4CYCLE=1+Math.sqrt(6);
        /**
        * 6 cycle bifurcation point.
        */
        public final static double R_6CYCLE=3.5441;
        /**
        * 8 cycle bifurcation point.
        */
        public final static double R_8CYCLE=3.5664;
        /**
        * Accumulation point.
        */
        public final static double R_ACCUMULATION=3.5699;
        /**
        * Constructs a logistic map.
        * @param rval the value of the r parameter
        */
        public LogisticMap(double rval) {
                r=new Complex(rval,0.0);
        }
        /**
        * Constructs a logistic map.
        * @param rval the value of the r parameter
        */
        public LogisticMap(Complex rval) {
                r=rval;
        }
        /**
        * Performs the mapping.
        * @param x a double
        */
        public double map(double x) {
                return r.real()*x*(1-x);
        }
        /**
        * Performs the mapping.
        * @param z a complex number
        */
        public Complex map(Complex z) {
                return r.multiply(z).multiply(Complex.ONE.subtract(z));
        }
        /**
        * Iterates the map.
        * @param n the number of iterations
        * @param x the initial value
        */
        public double iterate(int n,double x) {
                for(int i=0;i<n;i++)
                        x=map(x);
                return x;
        }
        /**
        * Iterates the map.
        * @param n the number of iterations
        * @param z the initial value
        */
        public Complex iterate(int n,Complex z) {
                for(int i=0;i<n;i++)
                        z=map(z);
                return z;
        }
}

