package JSci.maths.chaos;

import JSci.maths.*;

/**
* The MandelbrotMap class provides an object that encapsulates the Mandelbrot map.
* @version 1.0
* @author Mark Hale
*/
public final class MandelbrotMap extends Object implements Mapping {
        private Complex a;
        /**
        * Constructs a Mandelbrot map.
        * @param aval the value of the a parameter
        */
        public MandelbrotMap(double aval) {
                a=new Complex(aval,0.0);
        }
        /**
        * Constructs a Mandelbrot map.
        * @param aval the value of the a parameter
        */
        public MandelbrotMap(Complex aval) {
                a=aval;
        }
        /**
        * Performs the mapping.
        * @param x a double
        */
        public double map(double x) {
                return x*x-a.real();
        }
        /**
        * Performs the mapping.
        * @param z a complex number
        */
        public Complex map(Complex z) {
                return z.sqr().subtract(a);
        }
        /**
        * Iterates the map.
        * @param n the number of iterations
        * @param x the initial value
        */
        public double iterate(int n,double x) {
                for(int i=0;i<n;i++)
                        x=map(x);
                return x;
        }
        /**
        * Iterates the map.
        * @param n the number of iterations
        * @param z the initial value
        */
        public Complex iterate(int n,Complex z) {
                for(int i=0;i<n;i++)
                        z=map(z);
                return z;
        }
}

