package JSci.maths.chaos;

import JSci.maths.*;

/**
* The StandardMap class provides an object that encapsulates the Standard map.
* (Chirikov, Taylor).
* @version 1.0
* @author Mark Hale
*/
public final class StandardMap extends Object implements NMapping {
        private Complex k;
        /**
        * Constructs a Standard map.
        * @param kval the value of the k parameter
        */
        public StandardMap(double kval) {
                k=new Complex(kval,0.0);
        }
        /**
        * Constructs a Standard map.
        * @param kval the value of the k parameter
        */
        public StandardMap(Complex kval) {
                k=kval;
        }
        /**
        * Performs the mapping.
        * @param x a 2-D double array
        * @return a 2-D double array
        */
        public double[] map(double x[]) {
                double ans[]=new double[2];
                ans[1]=x[1]+k.real()*Math.sin(x[0]);
                ans[0]=x[0]+ans[1];
                return ans;
        }
        /**
        * Performs the mapping.
        * @param z a 2-D complex array
        * @return a 2-D complex array
        */
        public Complex[] map(Complex z[]) {
                Complex ans[]=new Complex[2];
                ans[1]=z[1].add(k.multiply(Complex.sin(z[0])));
                ans[0]=z[0].add(ans[1]);
                return ans;
        }
        /**
        * Iterates the map.
        * @param n the number of iterations
        * @param x the initial values (2-D)
        * @return a 2-D double array
        */
        public double[] iterate(int n,double x[]) {
                double xn[]=map(x);
                for(int i=1;i<n;i++)
                        xn=map(xn);
                return xn;
        }
        /**
        * Iterates the map.
        * @param n the number of iterations
        * @param z the initial values (2-D)
        * @return a 2-D complex array
        */
        public Complex[] iterate(int n,Complex z[]) {
                Complex zn[]=map(z);
                for(int i=1;i<n;i++)
                        zn=map(zn);
                return zn;
        }
}

