package JSci.maths.fields;

import JSci.maths.Complex;
import JSci.maths.RingMember;
import JSci.maths.groups.AbelianGroupMember;

/**
* The ComplexField class encapsulates the field of complex numbers.
* @version 1.0
* @author Mark Hale
*/
public final class ComplexField extends Object implements Field {
        public final static Complex ZERO=new Complex(0.0,0.0);
        public final static Complex I=new Complex(0.0,1.0);
        public final static Complex ONE=new Complex(1.0,0.0);
        public final static Complex MINUS_ONE=new Complex(-1.0,0.0);
        public final static Complex MINUS_I=new Complex(0.0,-1.0);
        public final static Complex HALF=new Complex(0.5,0.0);
        public final static Complex MINUS_HALF=new Complex(-0.5,0.0);
        public final static Complex HALF_I=new Complex(0.0,0.5);
        public final static Complex MINUS_HALF_I=new Complex(0.0,-0.5);
        public final static Complex TWO=new Complex(2.0,0.0);
        public final static Complex MINUS_TWO=new Complex(-2.0,0.0);
        public final static Complex SQRT_HALF=new Complex(Math.sqrt(0.5),0.0);
        public final static Complex SQRT_HALF_I=new Complex(0.0,Math.sqrt(0.5));
        public final static Complex MINUS_SQRT_HALF_I=new Complex(0.0,-Math.sqrt(0.5));
        public final static Complex PI=new Complex(Math.PI,0.0);
        public final static Complex PI_I=new Complex(0.0,Math.PI);
        public final static Complex PI_2=new Complex(Math.PI/2.0,0.0);
        public final static Complex MINUS_PI_2=new Complex(-Math.PI/2.0,0.0);
        public final static Complex PI_2_I=new Complex(0.0,Math.PI/2.0);
        public final static Complex MINUS_PI_2_I=new Complex(0.0,-Math.PI/2.0);
        /**
        * Constructs a field of complex numbers.
        */
        public ComplexField() {}
        /**
        * Returns the complex number zero.
        */
        public AbelianGroupMember zero() {
                return ZERO;
        }
        /**
        * Returns true if the complex number is equal to zero.
        */
        public boolean isZero(AbelianGroupMember g) {
                return ZERO.equals(g);
        }
        /**
        * Returns true if one complex number is the negative of the other.
        */
        public boolean isNegative(AbelianGroupMember a,AbelianGroupMember b) {
                return ZERO.equals(a.add(b));
        }
        /**
        * Returns the complex number zero.
        */
        public RingMember one() {
                return ONE;
        }
        /**
        * Returns true if the complex number is equal to one.
        */
        public boolean isOne(RingMember r) {
                return ONE.equals(r);
        }
        /**
        * Returns true if one complex number is the inverse of the other.
        */
        public boolean isInverse(FieldMember a,FieldMember b) {
                return ONE.equals(a.multiply(b));
        }
}

