package JSci.maths.groups;

import JSci.maths.Member;

/**
* This interface defines an abelian group.
* @version 1.0
* @author Mark Hale
*/
public interface AbelianGroup extends Member {
        /**
        * Returns the identity element.
        */
        AbelianGroupMember zero();
        /**
        * Returns true if the member is the identity element of this group.
        * @param g a group member
        */
        boolean isZero(AbelianGroupMember g);
        /**
        * Returns true if one member is the negative of the other.
        * @param a a group member
        * @param b a group member
        */
        boolean isNegative(AbelianGroupMember a,AbelianGroupMember b);
}

