package JSci.maths.groups;

/**
* The DihedralGroup class represents the nth order dihedral group.
* Elements are represented by strings.
* @version 1.2
* @author Mark Hale
*/
public final class DihedralGroup extends DiscreteGroup {
        /**
        * Constructs a dihedral group.
        * @param n order of group
        */
        public DihedralGroup(int n) {
                super("D"+n);
                elements=new Object[2*n];
                elements[0]=new String("e");
                elements[1]=new String("b");
                StringBuffer buf=new StringBuffer(n);
                for(int i=1;i<n;i++) {
                        buf.append('c');
                        elements[i+1]=buf.toString();
                        elements[i+n]='b'+buf.toString();
                }
        }
        /**
        * The group composition law.
        * @param a a group element
        * @param b a group element
        */
        public Object compose(Object a, Object b) {
                final String aStr=a.toString(),bStr=b.toString();
                if(isIdentity(a))
                        return b;
                else if(isIdentity(b))
                        return a;
                else if(aStr.equals("b")) {
                        if(bStr.equals("b"))
                                return identity();
                        else if(bStr.charAt(0)=='b')
                                return bStr.substring(1);
                        else
                                return aStr+bStr;
                } else if(bStr.charAt(0)=='b') {
                        if(aStr.charAt(0)=='b') {
                                int nc=bStr.length()-aStr.length();
                                if(nc==0)
                                        return identity();
                                else if(nc<0)
                                        nc+=elements.length/2;
                                return elements[1+nc];
                        } else {
                                int nc=bStr.length()-1-aStr.length();
                                if(nc==0)
                                        return elements[1];
                                else if(nc<0)
                                        nc+=elements.length/2;
                                return elements[elements.length/2+nc];
                        }
                } else {
                        if(aStr.charAt(0)=='b') {
                                final String c=aStr+bStr;
                                if(c.length()>elements.length/2)
                                        return c.substring(0,c.length()-elements.length/2);
                                else
                                        return c;
                        } else {
                                final String c=aStr+bStr;
                                if(c.length()==elements.length/2)
                                        return identity();
                                if(c.length()<elements.length/2)
                                        return c;
                                else
                                        return c.substring(0,c.length()-elements.length/2);
                        }
                }
        }
        /**
        * Returns the identity element.
        */
        public Object identity() {
                return elements[0];
        }
        /**
        * Returns the inverse element.
        */
        public Object inverse(Object a) {
                if(isIdentity(a))
                        return identity();
                else if(a.toString().equals("b"))
                        return elements[1];
                else {
                        for(int i=2;i<elements.length;i++) {
                                if(isInverse(a,elements[i]))
                                        return elements[i];
                        }
                        return null;
                }
        }
}

