package JSci.maths.groups;

/**
* This interface defines a group.
* @version 1.2
* @author Mark Hale
*/
public interface Group {
        /**
        * The group composition law.
        * @param a a group element
        * @param b a group element
        */
        Object compose(Object a, Object b);
        /**
        * Returns the identity element.
        */
        Object identity();
        /**
        * Returns the inverse element.
        */
        Object inverse(Object a);
        /**
        * Returns true if the element is the identity element of this group.
        * @param a a group element
        */
        boolean isIdentity(Object a);
        /**
        * Returns true if one element is the inverse of the other.
        * @param a a group element
        * @param b a group element
        */
        boolean isInverse(Object a, Object b);
}

