package JSci.physics;

import JSci.maths.*;
import JSci.physics.relativity.*;

/**
* The ClassicalParticle class provides an object for encapsulating classical particles.
* @version 1.0
* @author Mark Hale
*/
public class ClassicalParticle extends Particle {
        /**
        * Constructs a classical particle.
        */
        public ClassicalParticle() {}
        /**
        * Returns the time.
        */
        public double getTime() {
                return position.getComponent(0);
        }
        /**
        * Sets the time.
        */
        public void setTime(double t) {
                position=new Rank1Tensor(t,
                        position.getComponent(1),
                        position.getComponent(2),
                        position.getComponent(3));
        }
        /**
        * Returns the position vector.
        */
        public Double3Vector getPosition() {
                return new Double3Vector(
                        position.getComponent(1),
                        position.getComponent(2),
                        position.getComponent(3));
        }
        /**
        * Sets the position.
        */
        public void setPosition(Double3Vector pos) {
                position=new Rank1Tensor(position.getComponent(0),
                        pos.getComponent(0),
                        pos.getComponent(1),
                        pos.getComponent(2));
        }
        /**
        * Returns the energy.
        */
        public double getEnergy() {
                return momentum.getComponent(0);
        }
        /**
        * Sets the energy.
        */
        public void setEnergy(double e) {
                momentum=new Rank1Tensor(e,
                        momentum.getComponent(1),
                        momentum.getComponent(2),
                        momentum.getComponent(3));
        }
        /**
        * Returns the momentum vector.
        */
        public Double3Vector getMomentum() {
                return new Double3Vector(
                        momentum.getComponent(1),
                        momentum.getComponent(2),
                        momentum.getComponent(3));
        }
        /**
        * Sets the momentum.
        */
        public void setMomentum(Double3Vector p) {
                momentum=new Rank1Tensor(momentum.getComponent(0),
                        p.getComponent(0),
                        p.getComponent(1),
                        p.getComponent(2));
        }
        /**
        * Returns the rest mass.
        */
        public double restMass() {
                double p=getMomentum().norm();
                return p*p/(2.0*getEnergy());
        }
}

