package JSci.physics;

import JSci.GlobalSettings;
import JSci.physics.relativity.*;

/**
* A superclass for building objects that have the physical nature of a particle.
* @version 1.5
* @author Mark Hale
*/
public abstract class Particle extends Object implements java.io.Serializable {
        /**
        * Constructs a particle.
        */
        public Particle() {}
        /**
        * Position 4-vector.
        */
        public Rank1Tensor position=new Rank1Tensor(0.0,0.0,0.0,0.0);
        /**
        * Momentum 4-vector.
        */
        public Rank1Tensor momentum=new Rank1Tensor(0.0,0.0,0.0,0.0);
        /**
        * Returns the rest mass.
        */
        public abstract double restMass();
        /**
        * Compares two particles for equality.
        * @param p a particle
        */
        public boolean equals(Object p) {
                return (p!=null) && (p instanceof Particle) &&
                        (position.equals(((Particle)p).position)) &&
                        (momentum.equals(((Particle)p).momentum)) &&
                        (Math.abs(restMass()-((Particle)p).restMass())<=GlobalSettings.ZERO_TOL);
        }
}

