package JSci.swing;

import java.awt.*;
import JSci.awt.*;

/**
* The JCategoryGraph2D superclass provides an abstract encapsulation
* of 2D category graphs.
* @version 1.0
* @author Mark Hale
*/
public abstract class JCategoryGraph2D extends JDoubleBufferedComponent implements GraphDataListener {
        /**
        * Data model.
        */
        protected CategoryGraph2DModel model;
        /**
        * Constructs a 2D category graph.
        */
        public JCategoryGraph2D(CategoryGraph2DModel cgm) {
                model=cgm;
                model.addGraphDataListener(this);
        }
        /**
        * Sets the data plotted by this graph to the specified data.
        */
        public final void setModel(CategoryGraph2DModel cgm) {
                model.removeGraphDataListener(this);
                model=cgm;
                model.addGraphDataListener(this);
                dataChanged(new GraphDataEvent(model));
        }
        /**
        * Returns the model used by this graph.
        */
        public final CategoryGraph2DModel getModel() {
                return model;
        }
        /**
        * Rounds numbers to so many significant figures.
        */
        protected final float round(float x) {
                final int SIG_FIG=2;
                int sign=1;
                if(x<0.0f)
                        sign=-1;
                final float mag=Math.abs(x);
                int places;
                float tmp,factor;
                if(mag<1.0f) {
                        tmp=10.0f*mag;
                        for(places=1;tmp<1.0f;places++)
                                tmp*=10.0f;
                        factor=(float)Math.pow(10.0f,places+SIG_FIG-1);
                } else {
                        tmp=mag/10.0f;
                        for(places=1;tmp>1.0f;places++)
                                tmp/=10.0f;
                        factor=(float)Math.pow(10.0f,SIG_FIG-places);
                }
                return (float)(sign*Math.rint(mag*factor)/factor);
        }
}

