/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementCone;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementCone
extends SimpleAbstractTile {
    public SimpleElementCone(ElementCone elementCone) {
        super(elementCone);
    }

    protected double[][][] computeTile() {
        ElementCone elementCone = (ElementCone)this.element;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d = elementCone.getMinimumAngle();
        double d2 = elementCone.getMaximumAngle();
        if (Math.abs(d2 - d) > 360.0) {
            d2 = d + 360.0;
        }
        Resolution resolution = this.style.getResolution();
        double d3 = elementCone.getTruncationHeight();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d4 = Math.abs(this.element.getSizeX()) / 2.0;
                    double d5 = Math.abs(this.element.getSizeY()) / 2.0;
                    double d6 = Math.abs(this.element.getSizeZ());
                    if (!Double.isNaN(d3)) {
                        d6 = Math.min(d6, d3);
                    }
                    n = Math.max((int)Math.round(0.49 + Math.max(d4, d5) / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d) * (Math.PI / 180) * (d4 + d5) / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + d6 / resolution.getMaxLength()), 1);
                }
            }
        }
        if (!Double.isNaN(d3 /= this.element.getSizeZ())) {
            d3 = Math.min(d3, 1.0);
        }
        return ElementCone.createStandardCone(n, n2, n3, d, d2, elementCone.isClosedTop(), elementCone.isClosedBottom(), elementCone.isClosedLeft(), elementCone.isClosedRight(), d3);
    }
}

