/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import javax.swing.JFrame;
import org.opensourcephysics.display2d.VectorColorMapper;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementArrow;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.utils.Style;

public class VectorField
extends Group {
    protected double minimumX = Double.NaN;
    protected double maximumX = Double.NaN;
    protected double minimumY = Double.NaN;
    protected double maximumY = Double.NaN;
    protected double minimumZ = Double.NaN;
    protected double maximumZ = Double.NaN;
    protected double vectorSizeX = 1.0;
    protected double vectorSizeY = 1.0;
    protected double vectorSizeZ = 1.0;
    protected double vectorAlpha = Double.NaN;
    protected double vectorBeta = Double.NaN;
    protected double vectorMagnitude = Double.NaN;
    protected double[][][] vectorSizeXData;
    protected double[][][] vectorSizeYData;
    protected double[][][] vectorSizeZData;
    protected double[][][] vectorAlphaData;
    protected double[][][] vectorBetaData;
    protected double[][][] vectorMagnitudeData;
    protected boolean autoscaleMagnitude = false;
    protected boolean useColorMapper = false;
    protected double constantLength = Double.NaN;
    protected int levels = -1;
    protected int invisibleLevel = -1;
    protected Color maxColor = Color.RED;
    protected Color minColor = Color.BLUE;
    private boolean positionChanged = true;
    private boolean sizeChanged = true;
    private boolean magChanged = true;
    protected double magConstant = 0.0;
    protected double minMagnitude = 0.0;
    protected double maxMagnitude = 1.0;
    protected double useMinX;
    protected double useMaxX;
    protected double useMinY;
    protected double useMaxY;
    protected double useMinZ;
    protected double useMaxZ;
    protected Color[] colors;
    protected VectorColorMapper mapper = new VectorColorMapper(16, 1.0);
    protected double[][][] vectorLength;
    protected int nX = -1;
    protected int nY = -1;
    protected int nZ = -1;
    private ElementArrow invisibleElement = new ElementArrow();
    private boolean showLegend;
    private int arrowType = 0;

    public VectorField() {
        this.addElement(this.invisibleElement);
        this.setNumberOfLevels(16);
    }

    public void processChanges(int n) {
        this.prepareField();
        super.processChanges(n);
    }

    public void setMinimumX(double d) {
        if (d != this.minimumX) {
            this.minimumX = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumX(double d) {
        if (d != this.maximumX) {
            this.maximumX = d;
            this.positionChanged = true;
        }
    }

    public void setMinimumY(double d) {
        if (d != this.minimumY) {
            this.minimumY = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumY(double d) {
        if (d != this.maximumY) {
            this.maximumY = d;
            this.positionChanged = true;
        }
    }

    public void setMinimumZ(double d) {
        if (d != this.minimumZ) {
            this.minimumZ = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumZ(double d) {
        if (d != this.maximumZ) {
            this.maximumZ = d;
            this.positionChanged = true;
        }
    }

    public void setVectorSizeXData(double[][][] dArray) {
        this.vectorSizeXData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeX(double d) {
        if (this.vectorSizeX != d) {
            this.vectorSizeX = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeYData(double[][][] dArray) {
        this.vectorSizeYData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeY(double d) {
        if (this.vectorSizeY != d) {
            this.vectorSizeY = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeZData(double[][][] dArray) {
        this.vectorSizeZData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeZ(double d) {
        if (this.vectorSizeZ != d) {
            this.vectorSizeZ = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorAlphaData(double[][][] dArray) {
        this.vectorAlphaData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAlpha(double d) {
        if (this.vectorAlpha != d) {
            this.vectorAlpha = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorBetaData(double[][][] dArray) {
        this.vectorBetaData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAlphaAndBetaData(double[][][] dArray, double[][][] dArray2) {
        this.vectorAlphaData = dArray;
        this.vectorBetaData = dArray2;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorBeta(double d) {
        if (this.vectorBeta != d) {
            this.vectorBeta = d;
            this.sizeChanged = true;
        }
    }

    public void setConstantLength(double d) {
        if (this.constantLength != d) {
            this.constantLength = d;
            this.sizeChanged = true;
        }
    }

    public void setAutoscaleMagnitude(boolean bl) {
        if (this.autoscaleMagnitude != bl) {
            this.autoscaleMagnitude = bl;
            this.magChanged = true;
        }
    }

    public void setMagnitudeExtrema(double d, double d2) {
        if (this.autoscaleMagnitude) {
            this.autoscaleMagnitude = false;
            this.magChanged = true;
        }
        if (this.minMagnitude == d && this.maxMagnitude == d2) {
            return;
        }
        this.minMagnitude = d;
        this.maxMagnitude = d2;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public double getMagnitudeMinimum() {
        return this.minMagnitude;
    }

    public double getMagnitudeMaximum() {
        return this.maxMagnitude;
    }

    public void setMagnitudeData(double[][][] dArray) {
        this.vectorMagnitudeData = dArray;
        this.magChanged = true;
        this.checkArrays();
    }

    public void setMagnitude(double d) {
        if (this.vectorMagnitude != d) {
            this.vectorMagnitude = d;
            this.magChanged = true;
        }
    }

    public void setNumberOfLevels(int n) {
        if (n == this.levels) {
            return;
        }
        this.magChanged = true;
        if (n <= 0) {
            this.levels = 0;
            return;
        }
        this.levels = n;
        this.colors = new Color[this.levels];
        this.initColors();
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setNumberOfColors(n);
        this.mapper.updateLegend();
    }

    public void setMinColor(Color color) {
        if (color.equals(this.minColor)) {
            return;
        }
        this.minColor = color;
        this.initColors();
        this.magChanged = true;
    }

    public void setMaxColor(Color color) {
        if (color.equals(this.maxColor)) {
            return;
        }
        this.maxColor = color;
        this.initColors();
        this.magChanged = true;
    }

    public void setInvisibleLevel(int n) {
        if (this.invisibleLevel != n) {
            this.invisibleLevel = n;
            this.magChanged = true;
        }
    }

    public void setArrowType(int n) {
        this.arrowType = n;
        for (Element element : this.getElements()) {
            ((ElementArrow)element).setArrowType(n);
        }
    }

    public void setRelativePosition(int n) {
        for (Element element : this.getElements()) {
            element.getStyle().setRelativePosition(n);
        }
    }

    public void setOffset(int n) {
        this.setRelativePosition(n);
    }

    public void setUseColorMapper(boolean bl) {
        this.useColorMapper = bl;
        this.setShowLegend(this.showLegend);
        this.mapper.updateLegend();
        this.magChanged = true;
    }

    public VectorColorMapper getColorMapper() {
        return this.mapper;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
        JFrame jFrame = this.mapper.getLegendFrame();
        if (jFrame == null) {
            jFrame = this.mapper.showLegend();
        }
        jFrame.setVisible(this.useColorMapper && bl);
    }

    public double indexToX(int n) {
        if (n < 0 || n >= this.nX) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nX == 1) {
            return (this.useMinX + this.useMaxX) / 2.0;
        }
        return this.useMinX + (double)n * (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
    }

    public double indexToY(int n) {
        if (n < 0 || n >= this.nY) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nY == 1) {
            return (this.useMinY + this.useMaxY) / 2.0;
        }
        return this.useMinY + (double)n * (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
    }

    public double indexToZ(int n) {
        if (n < 0 || n >= this.nZ) {
            return Double.NaN;
        }
        this.checkExtrema();
        if (this.nZ == 1) {
            return (this.useMinZ + this.useMaxZ) / 2.0;
        }
        return this.useMinZ + (double)n * (this.useMaxZ - this.useMinZ) / (double)(this.nZ - 1);
    }

    private void checkExtrema() {
        DrawingPanel3D drawingPanel3D = this.getPanel();
        this.useMinX = Double.isNaN(this.minimumX) ? drawingPanel3D.getPreferredMinX() : this.minimumX;
        this.useMaxX = Double.isNaN(this.maximumX) ? drawingPanel3D.getPreferredMaxX() : this.maximumX;
        this.useMinY = Double.isNaN(this.minimumY) ? drawingPanel3D.getPreferredMinY() : this.minimumY;
        this.useMaxY = Double.isNaN(this.maximumY) ? drawingPanel3D.getPreferredMaxY() : this.maximumY;
        this.useMinZ = Double.isNaN(this.minimumZ) ? drawingPanel3D.getPreferredMinZ() : this.minimumZ;
        this.useMaxZ = Double.isNaN(this.maximumZ) ? drawingPanel3D.getPreferredMaxZ() : this.maximumZ;
    }

    private void checkArraySize(double[][][] dArray) {
        if (dArray != null) {
            this.nX = Math.min(this.nX, dArray.length);
            this.nY = Math.min(this.nY, dArray[0].length);
            this.nZ = Math.min(this.nZ, dArray[0][0].length);
        }
    }

    private boolean checkArrays() {
        int n;
        this.nZ = Integer.MAX_VALUE;
        this.nY = Integer.MAX_VALUE;
        this.nX = Integer.MAX_VALUE;
        this.checkArraySize(this.vectorSizeXData);
        this.checkArraySize(this.vectorSizeYData);
        this.checkArraySize(this.vectorSizeZData);
        this.checkArraySize(this.vectorAlphaData);
        this.checkArraySize(this.vectorBetaData);
        this.checkArraySize(this.vectorMagnitudeData);
        if (this.nX == Integer.MAX_VALUE) {
            this.nX = 0;
        }
        if (this.nY == Integer.MAX_VALUE) {
            this.nY = 0;
        }
        if (this.nZ == Integer.MAX_VALUE) {
            this.nZ = 0;
        }
        if (this.nX <= 0 || this.nY <= 0 || this.nZ <= 0) {
            return false;
        }
        if (this.vectorLength == null || this.vectorLength.length != this.nX || this.vectorLength[0].length != this.nY || this.vectorLength[0][0].length != this.nZ) {
            this.vectorLength = new double[this.nX][this.nY][this.nZ];
        }
        if ((n = this.nX * this.nY * this.nZ) != this.getNumberOfElements() - 1) {
            this.setNumberOfElements(n);
        }
        return true;
    }

    private boolean isAngleSet() {
        if (this.vectorAlphaData == null && Double.isNaN(this.vectorAlpha)) {
            return false;
        }
        return this.vectorBetaData != null || !Double.isNaN(this.vectorBeta);
    }

    private boolean isMagnitudeSet() {
        return this.vectorMagnitudeData != null || !Double.isNaN(this.vectorMagnitude);
    }

    private void setNumberOfElements(int n) {
        Style style = this.invisibleElement.getStyle();
        this.removeAllElements();
        this.addElement(this.invisibleElement);
        int n2 = 1;
        while (n2 <= n) {
            ElementArrow elementArrow = new ElementArrow();
            elementArrow.setHeadSize(3.5);
            style.copyTo(elementArrow.getStyle());
            elementArrow.setArrowType(this.arrowType);
            this.addElementAtIndex(n2, elementArrow);
            ++n2;
        }
        this.magChanged = true;
        this.sizeChanged = true;
        this.positionChanged = true;
    }

    private boolean prepareField() {
        double d;
        if (this.nX <= 0 || this.nY <= 0 || this.nZ <= 0) {
            return false;
        }
        if (this.sizeChanged) {
            int n;
            if (this.vectorSizeXData != null || this.vectorSizeYData != null || this.vectorSizeZData != null || !this.isAngleSet()) {
                if (Double.isNaN(this.constantLength)) {
                    double d2 = this.vectorSizeX;
                    double d3 = this.vectorSizeY;
                    double d4 = this.vectorSizeZ;
                    int n2 = 0;
                    n = 0;
                    while (n2 < this.nX) {
                        int n3 = 0;
                        while (n3 < this.nY) {
                            int n4 = 0;
                            while (n4 < this.nZ) {
                                if (this.vectorSizeXData != null) {
                                    d2 = this.vectorSizeXData[n2][n3][n4];
                                }
                                if (this.vectorSizeYData != null) {
                                    d3 = this.vectorSizeYData[n2][n3][n4];
                                }
                                if (this.vectorSizeZData != null) {
                                    d4 = this.vectorSizeZData[n2][n3][n4];
                                }
                                this.vectorLength[n2][n3][n4] = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                                this.getElement(n).setSizeXYZ(d2, d3, d4);
                                ++n4;
                                ++n;
                            }
                            ++n3;
                        }
                        ++n2;
                    }
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < this.nX) {
                        int n7 = 0;
                        while (n7 < this.nY) {
                            int n8 = 0;
                            while (n8 < this.nZ) {
                                double d5 = this.vectorSizeX;
                                double d6 = this.vectorSizeY;
                                double d7 = this.vectorSizeZ;
                                if (this.vectorSizeXData != null) {
                                    d5 = this.vectorSizeXData[n5][n7][n8];
                                }
                                if (this.vectorSizeYData != null) {
                                    d6 = this.vectorSizeYData[n5][n7][n8];
                                }
                                if (this.vectorSizeZData != null) {
                                    d7 = this.vectorSizeZData[n5][n7][n8];
                                }
                                if ((d = (this.vectorLength[n5][n7][n8] = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7))) == 0.0) {
                                    d7 = 0.0;
                                    d6 = 0.0;
                                    d5 = 0.0;
                                } else {
                                    d = this.constantLength / d;
                                    d5 *= d;
                                    d6 *= d;
                                    d7 *= d;
                                }
                                this.getElement(n6).setSizeXYZ(d5, d6, d7);
                                ++n8;
                                ++n6;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                }
            } else {
                double d8 = this.vectorAlpha;
                double d9 = this.vectorBeta;
                int n9 = 0;
                int n10 = 0;
                while (n9 < this.nX) {
                    int n11 = 0;
                    while (n11 < this.nY) {
                        n = 0;
                        while (n < this.nZ) {
                            if (this.vectorAlphaData != null) {
                                d8 = this.vectorAlphaData[n9][n11][n];
                            }
                            if (this.vectorBetaData != null) {
                                d9 = this.vectorBetaData[n9][n11][n];
                            }
                            this.vectorLength[n9][n11][n] = this.constantLength;
                            double d10 = Math.cos(d9);
                            this.getElement(n10).setSizeXYZ(this.constantLength * Math.cos(d8) * d10, this.constantLength * Math.sin(d8) * d10, this.constantLength * Math.sin(d9));
                            ++n;
                            ++n10;
                        }
                        ++n11;
                    }
                    ++n9;
                }
            }
            if (!this.isMagnitudeSet()) {
                this.magChanged = true;
            }
        }
        double d11 = this.useMinX;
        double d12 = this.useMaxX;
        double d13 = this.useMinY;
        double d14 = this.useMaxY;
        double d15 = this.useMinZ;
        d = this.useMaxZ;
        this.checkExtrema();
        if (this.positionChanged || d11 != this.useMinX || d12 != this.useMaxX || d13 != this.useMinY || d14 != this.useMaxY || d15 != this.useMinZ || d != this.useMaxZ) {
            double d16;
            double d17;
            double d18;
            double d19;
            double d20;
            double d21;
            if (this.nX <= 1) {
                d21 = (this.useMinX + this.useMaxX) / 2.0;
                d20 = 0.0;
            } else {
                d21 = this.useMinX;
                d20 = (this.useMaxX - this.useMinX) / (double)(this.nX - 1);
            }
            if (this.nY <= 1) {
                d19 = (this.useMinY + this.useMaxY) / 2.0;
                d18 = 0.0;
            } else {
                d19 = this.useMinY;
                d18 = (this.useMaxY - this.useMinY) / (double)(this.nY - 1);
            }
            if (this.nZ <= 1) {
                d17 = (this.useMinZ + this.useMaxZ) / 2.0;
                d16 = 0.0;
            } else {
                d17 = this.useMinZ;
                d16 = (this.useMaxZ - this.useMinZ) / (double)(this.nZ - 1);
            }
            int n = 0;
            int n12 = 0;
            while (n < this.nX) {
                double d22 = d21 + (double)n * d20;
                int n13 = 0;
                while (n13 < this.nY) {
                    double d23 = d19 + (double)n13 * d18;
                    int n14 = 0;
                    while (n14 < this.nZ) {
                        double d24 = d17 + (double)n14 * d16;
                        this.getElement(n12).setXYZ(d22, d23, d24);
                        ++n14;
                        ++n12;
                    }
                    ++n13;
                }
                ++n;
            }
        }
        if (this.magChanged) {
            this.processMagnitude();
        }
        this.magChanged = false;
        this.sizeChanged = false;
        this.positionChanged = false;
        this.invisibleElement.setVisible(false);
        return true;
    }

    private void processMagnitude() {
        Object object;
        this.mapper.checkPallet(this.getPanel().getVisualizationHints().getBackgroundColor());
        if (this.levels > 0) {
            double[][][] dArray = object = this.isMagnitudeSet() ? this.vectorMagnitudeData : this.vectorLength;
            if (object != null) {
                if (this.autoscaleMagnitude) {
                    this.computeMagnitudeExtrema((double[][][])object);
                }
                int n = 0;
                int n2 = 0;
                while (n < this.nX) {
                    int n3 = 0;
                    while (n3 < this.nY) {
                        int n4 = 0;
                        while (n4 < this.nZ) {
                            Element element = this.getElement(n2);
                            double d = object[n][n3][n4];
                            Color color = this.magToColor(d);
                            if (color == null) {
                                element.setVisible(false);
                            } else {
                                element.setVisible(true);
                                element.getStyle().setLineColor(color);
                                element.getStyle().setFillColor(color);
                                element.getStyle().setExtraColor(this.magToCompColor(d));
                            }
                            ++n4;
                            ++n2;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return;
            }
        }
        object = Double.isNaN(this.vectorMagnitude) ? this.minColor : this.magToColor(this.vectorMagnitude);
        Color color = Double.isNaN(this.vectorMagnitude) ? this.maxColor : this.magToCompColor(this.vectorMagnitude);
        int n = 0;
        int n5 = 0;
        while (n < this.nX) {
            int n6 = 0;
            while (n6 < this.nY) {
                int n7 = 0;
                while (n7 < this.nZ) {
                    Element element = this.getElement(n5);
                    element.setVisible(true);
                    element.getStyle().setLineColor((Color)object);
                    element.getStyle().setFillColor((Paint)object);
                    element.getStyle().setExtraColor(color);
                    ++n7;
                    ++n5;
                }
                ++n6;
            }
            ++n;
        }
    }

    private void computeMagnitudeExtrema(double[][][] dArray) {
        if (dArray == null) {
            return;
        }
        this.minMagnitude = Double.POSITIVE_INFINITY;
        this.maxMagnitude = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < dArray.length) {
            double[][] dArray2 = dArray[n];
            int n2 = 0;
            while (n2 < dArray2.length) {
                double[] dArray3 = dArray2[n2];
                int n3 = 0;
                while (n3 < dArray3.length) {
                    this.minMagnitude = Math.min(this.minMagnitude, dArray3[n3]);
                    this.maxMagnitude = Math.max(this.minMagnitude, dArray3[n3]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.mapper.setScale(this.maxMagnitude);
        this.mapper.updateLegend();
    }

    private void initColors() {
        int n = this.minColor.getRed();
        int n2 = this.minColor.getGreen();
        int n3 = this.minColor.getBlue();
        int n4 = this.minColor.getAlpha();
        int n5 = this.maxColor.getRed();
        int n6 = this.maxColor.getGreen();
        int n7 = this.maxColor.getBlue();
        int n8 = this.maxColor.getAlpha();
        int n9 = 0;
        while (n9 < this.levels) {
            int n10 = (int)((float)n + (float)((n5 - n) * n9) * 1.0f / (float)(this.levels - 1));
            int n11 = (int)((float)n2 + (float)((n6 - n2) * n9) * 1.0f / (float)(this.levels - 1));
            int n12 = (int)((float)n3 + (float)((n7 - n3) * n9) * 1.0f / (float)(this.levels - 1));
            int n13 = (int)((float)n4 + (float)((n8 - n4) * n9) * 1.0f / (float)(this.levels - 1));
            this.colors[n9] = new Color(n10, n11, n12, n13);
            ++n9;
        }
    }

    private Color magToColor(double d) {
        if (this.useColorMapper) {
            return this.mapper.doubleToColor(d);
        }
        if (this.colors == null || this.levels == 0) {
            return this.minColor;
        }
        int n = (int)(this.magConstant * (d - this.minMagnitude));
        if (this.invisibleLevel >= 0 && n <= this.invisibleLevel) {
            return null;
        }
        if (n <= 0) {
            return this.colors[0];
        }
        if (n >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[n];
    }

    private Color magToCompColor(double d) {
        if (this.useColorMapper) {
            return this.mapper.doubleToCompColor(d);
        }
        if (this.colors == null || this.levels == 0) {
            return this.maxColor;
        }
        int n = (int)(this.magConstant * (this.maxMagnitude - d));
        if (this.invisibleLevel >= 0 && n <= this.invisibleLevel) {
            return null;
        }
        if (n <= 0) {
            return this.colors[0];
        }
        if (n >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[n];
    }
}

