/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class DataRefreshTool
implements Tool {
    private static Map<Data, DataRefreshTool> tools = new HashMap<Data, DataRefreshTool>();
    private Data data;

    public static DataRefreshTool getTool(Data data) {
        DataRefreshTool dataRefreshTool = tools.get(data);
        if (dataRefreshTool == null) {
            dataRefreshTool = new DataRefreshTool(data);
            tools.put(data, dataRefreshTool);
        }
        return dataRefreshTool;
    }

    private DataRefreshTool(Data data) {
        this.data = data;
    }

    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || tool == null || !Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            return;
        }
        DatasetManager datasetManager = new DatasetManager();
        Data data = (Data)xMLControlElement.loadObject(null, true, true);
        String string = null;
        try {
            Method object = data.getClass().getMethod("getName", new Class[0]);
            string = (String)object.invoke((Object)data, new Object[0]);
            datasetManager.setName(string);
        }
        catch (Exception exception) {}
        for (Dataset dataset : data.getDatasets()) {
            Dataset dataset2;
            if (dataset == null || (dataset2 = this.getMatch(dataset.getID())) == null) continue;
            datasetManager.addDataset(dataset2);
        }
        if (!datasetManager.getDatasets().isEmpty()) {
            xMLControlElement = new XMLControlElement(datasetManager);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
        }
    }

    private Dataset getMatch(int n) {
        for (Dataset dataset : this.data.getDatasets()) {
            if (Math.abs(n) != dataset.getID()) continue;
            return dataset;
        }
        return null;
    }
}

