/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementSurface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAnalyticSurface3D
extends ControlElement3D
implements NeedsPreUpdate {
    private static final int SURFACE_ROPERTIES_ADDED = 14;
    protected String variable1;
    protected String variable2;
    protected int numPoints1;
    protected int numPoints2;
    protected double min1 = Double.NaN;
    protected double max1 = Double.NaN;
    protected double min2 = Double.NaN;
    protected double max2 = Double.NaN;
    protected String functionX = null;
    protected String functionY = null;
    protected String functionZ = null;
    protected boolean useJavaSyntax = true;
    protected ElementSurface surface;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX;
    protected String[] varsY;
    protected String[] varsZ;
    protected int indexX1;
    protected int indexY1;
    protected int indexZ1;
    protected int indexX2;
    protected int indexY2;
    protected int indexZ2;
    private double minAbcise1 = Double.NaN;
    private double maxAbcise1 = Double.NaN;
    private double minAbcise2 = Double.NaN;
    private double maxAbcise2 = Double.NaN;
    private static List<String> infoList = null;

    @Override
    protected Element createElement() {
        this.surface = new ElementSurface();
        this.surface.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlAnalyticSurface3D.this.checkExtremes();
            }
        });
        this.surface.setCanBeMeasured(false);
        this.variable1 = "u";
        this.variable2 = "v";
        this.numPoints1 = 20;
        this.numPoints2 = 20;
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX2 = -1;
        this.indexX1 = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY2 = -1;
        this.indexY1 = -1;
        this.functionZ = null;
        this.varsZ = new String[0];
        this.indexZ2 = -1;
        this.indexZ1 = -1;
        this.changedZfunction = true;
        this.changedYfunction = true;
        this.changedXfunction = true;
        return this.surface;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.ElementSurface";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 14;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable1");
            infoList.add("min1");
            infoList.add("max1");
            infoList.add("points1");
            infoList.add("variable2");
            infoList.add("min2");
            infoList.add("max2");
            infoList.add("points2");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable1")) {
            return "String";
        }
        if (string.equals("variable2")) {
            return "String";
        }
        if (string.equals("min1")) {
            return "int|double";
        }
        if (string.equals("max1")) {
            return "int|double";
        }
        if (string.equals("min2")) {
            return "int|double";
        }
        if (string.equals("max2")) {
            return "int|double";
        }
        if (string.equals("points1")) {
            return "int";
        }
        if (string.equals("points2")) {
            return "int";
        }
        if (string.equals("functionx")) {
            return "String";
        }
        if (string.equals("functiony")) {
            return "String";
        }
        if (string.equals("functionz")) {
            return "String";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.variable1 != null && this.variable1.equals(value.getString())) break;
                this.variable1 = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min1 = value.getDouble();
                this.checkMeasured();
                break;
            }
            case 2: {
                this.max1 = value.getDouble();
                this.checkMeasured();
                break;
            }
            case 3: {
                this.numPoints1 = value.getInteger();
                break;
            }
            case 4: {
                if (this.variable2 != null && this.variable2.equals(value.getString())) break;
                this.variable2 = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 5: {
                this.min2 = value.getDouble();
                this.checkMeasured();
                break;
            }
            case 6: {
                this.max2 = value.getDouble();
                this.checkMeasured();
                break;
            }
            case 7: {
                this.numPoints2 = value.getInteger();
                break;
            }
            case 8: {
                if (this.functionX != null && this.functionX.equals(value.getString())) break;
                this.functionX = value.getString();
                this.changedXfunction = true;
                break;
            }
            case 9: {
                if (this.functionY != null && this.functionY.equals(value.getString())) break;
                this.functionY = value.getString();
                this.changedYfunction = true;
                break;
            }
            case 10: {
                if (this.functionZ != null && this.functionZ.equals(value.getString())) break;
                this.functionZ = value.getString();
                this.changedZfunction = true;
                break;
            }
            case 11: {
                if (value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = value.getBoolean();
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 12: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, value.getString());
                break;
            }
            case 13: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, value.getString());
                break;
            }
            default: {
                super.setValue(n - 14, value);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.variable1 = "u";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min1 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 2: {
                this.max1 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints1 = 20;
                break;
            }
            case 4: {
                this.variable2 = "v";
                this.updateIndexes = true;
                break;
            }
            case 5: {
                this.min2 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 6: {
                this.max2 = Double.NaN;
                this.surface.setCanBeMeasured(false);
                break;
            }
            case 7: {
                this.numPoints2 = 20;
                break;
            }
            case 8: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 9: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 10: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 11: {
                this.useJavaSyntax = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 12: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                break;
            }
            case 13: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                break;
            }
            default: {
                super.setDefaultValue(n - 14);
            }
        }
        if (this.isUnderEjs) {
            this.preupdate();
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "u";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "20";
            }
            case 4: {
                return "u";
            }
            case 5: 
            case 6: {
                return "Double.NaN";
            }
            case 7: {
                return "20";
            }
            case 8: 
            case 9: 
            case 10: {
                return "<none>";
            }
            case 11: {
                return "true";
            }
            case 12: 
            case 13: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(n - 14);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
        }
        return super.getValue(n - 14);
    }

    private boolean isVariableDefined(String string) {
        if (this.variable1.equals(string)) {
            return true;
        }
        if (this.variable2.equals(string)) {
            return true;
        }
        Value value = this.myGroup.getValue(string);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    private void checkExtremes() {
        if (this.myParent == null) {
            return;
        }
        DrawingPanel3D drawingPanel3D = this.myParent.getDrawingPanel3D();
        boolean bl = false;
        if (Double.isNaN(this.min1) || Double.isNaN(this.max1)) {
            if (Double.isNaN(this.min1) && drawingPanel3D.getPreferredMinX() != this.minAbcise1) {
                bl = true;
            } else if (Double.isNaN(this.max1) && drawingPanel3D.getPreferredMaxX() != this.maxAbcise1) {
                bl = true;
            }
        }
        if (Double.isNaN(this.min2) || Double.isNaN(this.max2)) {
            if (Double.isNaN(this.min2) && drawingPanel3D.getPreferredMinY() != this.minAbcise2) {
                bl = true;
            } else if (Double.isNaN(this.max2) && drawingPanel3D.getPreferredMaxY() != this.maxAbcise2) {
                bl = true;
            }
        }
        if (bl) {
            this.preupdate();
        }
    }

    private void checkMeasured() {
        this.surface.setCanBeMeasured(!Double.isNaN(this.min1) && !Double.isNaN(this.max1) && !Double.isNaN(this.min2) && !Double.isNaN(this.max2));
    }

    @Override
    public void preupdate() {
        int n;
        int n2;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.changedXfunction && this.functionX != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = ((ParserAndVariables)object).getVariables();
            this.parserX = ((ParserAndVariables)object).getParser();
            n2 = 0;
            n = this.varsX.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsX[n2])) {
                    bl2 = true;
                    break;
                }
                this.parserX.defineVariable(n2, this.varsX[n2]);
                ++n2;
            }
            if (!bl2) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = ((ParserAndVariables)object).getVariables();
            this.parserY = ((ParserAndVariables)object).getParser();
            n2 = 0;
            n = this.varsY.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsY[n2])) {
                    bl3 = true;
                    break;
                }
                this.parserY.defineVariable(n2, this.varsY[n2]);
                ++n2;
            }
            if (!bl3) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    bl3 = true;
                } else {
                    bl = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = ((ParserAndVariables)object).getVariables();
            this.parserZ = ((ParserAndVariables)object).getParser();
            n2 = 0;
            n = this.varsZ.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsZ[n2])) {
                    bl4 = true;
                    break;
                }
                this.parserZ.defineVariable(n2, this.varsZ[n2]);
                ++n2;
            }
            if (!bl4) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    bl4 = true;
                } else {
                    bl = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (bl2 || bl3 || bl4) {
            this.invokeActions(1001);
        } else if (bl) {
            this.invokeActions(1002);
        }
        if (this.myEjsPropertyEditor != null) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", bl2);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", bl3);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", bl4);
        }
        if (this.updateIndexes) {
            this.indexX1 = ControlAnalyticSurface3D.indexOf(this.variable1, this.varsX);
            this.indexY1 = ControlAnalyticSurface3D.indexOf(this.variable1, this.varsY);
            this.indexZ1 = ControlAnalyticSurface3D.indexOf(this.variable1, this.varsZ);
            this.indexX2 = ControlAnalyticSurface3D.indexOf(this.variable2, this.varsX);
            this.indexY2 = ControlAnalyticSurface3D.indexOf(this.variable2, this.varsY);
            this.indexZ2 = ControlAnalyticSurface3D.indexOf(this.variable2, this.varsZ);
            this.updateIndexes = false;
        }
        if ((object = (Object)this.surface.getData()) == null || ((Object)object).length != this.numPoints1 || ((Object)object[0]).length != this.numPoints2) {
            object = new double[this.numPoints1][this.numPoints2][3];
        }
        this.minAbcise1 = this.min1;
        this.maxAbcise1 = this.max1;
        this.minAbcise2 = this.min2;
        this.maxAbcise2 = this.max2;
        if (this.myParent != null) {
            DrawingPanel3D drawingPanel3D = this.myParent.getDrawingPanel3D();
            if (Double.isNaN(this.minAbcise1)) {
                this.minAbcise1 = drawingPanel3D.getPreferredMinX();
            }
            if (Double.isNaN(this.maxAbcise1)) {
                this.maxAbcise1 = drawingPanel3D.getPreferredMaxX();
            }
            if (Double.isNaN(this.minAbcise2)) {
                this.minAbcise2 = drawingPanel3D.getPreferredMinY();
            }
            if (Double.isNaN(this.maxAbcise2)) {
                this.maxAbcise2 = drawingPanel3D.getPreferredMaxY();
            }
        }
        if (this.isUnderEjs) {
            try {
                int n3 = 0;
                n = this.varsX.length;
                while (n3 < n) {
                    if (n3 != this.indexX1 && n3 != this.indexX2) {
                        this.parserX.setVariable(n3, this.myGroup.getDouble(this.varsX[n3]));
                    }
                    ++n3;
                }
                n3 = 0;
                n = this.varsY.length;
                while (n3 < n) {
                    if (n3 != this.indexY1 && n3 != this.indexY2) {
                        this.parserY.setVariable(n3, this.myGroup.getDouble(this.varsY[n3]));
                    }
                    ++n3;
                }
                n3 = 0;
                n = this.varsZ.length;
                while (n3 < n) {
                    if (n3 != this.indexZ1 && n3 != this.indexZ2) {
                        this.parserZ.setVariable(n3, this.myGroup.getDouble(this.varsZ[n3]));
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                System.err.println("ControlAnalyticSurface3D: Null String?\n");
                exception.printStackTrace();
            }
        } else {
            int n4 = 0;
            n = this.varsX.length;
            while (n4 < n) {
                if (n4 != this.indexX1 && n4 != this.indexX2) {
                    this.parserX.setVariable(n4, this.myGroup.getDouble(this.varsX[n4]));
                }
                ++n4;
            }
            n4 = 0;
            n = this.varsY.length;
            while (n4 < n) {
                if (n4 != this.indexY1 && n4 != this.indexY2) {
                    this.parserY.setVariable(n4, this.myGroup.getDouble(this.varsY[n4]));
                }
                ++n4;
            }
            n4 = 0;
            n = this.varsZ.length;
            while (n4 < n) {
                if (n4 != this.indexZ1 && n4 != this.indexZ2) {
                    this.parserZ.setVariable(n4, this.myGroup.getDouble(this.varsZ[n4]));
                }
                ++n4;
            }
        }
        int n5 = 0;
        n = this.numPoints1 - 1;
        while (n5 <= n) {
            double d = ((double)(n - n5) * this.minAbcise1 + (double)n5 * this.maxAbcise1) / (double)n;
            if (this.indexX1 >= 0) {
                this.parserX.setVariable(this.indexX1, d);
            }
            if (this.indexY1 >= 0) {
                this.parserY.setVariable(this.indexY1, d);
            }
            if (this.indexZ1 >= 0) {
                this.parserZ.setVariable(this.indexZ1, d);
            }
            int n6 = 0;
            int n7 = this.numPoints2 - 1;
            while (n6 <= n7) {
                double d2 = ((double)(n7 - n6) * this.minAbcise2 + (double)n6 * this.maxAbcise2) / (double)n7;
                if (this.functionX == null || bl2) {
                    object[n5][n6][0] = 0.0;
                } else {
                    if (this.indexX2 >= 0) {
                        this.parserX.setVariable(this.indexX2, d2);
                    }
                    object[n5][n6][0] = this.parserX.evaluate();
                }
                if (this.functionY == null || bl3) {
                    object[n5][n6][1] = 0.0;
                } else {
                    if (this.indexY2 >= 0) {
                        this.parserY.setVariable(this.indexY2, d2);
                    }
                    object[n5][n6][1] = this.parserY.evaluate();
                }
                if (this.functionZ == null || bl4) {
                    object[n5][n6][2] = 0.0;
                } else {
                    if (this.indexZ2 >= 0) {
                        this.parserZ.setVariable(this.indexZ2, d2);
                    }
                    object[n5][n6][2] = this.parserZ.evaluate();
                }
                ++n6;
            }
            ++n5;
        }
        this.surface.setData((double[][][])object);
    }
}

