/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementEllipsoid;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementEllipsoid
extends SimpleAbstractTile {
    public SimpleElementEllipsoid(ElementEllipsoid elementEllipsoid) {
        super(elementEllipsoid);
    }

    protected double[][][] computeTile() {
        Resolution resolution;
        ElementEllipsoid elementEllipsoid = (ElementEllipsoid)this.element;
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        double d = elementEllipsoid.getMinimumAngleU();
        double d2 = elementEllipsoid.getMaximumAngleU();
        if (Math.abs(d2 - d) > 360.0) {
            d2 = d + 360.0;
        }
        double d3 = elementEllipsoid.getMinimumAngleV();
        double d4 = elementEllipsoid.getMaximumAngleV();
        if (Math.abs(d4 - d3) > 180.0) {
            d4 = d3 + 180.0;
        }
        if ((resolution = this.style.getResolution()) != null) {
            switch (resolution.getType()) {
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                    n2 = Math.max(resolution.getN2(), 1);
                    n3 = Math.max(resolution.getN3(), 1);
                    break;
                }
                case 1: {
                    double d5 = Math.max(Math.max(Math.abs(this.element.getSizeX()), Math.abs(this.element.getSizeY())), Math.abs(this.element.getSizeZ())) / 2.0;
                    n = Math.max((int)Math.round(0.49 + d5 / resolution.getMaxLength()), 1);
                    n2 = Math.max((int)Math.round(0.49 + Math.abs(d2 - d) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                    n3 = Math.max((int)Math.round(0.49 + Math.abs(d4 - d3) * (Math.PI / 180) * d5 / resolution.getMaxLength()), 1);
                }
            }
        }
        return ElementEllipsoid.createStandardEllipsoid(n, n2, n3, d, d2, d3, d4, elementEllipsoid.isClosedTop(), elementEllipsoid.isClosedBottom(), elementEllipsoid.isClosedLeft(), elementEllipsoid.isClosedRight());
    }
}

