/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.drawing2d.ElementTrail;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTrail2D
extends ControlElement2D
implements NeedsPreUpdate,
Resetable,
DataCollector {
    private static final int TRAIL2D_PROPERTIES_ADDED = 10;
    private ElementTrail trail;
    private volatile boolean isSet = false;
    private volatile double x;
    private volatile double y;
    private double[] xArray = null;
    private double[] yArray = null;
    private static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing2d.ElementTrail";
    }

    @Override
    protected Drawable createDrawable() {
        this.trail = new ElementTrail();
        return this.trail;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 10;
    }

    @Override
    public void reset() {
        this.trail.clear();
    }

    @Override
    public void initialize() {
        this.trail.initialize();
    }

    @Override
    public void preupdate() {
        if (!this.trail.isActive()) {
            return;
        }
        if (this.isSet) {
            if (this.xArray == null) {
                if (this.yArray == null) {
                    this.trail.addPoint(this.x, this.y);
                } else {
                    int n = 0;
                    int n2 = this.yArray.length;
                    while (n < n2) {
                        this.trail.addPoint(this.x, this.yArray[n]);
                        ++n;
                    }
                }
            } else if (this.yArray == null) {
                int n = 0;
                int n3 = this.xArray.length;
                while (n < n3) {
                    this.trail.addPoint(this.xArray[n], this.y);
                    ++n;
                }
            } else {
                this.trail.addPoints(this.xArray, this.yArray);
            }
        }
        this.isSet = false;
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlTrail2D.getDataInformationMenuEntries(this.getParent().getDrawingPanel(), this.trail));
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("maximumPoints");
            infoList.add("connected");
            infoList.add("inputX");
            infoList.add("inputY");
            infoList.add("skippoints");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("clearAtInput");
            infoList.add("xLabel");
            infoList.add("yLabel");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("maximumPoints")) {
            return "int";
        }
        if (string.equals("connected")) {
            return "boolean";
        }
        if (string.equals("inputX")) {
            return "int|double|double[]";
        }
        if (string.equals("inputY")) {
            return "int|double|double[]";
        }
        if (string.equals("skippoints")) {
            return "int";
        }
        if (string.equals("active")) {
            return "boolean";
        }
        if (string.equals("norepeat")) {
            return "boolean";
        }
        if (string.equals("clearAtInput")) {
            return "boolean";
        }
        if (string.equals("xLabel")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("yLabel")) {
            return "String TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        string = string.trim();
        if (string2 != null) {
            boolean bl;
            boolean bl2 = bl = string2.startsWith("%_model.") && string2.endsWith("()%");
            if (string.equals("inputX")) {
                this.trail.setXLabel(bl ? "Input X" : string2);
            } else if (string.equals("inputY")) {
                this.trail.setYLabel(bl ? "Input Y" : string2);
            }
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.trail.setMaximumPoints(value.getInteger());
                break;
            }
            case 1: {
                this.trail.setConnectionType(value.getBoolean() ? 1 : 0);
                break;
            }
            case 2: {
                if (value.getObject() instanceof double[]) {
                    this.xArray = (double[])value.getObject();
                } else {
                    this.x = value.getDouble();
                    this.xArray = null;
                }
                this.isSet = true;
                break;
            }
            case 3: {
                if (value.getObject() instanceof double[]) {
                    this.yArray = (double[])value.getObject();
                } else {
                    this.y = value.getDouble();
                    this.yArray = null;
                }
                this.isSet = true;
                break;
            }
            case 4: {
                this.trail.setSkipPoints(value.getInteger());
                break;
            }
            case 5: {
                this.trail.setActive(value.getBoolean());
                break;
            }
            case 6: {
                this.trail.setNoRepeat(value.getBoolean());
                break;
            }
            case 7: {
                this.trail.setClearAtInput(value.getBoolean());
                break;
            }
            case 8: {
                this.trail.setXLabel(value.getString());
                break;
            }
            case 9: {
                this.trail.setYLabel(value.getString());
                break;
            }
            default: {
                super.setValue(n - 10, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.trail.setMaximumPoints(0);
                break;
            }
            case 1: {
                this.trail.setConnectionType(1);
                break;
            }
            case 2: {
                this.x = 0.0;
                this.xArray = null;
                break;
            }
            case 3: {
                this.y = 0.0;
                this.yArray = null;
                break;
            }
            case 4: {
                this.trail.setSkipPoints(0);
                break;
            }
            case 5: {
                this.trail.setActive(true);
                break;
            }
            case 6: {
                this.trail.setNoRepeat(false);
                break;
            }
            case 7: {
                this.trail.setClearAtInput(false);
                break;
            }
            case 8: {
                this.trail.setXLabel(null);
                break;
            }
            case 9: {
                this.trail.setYLabel(null);
                break;
            }
            default: {
                super.setDefaultValue(n - 10);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "0";
            }
            case 1: {
                return "true";
            }
            case 2: {
                return "0.0";
            }
            case 3: {
                return "0.0";
            }
            case 4: {
                return "0";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "false";
            }
            case 7: {
                return "false";
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 10);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return null;
            }
        }
        return super.getValue(n - 10);
    }
}

