/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.frames.TableFrame;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FourierTool;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolForDataFull
extends ToolForData {
    @Override
    public boolean isFullTool() {
        return true;
    }

    @Override
    public void showTable(Component component, ToolForDataInfo toolForDataInfo) {
        int n;
        String[] stringArray;
        TableFrame tableFrame = new TableFrame("Trace Data");
        double[][] dArray = toolForDataInfo.getData();
        tableFrame.setRowNumberVisible(false);
        tableFrame.setColumnNames(1, "x");
        tableFrame.setColumnNames(2, "y");
        if (dArray[0].length >= 3) {
            tableFrame.setColumnNames(3, "z");
        }
        if ((stringArray = toolForDataInfo.getColumnNames()) != null) {
            n = 0;
            while (n < stringArray.length) {
                tableFrame.setColumnNames(n + 1, stringArray[n]);
                ++n;
            }
        }
        n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            tableFrame.appendRow(dArray[n]);
            ++n;
        }
        tableFrame.setDefaultCloseOperation(2);
        tableFrame.setLocationRelativeTo(component);
        tableFrame.setVisible(true);
    }

    @Override
    public void showDataTool(Component component, ToolForDataInfo toolForDataInfo) {
        DataTool dataTool = new DataTool(new DataWrapper(toolForDataInfo), toolForDataInfo.getName());
        dataTool.setLocationRelativeTo(component);
        dataTool.setVisible(true);
    }

    @Override
    public void showDataTool(Component component, List<ToolForDataInfo> list) {
        if (list.isEmpty()) {
            return;
        }
        DataTool dataTool = new DataTool();
        for (ToolForDataInfo toolForDataInfo : list) {
            dataTool.addTab(DataTool.createTab(new DataWrapper(toolForDataInfo), toolForDataInfo.getName()));
        }
        dataTool.setLocationRelativeTo(component);
        dataTool.setVisible(true);
    }

    @Override
    public void showFourierTool(Component component, List<ToolForDataInfo> list) {
        if (list.isEmpty()) {
            return;
        }
        FourierTool fourierTool = new FourierTool();
        for (ToolForDataInfo toolForDataInfo : list) {
            fourierTool.addTab(new DataWrapper(toolForDataInfo), toolForDataInfo.getName());
        }
        fourierTool.setLocationRelativeTo(component);
        fourierTool.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataWrapper
    implements Data {
        private double[][] data;
        private ArrayList<Dataset> datasetList;

        DataWrapper(ToolForDataInfo toolForDataInfo) {
            this.data = toolForDataInfo.getData();
            Dataset dataset = new Dataset();
            dataset.setName(toolForDataInfo.getName());
            dataset.setConnected(true);
            dataset.setLineColor(toolForDataInfo.getLineColor());
            dataset.setMarkerShape(2);
            dataset.setMarkerColor(toolForDataInfo.getFillColor(), toolForDataInfo.getLineColor());
            int n = 0;
            int n2 = this.data.length;
            while (n < n2) {
                dataset.append(this.data[n][0], this.data[n][1]);
                ++n;
            }
            this.datasetList = new ArrayList();
            this.datasetList.add(dataset);
        }

        @Override
        public double[][] getData2D() {
            return this.data;
        }

        @Override
        public double[][][] getData3D() {
            return null;
        }

        @Override
        public ArrayList<Dataset> getDatasets() {
            return this.datasetList;
        }

        @Override
        public ArrayList<ComplexDataset> getComplexDatasets() {
            return null;
        }
    }
}

