/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public abstract class SimpleAbstractTile
extends SimpleElement {
    protected static final int RECOMPUTE_VERTEX = 24;
    private int numberOfTiles = -1;
    private double[][][] standardTile = null;
    private double[][][] vertex = null;
    private int[][] a = null;
    private int[][] b = null;
    private double[] pixel = new double[3];
    private double[] center = new double[3];
    private boolean drawQuickInterior = false;
    private int interiorTransparency = 128;
    private boolean levelBelowWhenEqual = true;
    private double levelx = 0.0;
    private double levely = 0.0;
    private double levelz = 0.0;
    private double leveldx = 0.0;
    private double leveldy = 0.0;
    private double leveldz = 1.0;
    private double[] levelZ = null;
    private Color[] levelColors = null;

    public SimpleAbstractTile(Element element) {
        super(element);
        this.computeVertex();
    }

    protected abstract double[][][] computeTile();

    public void processChanges(int n, int n2) {
        if ((n2 & 0x18) != 0) {
            this.computeVertex();
            this.computeCoordinates();
            this.projectPoints();
        } else if ((n2 & 0x136) != 0) {
            this.computeCoordinates();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        if (this.levelZ != null) {
            this.drawColorCoded(graphics2D, n);
            return;
        }
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        int n2 = this.vertex[n].length;
        if (this.style.isDrawingFill()) {
            graphics2D.setPaint(drawingPanel3D.projectPaint(this.style.getFillColor(), this.objects[n].getDistance()));
            graphics2D.fillPolygon(this.a[n], this.b[n], n2);
        }
        if (this.style.isDrawingLines()) {
            graphics2D.setStroke(this.style.getLineStroke());
            graphics2D.setColor(drawingPanel3D.projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
            graphics2D.drawPolygon(this.a[n], this.b[n], n2);
        }
    }

    public void drawQuickly(Graphics2D graphics2D) {
        if (this.style.isDrawingFill() || this.drawQuickInterior) {
            Color color;
            Paint paint = this.style.getFillColor();
            if (this.drawQuickInterior && paint instanceof Color && (color = (Color)paint).getAlpha() > this.interiorTransparency) {
                paint = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            graphics2D.setPaint(paint);
            int n = 0;
            while (n < this.numberOfTiles) {
                graphics2D.fillPolygon(this.a[n], this.b[n], this.vertex[n].length);
                ++n;
            }
        }
        if (this.style.isDrawingLines()) {
            graphics2D.setStroke(this.style.getLineStroke());
            graphics2D.setColor(this.style.getLineColor());
            int n = 0;
            while (n < this.numberOfTiles) {
                graphics2D.drawPolygon(this.a[n], this.b[n], this.vertex[n].length);
                ++n;
            }
        }
    }

    protected final void computeVertex() {
        this.standardTile = this.computeTile();
        if (this.standardTile == null) {
            this.numberOfTiles = 0;
            return;
        }
        this.numberOfTiles = this.standardTile.length;
        this.vertex = new double[this.numberOfTiles][][];
        this.a = new int[this.numberOfTiles][];
        this.b = new int[this.numberOfTiles][];
        this.objects = new Object3D[this.numberOfTiles];
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.standardTile[n].length;
            this.vertex[n] = new double[n2][3];
            this.a[n] = new int[n2];
            this.b[n] = new int[n2];
            this.objects[n] = new Object3D(this, n);
            ++n;
        }
    }

    protected final void computeCoordinates() {
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = 0;
            int n3 = this.vertex[n].length;
            while (n2 < n3) {
                System.arraycopy(this.standardTile[n][n2], 0, this.vertex[n][n2], 0, 3);
                this.element.sizeAndToSpaceFrame(this.vertex[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    protected final void projectPoints() {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        double d = this.style.getDepthFactor();
        int n = 0;
        while (n < this.numberOfTiles) {
            int n2 = this.vertex[n].length;
            int n3 = 0;
            while (n3 < 3) {
                this.center[n3] = 0.0;
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                System.arraycopy(this.vertex[n][n3], 0, this.pixel, 0, 3);
                drawingPanel3D.projectPosition(this.pixel);
                this.a[n][n3] = (int)this.pixel[0];
                this.b[n][n3] = (int)this.pixel[1];
                int n4 = 0;
                while (n4 < 3) {
                    int n5 = n4;
                    this.center[n5] = this.center[n5] + this.vertex[n][n3][n4];
                    ++n4;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < 3) {
                int n6 = n3++;
                this.center[n6] = this.center[n6] / (double)n2;
            }
            drawingPanel3D.projectPosition(this.center);
            this.objects[n].setDistance(this.center[2] * d);
            ++n;
        }
    }

    public void setDrawQuickInterior(boolean bl, int n) {
        this.drawQuickInterior = bl;
        this.interiorTransparency = Math.max(0, Math.min(n, 255));
    }

    public void setColorBelowWhenEqual(boolean bl) {
        this.levelBelowWhenEqual = bl;
    }

    public void setColorOriginAndDirection(double[] dArray, double[] dArray2) {
        this.levelx = dArray[0];
        this.levely = dArray[1];
        this.levelz = dArray[2];
        this.leveldx = dArray2[0];
        this.leveldy = dArray2[1];
        this.leveldz = dArray2[2];
    }

    public void setColorRegions(double[] dArray, Color[] colorArray) {
        if (dArray == null || colorArray == null) {
            this.levelZ = null;
            this.levelColors = null;
            return;
        }
        this.levelZ = new double[dArray.length];
        this.levelColors = new Color[dArray.length + 1];
        int n = 0;
        while (n < dArray.length) {
            this.levelZ[n] = dArray[n];
            ++n;
        }
        n = 0;
        while (n < dArray.length + 1) {
            this.levelColors[n] = n < colorArray.length ? colorArray[n] : colorArray[colorArray.length - 1];
            ++n;
        }
    }

    private double levelScalarProduct(double[] dArray) {
        return (dArray[0] - this.levelx) * this.leveldx + (dArray[1] - this.levely) * this.leveldy + (dArray[2] - this.levelz) * this.leveldz;
    }

    private void drawColorCoded(Graphics2D graphics2D, int n) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = this.vertex[n].length;
        int[] nArray = new int[n5];
        if (this.levelBelowWhenEqual) {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = 0;
                d = this.levelScalarProduct(this.vertex[n][n4]);
                n3 = this.levelZ.length - 1;
                while (n3 >= 0) {
                    if (d > this.levelZ[n3]) {
                        nArray[n4] = n3 + 1;
                        break;
                    }
                    --n3;
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < n5) {
                nArray[n4] = this.levelZ.length;
                d = this.levelScalarProduct(this.vertex[n][n4]);
                n3 = 0;
                n2 = this.levelZ.length;
                while (n3 < n2) {
                    if (d < this.levelZ[n3]) {
                        nArray[n4] = n3;
                        break;
                    }
                    ++n3;
                }
                ++n4;
            }
        }
        int[] nArray2 = new int[n5 * 2];
        int[] nArray3 = new int[n5 * 2];
        int n6 = 0;
        n3 = this.levelZ.length;
        while (n6 <= n3) {
            n2 = 0;
            int n7 = 0;
            while (n7 < n5) {
                double d2;
                int n8 = (n7 + 1) % n5;
                if (nArray[n7] <= n6 && nArray[n8] >= n6) {
                    if (nArray[n7] == n6) {
                        nArray2[n2] = this.a[n][n7];
                        nArray3[n2] = this.b[n][n7];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (this.levelZ[n6 - 1] - d2) / (this.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                    if (nArray[n8] > n6) {
                        d2 = this.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (this.levelZ[n6] - d2) / (this.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                } else if (nArray[n7] >= n6 && nArray[n8] <= n6) {
                    if (nArray[n7] == n6) {
                        nArray2[n2] = this.a[n][n7];
                        nArray3[n2] = this.b[n][n7];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (this.levelZ[n6] - d2) / (this.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                    if (nArray[n8] < n6) {
                        d2 = this.levelScalarProduct(this.vertex[n][n7]);
                        d2 = (this.levelZ[n6 - 1] - d2) / (this.levelScalarProduct(this.vertex[n][n8]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][n7] + d2 * (double)(this.a[n][n8] - this.a[n][n7]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][n7] + d2 * (double)(this.b[n][n8] - this.b[n][n7]));
                        ++n2;
                    }
                }
                ++n7;
            }
            if (n2 > 0) {
                Color color = this.levelColors[n6];
                graphics2D.setPaint(color);
                graphics2D.fillPolygon(nArray2, nArray3, n2);
            }
            ++n6;
        }
        graphics2D.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.drawPolygon(this.a[n], this.b[n], n5);
    }
}

