/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import javax.swing.BorderFactory;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamEditor
extends FunctionEditor {
    protected double[] paramValues = new double[0];
    private DatasetManager data;
    private FunctionEditor[] functionEditors;

    public ParamEditor() {
        this.paramEditor = this;
    }

    public ParamEditor(DatasetManager datasetManager) {
        this();
        this.data = datasetManager;
        this.loadParametersFromData();
    }

    public Parameter[] getParameters() {
        Parameter[] parameterArray = new Parameter[this.objects.size()];
        int n = 0;
        while (n < this.objects.size()) {
            Parameter parameter = (Parameter)this.objects.get(n);
            parameterArray[n] = new Parameter(parameter.paramName, parameter.expression);
            parameterArray[n].setExpressionEditable(parameter.isExpressionEditable());
            parameterArray[n].setNameEditable(parameter.isNameEditable());
            parameterArray[n].setDescription(parameter.getDescription());
            parameterArray[n].value = parameter.value;
            ++n;
        }
        return parameterArray;
    }

    public void setParameters(Parameter[] parameterArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < parameterArray.length) {
            arrayList.add(parameterArray[n]);
            ++n;
        }
        this.setObjects(arrayList);
    }

    public void setFunctionEditors(FunctionEditor[] functionEditorArray) {
        this.functionEditors = functionEditorArray;
    }

    public double[] getValues() {
        return this.paramValues;
    }

    @Override
    public String getName(Object object) {
        return object == null ? null : ((Parameter)object).paramName;
    }

    @Override
    public String getExpression(Object object) {
        return object == null ? null : ((Parameter)object).expression;
    }

    @Override
    public String getTooltip(Object object) {
        String string = ((Parameter)object).getDescription();
        if (string == null) {
            string = ToolsRes.getString("ParamEditor.Table.Cell.Name.Tooltip");
        }
        return string;
    }

    @Override
    public boolean isNameEditable(Object object) {
        return ((Parameter)object).isNameEditable();
    }

    @Override
    public boolean isExpressionEditable(Object object) {
        return ((Parameter)object).isExpressionEditable();
    }

    protected void evaluateObject(Object object) {
        Parameter parameter = (Parameter)object;
        parameter.evaluate(this.objects);
    }

    public ArrayList<Parameter> evaluateDependents(Parameter parameter) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ArrayList<Parameter> arrayList2 = new ArrayList<Parameter>();
        int n = 0;
        while (n < this.evaluate.size()) {
            Parameter parameter2 = (Parameter)this.evaluate.get(n);
            if (parameter2.paramName.equals(parameter.paramName)) {
                Parameter parameter3;
                arrayList.add(parameter);
                arrayList2.add(parameter);
                int n2 = n + 1;
                while (n2 < this.evaluate.size()) {
                    parameter3 = (Parameter)this.evaluate.get(n2);
                    arrayList.add(new Parameter(parameter3.paramName, parameter3.expression));
                    ++n2;
                }
                n2 = 0;
                while (n2 < arrayList.size()) {
                    parameter3 = arrayList.get(n2);
                    parameter3.evaluate(arrayList);
                    if (this.getReferences(parameter3.getName(), null).isEmpty()) {
                        arrayList2.add(parameter3);
                    }
                    ++n2;
                }
                arrayList.removeAll(arrayList2);
                return arrayList;
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public void evaluateAll() {
        Parameter parameter;
        super.evaluateAll();
        if (this.getClass() != ParamEditor.class) {
            return;
        }
        if (this.paramValues.length != this.objects.size()) {
            this.paramValues = new double[this.objects.size()];
        }
        int n = 0;
        while (n < this.evaluate.size()) {
            parameter = (Parameter)this.evaluate.get(n);
            parameter.evaluate(this.objects);
            ++n;
        }
        n = 0;
        while (n < this.objects.size()) {
            parameter = (Parameter)this.objects.get(n);
            this.paramValues[n] = parameter.getValue();
            ++n;
        }
    }

    public void setDescription(String string, String string2) {
        for (Object e : this.objects) {
            Parameter parameter = (Parameter)e;
            if (!parameter.getName().equals(string)) continue;
            parameter.setDescription(string2);
            break;
        }
    }

    @Override
    protected boolean isDisallowedName(Object object, String string) {
        boolean bl = super.isDisallowedName(object, string);
        if (this.functionEditors != null) {
            int n = 0;
            while (n < this.functionEditors.length) {
                bl = bl || this.functionEditors[n].isDisallowedName(null, string);
                ++n;
            }
        }
        return bl;
    }

    @Override
    protected void paste() {
        XMLControl[] xMLControlArray = this.getClipboardContents();
        if (xMLControlArray == null) {
            return;
        }
        int n = 0;
        while (n < xMLControlArray.length) {
            Parameter parameter = (Parameter)xMLControlArray[n].loadObject(null);
            parameter.setNameEditable(true);
            parameter.setExpressionEditable(true);
            this.addObject(parameter, true);
            ++n;
        }
        this.evaluateAll();
    }

    @Override
    protected boolean isInvalidExpression(Object object) {
        return Double.isNaN(((Parameter)object).getValue());
    }

    @Override
    protected Object createObject(String string, String string2, Object object) {
        Parameter parameter = (Parameter)object;
        if (parameter != null && parameter.paramName.equals(string) && parameter.expression.equals(string2)) {
            return parameter;
        }
        Parameter parameter2 = new Parameter(string, string2);
        if (parameter != null) {
            parameter2.setExpressionEditable(parameter.isExpressionEditable());
            parameter2.setNameEditable(parameter.isNameEditable());
            parameter2.setDescription(parameter.getDescription());
        }
        return parameter2;
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.newButton.setToolTipText(ToolsRes.getString("ParamEditor.Button.New.Tooltip"));
        this.setBorder(BorderFactory.createTitledBorder(ToolsRes.getString("ParamEditor.Border.Title")));
    }

    public void loadParametersFromData() {
        String[] stringArray;
        if (this.data == null) {
            return;
        }
        String[] stringArray2 = stringArray = this.data.getConstantNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            String string2 = this.data.getConstantExpression(string);
            Parameter parameter = (Parameter)this.getObject(string);
            if (parameter == null) {
                parameter = new Parameter(string, string2);
                this.addObject(parameter, false);
            } else {
                this.setExpression(string, string2, false);
            }
            ++n2;
        }
    }

    protected void refreshParametersFromFunction(UserFunction userFunction) {
        int n = 0;
        while (n < userFunction.getParameterCount()) {
            String string = userFunction.getParameterName(n);
            String string2 = String.valueOf(userFunction.getParameterValue(n));
            Parameter parameter = (Parameter)this.getObject(string);
            if (parameter == null) {
                parameter = new Parameter(string, string2);
                parameter.setNameEditable(false);
                parameter.setExpressionEditable(false);
                this.addObject(parameter, false);
            } else {
                this.setExpression(string, string2, false);
            }
            ++n;
        }
    }

    @Override
    protected String getDefaultName() {
        return ToolsRes.getString("ParamEditor.New.Name.Default");
    }
}

