/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.colos.ejs.library.Input;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.colos.ejs.library.external.ExternalClient;

public abstract class AbstractModel
implements Model,
ExternalClient {
    protected String[] __theArguments = null;
    protected LauncherApplet __theApplet = null;
    protected ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public Memory _memory = new Memory();
    protected Input _input = new Input();
    protected ArrayList _scheduledConditionsList = new ArrayList();
    protected Hashtable _scheduledEventsList = new Hashtable();
    private _ControlSimulationExperimentClass _cSE = new _ControlSimulationExperimentClass();

    public abstract View getView();

    public abstract Simulation getSimulation();

    public LauncherApplet _getApplet() {
        return this.__theApplet;
    }

    public void _play() {
        this.getSimulation().play();
    }

    public void _playAndWait() {
        this._play();
        this._cSE._controlForSimulation();
    }

    public void _pause() {
        this.getSimulation().pause();
        this._cSE._controlForExperiment();
    }

    public void _step() {
        this._pause();
        this.getSimulation().step();
    }

    public void _setFPS(int n) {
        this.getSimulation().setFPS(n);
    }

    public void _setDelay(int n) {
        this.getSimulation().setDelay(n);
    }

    public int _getDelay() {
        if (this.getSimulation() != null) {
            return this.getSimulation().getDelay();
        }
        return 0;
    }

    public void _setStepsPerDisplay(int n) {
        this.getSimulation().setStepsPerDisplay(n);
    }

    public void _setUpdateView(boolean bl) {
        this.getSimulation().setUpdateView(bl);
    }

    public void _reset() {
        this._external.reset();
        this.getSimulation().reset();
    }

    public void _initialize() {
        this._external.reset();
        this.getSimulation().initialize();
    }

    public void _alert(String string, String string2, String string3) {
        if (this.getView() != null) {
            JOptionPane.showMessageDialog(this.getView().getComponent(string), string3, string2, 1);
        } else {
            JOptionPane.showMessageDialog(this.getSimulation().getParentComponent(), string3, string2, 1);
        }
    }

    public void _print(String string) {
        if (this.getView() != null) {
            this.getView().print(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println(String string) {
        if (this.getView() != null) {
            this.getView().println(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println() {
        if (this.getView() != null) {
            this.getView().println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this.getView() != null) {
            this.getView().clearMessages();
        }
    }

    public String _format(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public String _getParameter(String string) {
        if (this.__theApplet != null) {
            return this.__theApplet.getParameter(string);
        }
        if (this.__theArguments == null) {
            return null;
        }
        int n = 0;
        while (n < this.__theArguments.length) {
            if (this.__theArguments[n].equals("-" + string) && n + 1 < this.__theArguments.length) {
                return this.__theArguments[n + 1];
            }
            ++n;
        }
        return null;
    }

    public String[] _getArguments() {
        return this.__theArguments;
    }

    public boolean _isPlaying() {
        return this.getSimulation().isPlaying();
    }

    public boolean _isPaused() {
        return this.getSimulation().isPaused();
    }

    public boolean _isApplet() {
        return this.__theApplet != null;
    }

    public void _setParentComponent(String string) {
        this.getSimulation().setParentComponent(string);
    }

    public boolean _saveImage(String string, String string2) {
        return this.getSimulation().saveImage(string, string2);
    }

    public boolean _saveState(String string) {
        return this.getSimulation().saveState(string);
    }

    public boolean _saveVariables(String string, String string2) {
        return this.getSimulation().saveVariables(string, string2);
    }

    public boolean _saveVariables(String string, ArrayList arrayList) {
        return this.getSimulation().saveVariables(string, arrayList);
    }

    public boolean _saveText(String string, String string2) {
        return this.getSimulation().saveText(string, string2);
    }

    public boolean _saveText(String string, StringBuffer stringBuffer) {
        return this.getSimulation().saveText(string, stringBuffer);
    }

    public boolean _readState(String string) {
        return this.getSimulation().readState(string);
    }

    public boolean _readVariables(String string, String string2) {
        return this.getSimulation().readVariables(string, null, string2);
    }

    public boolean _readVariables(String string, ArrayList arrayList) {
        URL uRL = null;
        if (this.__theApplet != null) {
            uRL = this.__theApplet.getCodeBase();
        }
        return this.getSimulation().readVariables(string, uRL, arrayList);
    }

    public String _readText(String string) {
        return this.getSimulation().readText(string);
    }

    public boolean _setVariables(String string, String string2, String string3) {
        return this.getSimulation().setVariables(string, string2, string3);
    }

    public boolean _setVariables(String string) {
        return this.getSimulation().setVariables(string);
    }

    public String _getVariables(String string) {
        return this.getSimulation().getVariable(string);
    }

    public void _clearView() {
        if (this.getView() != null) {
            this.getView().initialize();
        }
    }

    public void _resetView() {
        if (this.getView() != null) {
            this.getView().reset();
            this.getView().initialize();
        }
    }

    public void _onExit() {
        this.getSimulation().onExit();
        this._external.quit();
    }

    public abstract void _resetSolvers();

    public void _resetIC() {
        this._resetSolvers();
    }

    public abstract String _externalInitCommand(String var1);

    public abstract void _externalSetValues(boolean var1, ExternalApp var2);

    public abstract void _externalGetValues(boolean var1, ExternalApp var2);

    public synchronized void _externalGetValuesAndUpdate(boolean bl, ExternalApp externalApp) {
        this._externalGetValues(bl, externalApp);
        this.getSimulation().update();
    }

    private class _ControlSimulationExperimentClass {
        private _ControlSimulationExperimentClass() {
        }

        public synchronized void _controlForSimulation() {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }

        public synchronized void _controlForExperiment() {
            this.notify();
        }
    }
}

