/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;

public class ClipInspector
extends JDialog {
    protected VideoClip clip;
    protected ClipControl clipControl;
    protected Video inVid;
    protected Video outVid;
    protected DrawingPanel inPanel;
    protected DrawingPanel outPanel;
    protected JPanel dataPanel;
    protected JLabel startLabel;
    protected JLabel stepSizeLabel;
    protected JLabel t0Label;
    protected JLabel endLabel;
    protected JLabel dtLabel;
    protected JLabel rateLabel;
    protected IntegerField startField;
    protected IntegerField stepSizeField;
    protected NumberField t0Field;
    protected IntegerField endField;
    protected NumberField dtField;
    protected NumberField rateField;
    protected JButton okButton;
    protected JButton cancelButton;
    protected int prevFrame;
    protected int prevStart;
    protected int prevSize;
    protected int prevCount;
    protected double prevDt;
    protected double prevRate;

    public ClipInspector(VideoClip videoClip) {
        super((Frame)null, true);
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.setResizable(false);
        this.clip = videoClip;
        this.createGUI();
        this.initialize();
        this.pack();
    }

    public ClipInspector(VideoClip videoClip, Frame frame) {
        super(frame, false);
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.setResizable(false);
        this.clip = videoClip;
        this.createGUI();
        this.initialize();
        this.pack();
    }

    public ClipInspector(VideoClip videoClip, ClipControl clipControl) {
        super((Frame)null, true);
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.setResizable(false);
        this.clip = videoClip;
        this.clipControl = clipControl;
        this.createGUI();
        this.createClipControlGUI();
        this.initialize();
        this.pack();
    }

    public ClipInspector(VideoClip videoClip, ClipControl clipControl, Frame frame) {
        super(frame, false);
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.setResizable(false);
        this.clip = videoClip;
        this.clipControl = clipControl;
        this.createGUI();
        this.createClipControlGUI();
        this.initialize();
        this.pack();
    }

    public void setStartFrameEnabled(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ClipInspector.this.startField.setEnabled(bl);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setStepSizeEnabled(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ClipInspector.this.stepSizeField.setEnabled(bl);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setStepCountEnabled(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                ClipInspector.this.endField.setEnabled(bl);
            }
        };
        try {
            EventQueue.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initialize() {
        Video video;
        this.updateDisplay();
        this.prevStart = this.clip.getStartFrameNumber();
        this.prevSize = this.clip.getStepSize();
        this.prevCount = this.clip.getStepCount();
        if (this.clipControl != null) {
            this.prevDt = this.clipControl.getMeanFrameDuration();
            this.prevRate = this.clipControl.getRate();
        }
        if ((video = this.clip.getVideo()) != null) {
            this.prevFrame = video.getFrameNumber();
        }
    }

    public void refresh() {
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.startLabel.setText(MediaRes.getString("ClipInspector.Label.StartFrame"));
        this.stepSizeLabel.setText(MediaRes.getString("ClipInspector.Label.StepSize"));
        this.t0Label.setText(MediaRes.getString("ClipInspector.Label.StartTime"));
        this.endLabel.setText(MediaRes.getString("ClipInspector.Label.EndFrame"));
        this.cancelButton.setText(MediaRes.getString("Dialog.Button.Cancel"));
        this.okButton.setText(MediaRes.getString("Dialog.Button.OK"));
        if (this.inPanel != null) {
            this.inPanel.setMessage(MediaRes.getString("ClipInspector.StartFrame.Message"));
            this.outPanel.setMessage(MediaRes.getString("ClipInspector.EndFrame.Message"));
        }
        if (this.clipControl != null) {
            this.dtLabel.setText(MediaRes.getString("ClipInspector.Label.DeltaT"));
            this.rateLabel.setText(MediaRes.getString("ClipInspector.Label.PlayRate"));
        }
        this.pack();
    }

    private void createGUI() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        Video video = this.clip.getVideo();
        if (video != null && video.getFrameCount() > 1) {
            this.inVid = VideoIO.clone(video);
            if (this.inVid != null) {
                this.outVid = VideoIO.clone(video);
                object = new JPanel(new GridLayout(1, 2));
                ((JComponent)object).setBorder(BorderFactory.createEtchedBorder());
                jPanel.add((Component)object, "Center");
                this.inVid.setWidth(1.0);
                this.inPanel = new DrawingPanel();
                this.inPanel.setAutoscaleMargin(0.0);
                this.inPanel.setPreferredSize(new Dimension(160, 120));
                this.inPanel.addDrawable(this.inVid);
                this.inPanel.setMessage(MediaRes.getString("ClipInspector.StartFrame.Message"));
                ((Container)object).add(this.inPanel);
                this.outVid.setWidth(1.0);
                this.outPanel = new DrawingPanel();
                this.outPanel.setAutoscaleMargin(0.0);
                this.outPanel.setPreferredSize(new Dimension(160, 120));
                this.outPanel.addDrawable(this.outVid);
                this.outPanel.setMessage(MediaRes.getString("ClipInspector.EndFrame.Message"));
                ((Container)object).add(this.outPanel);
            }
        }
        this.startLabel = new JLabel(MediaRes.getString("ClipInspector.Label.StartFrame"));
        this.startLabel.setAlignmentX(1.0f);
        this.startLabel.setForeground(new Color(0, 0, 102));
        this.startLabel.setFont(new Font("Dialog", 0, 12));
        this.startField = new IntegerField(4);
        this.startField.setMaximumSize(this.startField.getPreferredSize());
        this.startField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clip.setStartFrameNumber(ClipInspector.this.startField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.startField.selectAll();
            }
        });
        this.startField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.startField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clip.setStartFrameNumber(ClipInspector.this.startField.getIntValue());
                ClipInspector.this.updateDisplay();
            }
        });
        this.stepSizeLabel = new JLabel(MediaRes.getString("ClipInspector.Label.StepSize"));
        this.stepSizeLabel.setAlignmentX(1.0f);
        this.stepSizeLabel.setForeground(new Color(0, 0, 102));
        this.stepSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.stepSizeField = new IntegerField(4);
        this.stepSizeField.setMaximumSize(this.stepSizeField.getPreferredSize());
        this.stepSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clip.setStepSize(ClipInspector.this.stepSizeField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.stepSizeField.selectAll();
            }
        });
        this.stepSizeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.stepSizeField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clip.setStepSize(ClipInspector.this.stepSizeField.getIntValue());
                ClipInspector.this.updateDisplay();
            }
        });
        this.endLabel = new JLabel(MediaRes.getString("ClipInspector.Label.EndFrame"));
        this.endLabel.setAlignmentX(1.0f);
        this.endLabel.setForeground(new Color(0, 0, 102));
        this.endLabel.setFont(new Font("Dialog", 0, 12));
        this.endField = new IntegerField(4);
        this.endField.setMaximumSize(this.endField.getPreferredSize());
        this.endField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clip.setEndFrameNumber(ClipInspector.this.endField.getIntValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.endField.selectAll();
            }
        });
        this.endField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.endField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clip.setEndFrameNumber(ClipInspector.this.endField.getIntValue());
                ClipInspector.this.updateDisplay();
            }
        });
        this.t0Label = new JLabel(MediaRes.getString("ClipInspector.Label.StartTime"));
        this.t0Label.setAlignmentX(1.0f);
        this.t0Label.setForeground(new Color(0, 0, 102));
        this.t0Label.setFont(new Font("Dialog", 0, 12));
        this.t0Field = new DecimalField(4, 3);
        this.t0Field.setUnits(" s");
        this.t0Field.setMaximumSize(this.t0Field.getPreferredSize());
        this.t0Field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clip.setStartTime(ClipInspector.this.t0Field.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
                ClipInspector.this.t0Field.selectAll();
            }
        });
        this.t0Field.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.t0Field.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clip.setStartTime(ClipInspector.this.t0Field.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
            }
        });
        this.dataPanel = new JPanel(new GridLayout(1, 3));
        object = BorderFactory.createLineBorder(Color.GRAY);
        Border border = BorderFactory.createEmptyBorder(2, 6, 2, 6);
        this.dataPanel.setBorder(BorderFactory.createCompoundBorder((Border)object, border));
        jPanel2.add((Component)this.dataPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)this.startField, gridBagConstraints);
        this.dataPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel4.add((Component)this.stepSizeLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel4.add((Component)this.stepSizeField, gridBagConstraints);
        this.dataPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel5.add((Component)this.endLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel5.add((Component)this.endField, gridBagConstraints);
        this.dataPanel.add(jPanel5);
        this.cancelButton = new JButton(MediaRes.getString("Dialog.Button.Cancel"));
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.revert();
                ClipInspector.this.setVisible(false);
            }
        });
        this.okButton = new JButton(MediaRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.setVisible(false);
            }
        });
        JPanel jPanel6 = new JPanel(new GridLayout(1, 4));
        jPanel6.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        jPanel2.add((Component)jPanel6, "South");
        jPanel6.add(Box.createHorizontalBox());
        jPanel6.add(this.okButton);
        jPanel6.add(this.cancelButton);
        jPanel6.add(Box.createHorizontalBox());
    }

    private void createClipControlGUI() {
        this.dtLabel = new JLabel(MediaRes.getString("ClipInspector.Label.DeltaT"));
        this.dtLabel.setAlignmentX(1.0f);
        this.dtLabel.setForeground(new Color(0, 0, 102));
        this.dtLabel.setFont(new Font("Dialog", 0, 12));
        this.dtField = new DecimalField(4, 3);
        this.dtField.setUnits(" s");
        this.dtField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clipControl.setFrameDuration(ClipInspector.this.dtField.getValue() * 1000.0 / (double)ClipInspector.this.clip.getStepSize());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.dtField.selectAll();
            }
        });
        this.dtField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.dtField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clipControl.setFrameDuration(ClipInspector.this.dtField.getValue() * 1000.0 / (double)ClipInspector.this.clip.getStepSize());
                ClipInspector.this.updateDisplay();
            }
        });
        this.rateLabel = new JLabel(MediaRes.getString("ClipInspector.Label.PlayRate"));
        this.rateLabel.setAlignmentX(1.0f);
        this.rateLabel.setForeground(new Color(0, 0, 102));
        this.rateLabel.setFont(new Font("Dialog", 0, 12));
        this.rateField = new NumberField(4);
        char c = this.rateField.format.getDecimalFormatSymbols().getDecimalSeparator();
        String string = "0" + c + "0E0";
        String string2 = "0";
        this.rateField.setPatterns(new String[]{string, string2, string2, string2, string});
        this.rateField.setMaxValue(1000000.0);
        this.rateField.setUnits("%");
        this.rateField.setMinValue(1.0E-6);
        this.rateField.setMaximumSize(this.rateField.getPreferredSize());
        this.rateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clipControl.setRate(ClipInspector.this.rateField.getValue() / 100.0);
                ClipInspector.this.updateDisplay();
                ClipInspector.this.rateField.selectAll();
            }
        });
        this.rateField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.rateField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clipControl.setRate(ClipInspector.this.rateField.getValue() / 100.0);
                ClipInspector.this.updateDisplay();
            }
        });
        this.dataPanel.setLayout(new GridLayout(2, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.t0Label, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.t0Field, gridBagConstraints);
        this.dataPanel.add(jPanel);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)this.dtLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel2.add((Component)this.dtField, gridBagConstraints);
        this.dataPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        jPanel3.add((Component)this.rateLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        jPanel3.add((Component)this.rateField, gridBagConstraints);
        this.dataPanel.add(jPanel3);
    }

    public void updateDisplay() {
        if (this.inVid != null) {
            this.inVid.setFrameNumber(this.clip.getStartFrameNumber());
            this.outVid.setFrameNumber(this.clip.getEndFrameNumber());
        }
        this.startField.setIntValue(this.clip.getStartFrameNumber());
        this.stepSizeField.setIntValue(this.clip.getStepSize());
        this.t0Field.setValue(this.clip.getStartTime() / 1000.0);
        this.endField.setIntValue(this.clip.getEndFrameNumber());
        if (this.clipControl != null) {
            this.dtField.setValue((double)this.clip.getStepSize() * this.clipControl.getMeanFrameDuration() / 1000.0);
            this.rateField.setValue(100.0 * this.clipControl.getRate());
        }
        this.repaint();
    }

    private void revert() {
        Video video;
        this.clip.setStartFrameNumber(this.prevStart);
        this.clip.setStepSize(this.prevSize);
        this.clip.setStepCount(this.prevCount);
        if (this.clipControl != null) {
            this.clipControl.setRate(this.prevRate);
            this.clipControl.setFrameDuration(this.prevDt);
        }
        if ((video = this.clip.getVideo()) != null) {
            video.setFrameNumber(this.prevFrame);
        }
    }
}

