/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.CellBorder;
import org.opensourcephysics.display.DataRowModel;

public class DataRowTable
extends JTable
implements ActionListener {
    static final Color PANEL_BACKGROUND = UIManager.getColor("Panel.background");
    static final Color LIGHT_BLUE = new Color(204, 204, 255);
    protected int labelColumnWidth = 40;
    DataRowModel rowModel = new DataRowModel();
    RowNumberRenderer indexRenderer = new RowNumberRenderer();
    CellRenderer cellRenderer = new CellRenderer();
    String formatPattern = "0.000";
    DecimalFormat defaultFormat = new DecimalFormat(this.formatPattern);
    int refreshDelay = 0;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    Dictionary<Integer, DecimalFormat> formats = new Hashtable<Integer, DecimalFormat>();

    public DataRowTable() {
        this.init();
    }

    protected void init() {
        TableColumn tableColumn;
        String string;
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(this.rowModel);
        this.setColumnSelectionAllowed(true);
        this.setGridColor(Color.blue);
        this.setSelectionBackground(LIGHT_BLUE);
        this.setSelectionForeground(Color.red);
        this.setColumnModel(new DataTableColumnModel());
        this.setSelectionMode(1);
        this.setColumnSelectionAllowed(true);
        this.rowModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                DataRowTable.this.firePropertyChange("cell", null, tableModelEvent);
            }
        });
        this.setDefaultRenderer(Object.class, this.cellRenderer);
        this.getTableHeader().setForeground(Color.blue);
        this.getTableHeader().setReorderingAllowed(true);
        this.getTableHeader().setDefaultRenderer(new HeaderRenderer());
        this.setAutoResizeMode(0);
        int n = 24;
        if (this.getColumnCount() > 0) {
            string = this.getColumnName(0);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(2 * n);
            tableColumn.setWidth(n);
        }
        n = 60;
        int n2 = 1;
        int n3 = this.getColumnCount();
        while (n2 < n3) {
            string = this.getColumnName(n2);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(3 * n);
            tableColumn.setWidth(n);
            ++n2;
        }
    }

    public void setRefreshDelay(int n) {
        if (n > 0) {
            this.refreshTimer.setDelay(n);
            this.refreshTimer.setInitialDelay(n);
        } else if (n <= 0) {
            this.refreshTimer.stop();
        }
        this.refreshDelay = n;
    }

    public void setNumericFormat(String string) {
        if (string != null && !string.equals(this.formatPattern)) {
            this.formatPattern = string;
            this.defaultFormat = new DecimalFormat(string);
            this.refreshTable();
        }
    }

    public void setColumnFormat(int n, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        DecimalFormat decimalFormat2 = this.formats.get(n);
        if (decimalFormat2 != null && decimalFormat2.equals(decimalFormat)) {
            return;
        }
        this.formats.put(n, decimalFormat);
        this.refreshTable();
    }

    public synchronized void clearData() {
        this.rowModel.rowList.clear();
        this.rowModel.colCount = 0;
        this.refreshTable();
    }

    public synchronized void clear() {
        this.rowModel.rowList.clear();
        this.rowModel.colNames.clear();
        this.rowModel.colCount = 0;
        this.formats = new Hashtable<Integer, DecimalFormat>();
        this.refreshTable();
    }

    public void setStride(int n) {
        if (this.rowModel.stride == (n = Math.max(1, n))) {
            return;
        }
        this.rowModel.setStride(n);
        this.refreshTable();
    }

    public void refreshTable() {
        if (this.refreshDelay > 0) {
            this.refreshTimer.start();
        } else {
            Runnable runnable = new Runnable(){

                public synchronized void run() {
                    DataRowTable.this.tableChanged(new TableModelEvent(DataRowTable.this.getModel(), -1));
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0 && this.rowModel.rowNumberVisible) {
            return this.indexRenderer;
        }
        return this.cellRenderer;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tableChanged(new TableModelEvent(this.getModel(), -1));
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        public CellRenderer() {
            this.setHorizontalAlignment(4);
            this.setBorder(new CellBorder(new Color(224, 224, 224)));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DecimalFormat decimalFormat;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!DataRowTable.this.rowModel.rowNumberVisible) {
                ++n2;
            }
            if ((decimalFormat = DataRowTable.this.formats.get(n2)) == null) {
                decimalFormat = DataRowTable.this.defaultFormat;
            }
            if (object == null) {
                this.setText("");
            } else if (object instanceof String) {
                this.setText((String)object);
            } else if (decimalFormat == null) {
                this.setText(object.toString());
            } else {
                try {
                    this.setText(decimalFormat.format(object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.setText(object.toString());
                }
            }
            return this;
        }
    }

    private class DataTableColumnModel
    extends DefaultTableColumnModel {
        private DataTableColumnModel() {
        }

        public TableColumn getColumn(int n) {
            TableColumn tableColumn;
            try {
                tableColumn = super.getColumn(n);
            }
            catch (Exception exception) {
                return new TableColumn();
            }
            String string = (String)tableColumn.getHeaderValue();
            if (string == null) {
                return tableColumn;
            }
            if (string.equals("row")) {
                tableColumn.setMaxWidth(DataRowTable.this.labelColumnWidth);
                tableColumn.setMinWidth(DataRowTable.this.labelColumnWidth);
                tableColumn.setResizable(true);
            }
            return tableColumn;
        }
    }

    private class HeaderRenderer
    extends RowNumberRenderer {
        public HeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setForeground(Color.BLUE);
            this.setBorder(BorderFactory.createLineBorder(new Color(224, 224, 224)));
        }
    }

    private static class RowNumberRenderer
    extends JLabel
    implements TableCellRenderer {
        public RowNumberRenderer() {
            this.setHorizontalAlignment(4);
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(PANEL_BACKGROUND);
            this.setBorder(new CellBorder(new Color(224, 224, 224)));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.isRowSelected(n)) {
                int[] nArray = jTable.getSelectedColumns();
                if (nArray.length == 1 && jTable.convertColumnIndexToModel(nArray[0]) == 0) {
                    this.setBackground(PANEL_BACKGROUND);
                } else {
                    this.setBackground(Color.gray);
                }
            } else {
                this.setBackground(PANEL_BACKGROUND);
            }
            this.setText(object.toString());
            return this;
        }
    }
}

