/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoClip {
    private int startFrame = 0;
    private int stepSize = 1;
    private int stepCount = 10;
    private double startTime = 0.0;
    protected Video video = null;
    private int[] stepFrames;
    ClipInspector inspector;
    private PropertyChangeSupport support = new SwingPropertyChangeSupport(this);

    public VideoClip(Video video) {
        this.video = video;
        if (video != null) {
            video.setProperty("videoclip", this);
            this.setStartFrameNumber(video.getStartFrameNumber());
            if (video.getFrameCount() > 1) {
                this.setStepCount(video.getEndFrameNumber() - this.startFrame + 1);
            }
        }
        this.updateArray();
    }

    public Video getVideo() {
        return this.video;
    }

    public void setStartFrameNumber(int n) {
        if (this.startFrame == n) {
            return;
        }
        n = Math.abs(n);
        int n2 = this.startFrame + this.stepSize * (this.stepCount - 1);
        if (this.video != null && this.video.getFrameCount() > 1) {
            this.video.setEndFrameNumber(this.video.getFrameCount() - 1);
            this.video.setStartFrameNumber(n);
            this.startFrame = this.video.getStartFrameNumber();
            int n3 = Math.max(this.video.getFrameCount() - this.startFrame - 1, 1);
            if (n3 < this.stepSize) {
                this.stepSize = n3;
            }
        } else {
            this.startFrame = n;
            this.updateArray();
        }
        this.setEndFrameNumber(n2);
        this.support.firePropertyChange("startframe", null, new Integer(n));
    }

    public int getStartFrameNumber() {
        return this.startFrame;
    }

    public void setStepSize(int n) {
        int n2;
        if (n == 0) {
            return;
        }
        n = Math.abs(n);
        if (this.video != null && this.video.getFrameCount() > 1) {
            n2 = Math.max(this.video.getFrameCount() - this.startFrame - 1, 1);
            n = Math.min(n, n2);
        }
        if (this.stepSize != n) {
            n2 = this.startFrame + this.stepSize * (this.stepCount - 1);
            this.stepSize = n;
            this.support.firePropertyChange("stepsize", null, new Integer(n));
            this.setEndFrameNumber(n2);
        }
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepCount(int n) {
        if (n == 0) {
            return;
        }
        n = Math.abs(n);
        if (this.video != null) {
            int n2;
            if (this.video.getFrameCount() > 1) {
                n2 = this.video.getFrameCount() - 1;
                int n3 = 1 + (int)((double)(n2 - this.startFrame) / (1.0 * (double)this.stepSize));
                n = Math.min(n, n3);
            }
            if ((n2 = this.startFrame + (n - 1) * this.stepSize) != this.video.getEndFrameNumber()) {
                this.video.setEndFrameNumber(n2);
            }
            if (this.getClipInspector() != null) {
                ClipControl clipControl = this.getClipInspector().clipControl;
                final int n4 = this.stepToFrame(clipControl.stepNumber);
                if (this.video.getFrameNumber() != n4) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            VideoClip.this.video.setFrameNumber(n4);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
        Integer n5 = new Integer(this.stepCount);
        this.stepCount = Math.max(n, 1);
        this.updateArray();
        this.support.firePropertyChange("stepcount", n5, new Integer(n));
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStartTime(double d) {
        if (this.startTime == d) {
            return;
        }
        this.startTime = Double.isNaN(d) ? 0.0 : d;
        this.support.firePropertyChange("starttime", null, new Double(this.startTime));
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getEndFrameNumber() {
        return this.startFrame + this.stepSize * (this.stepCount - 1);
    }

    public void setEndFrameNumber(int n) {
        n = Math.max(n, this.startFrame);
        int n2 = (n - this.startFrame) % this.stepSize;
        int n3 = (n - this.startFrame) / this.stepSize;
        if ((double)n2 * 1.0 / (double)this.stepSize > 0.5) {
            ++n3;
        }
        this.setStepCount(n3 + 1);
    }

    public int stepToFrame(int n) {
        return this.startFrame + n * this.stepSize;
    }

    public int frameToStep(int n) {
        return (int)((double)(n - this.startFrame) / (1.0 * (double)this.stepSize));
    }

    public boolean includesFrame(int n) {
        int n2 = 0;
        while (n2 < this.stepCount) {
            if (this.stepFrames[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ClipInspector getClipInspector() {
        return this.inspector;
    }

    public ClipInspector getClipInspector(Frame frame) {
        if (this.inspector == null) {
            this.inspector = new ClipInspector(this, frame);
        }
        return this.inspector;
    }

    public ClipInspector getClipInspector(ClipControl clipControl, Frame frame) {
        if (this.inspector == null) {
            this.inspector = new ClipInspector(this, clipControl, frame);
        }
        return this.inspector;
    }

    public void hideClipInspector() {
        if (this.inspector != null) {
            this.inspector.setVisible(false);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    private void updateArray() {
        this.stepFrames = new int[this.stepCount];
        int n = 0;
        while (n < this.stepCount) {
            this.stepFrames[n] = this.stepToFrame(n);
            ++n;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            VideoClip videoClip = (VideoClip)object;
            Video video = videoClip.getVideo();
            if (video != null) {
                if (video instanceof ImageVideo) {
                    ImageVideo imageVideo = (ImageVideo)video;
                    if (imageVideo.isFileBased()) {
                        xMLControl.setValue("video", video);
                    }
                } else {
                    xMLControl.setValue("video", video);
                }
            }
            xMLControl.setValue("startframe", videoClip.getStartFrameNumber());
            xMLControl.setValue("stepsize", videoClip.getStepSize());
            xMLControl.setValue("stepcount", videoClip.getStepCount());
            xMLControl.setValue("starttime", videoClip.getStartTime());
        }

        public Object createObject(XMLControl xMLControl) {
            int n;
            boolean bl = xMLControl.getPropertyNames().contains("video");
            if (!bl) {
                return new VideoClip(null);
            }
            ResourceLoader.addSearchPath(xMLControl.getString("basepath"));
            XMLControl xMLControl2 = xMLControl.getChildControl("video");
            String string = xMLControl2.getString("path");
            Video video = null;
            boolean bl2 = true;
            try {
                video = (Video)xMLControl.getObject("video");
            }
            catch (Exception exception) {
                bl2 = false;
            }
            catch (Error error) {
                bl2 = false;
            }
            if (!bl2) {
                OSPLog.info("\"" + string + "\" could not be opened");
                JOptionPane.showMessageDialog(null, String.valueOf(MediaRes.getString("VideoClip.Dialog.BadVideo.Message")) + string, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 2);
            } else if (video == null && string != null && (n = JOptionPane.showConfirmDialog(null, "\"" + string + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message"), MediaRes.getString("VideoClip.Dialog.VideoNotFound.Title"), 0, 2)) == 0) {
                VideoIO.getChooser().setFileFilter(VideoIO.videoFileFilter);
                VideoIO.getChooser().setSelectedFile(new File(string));
                File[] fileArray = VideoIO.getChooserFiles("open");
                if (fileArray != null) {
                    video = VideoIO.getVideo(fileArray[0]);
                }
            }
            return new VideoClip(video);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            double d;
            VideoClip videoClip = (VideoClip)object;
            int n = xMLControl.getInt("startframe");
            if (n != Integer.MIN_VALUE) {
                videoClip.setStartFrameNumber(n);
            }
            if ((n = xMLControl.getInt("stepsize")) != Integer.MIN_VALUE) {
                videoClip.setStepSize(n);
            }
            if ((n = xMLControl.getInt("stepcount")) != Integer.MIN_VALUE) {
                videoClip.setStepCount(n);
            }
            if (!Double.isNaN(d = xMLControl.getDouble("starttime"))) {
                videoClip.setStartTime(d);
            }
            return object;
        }
    }
}

