/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import org.colos.ejs.library.Simulation;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolForDataInfo {
    private String name;
    private String[] columnNames;
    private Color lineColor;
    private Color fillColor;
    private double[][] data;

    public ToolForDataInfo(String string, String[] stringArray, Color color, Color color2, double[][] dArray) {
        this.name = string;
        this.columnNames = stringArray;
        this.lineColor = color;
        this.fillColor = color2;
        this.data = dArray;
    }

    public double[][] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public static List<ToolForDataInfo> getToolForDataUsersList(DrawingPanel drawingPanel) {
        ArrayList<ToolForDataInfo> arrayList = new ArrayList<ToolForDataInfo>();
        for (Drawable drawable : drawingPanel.getDrawables()) {
            if (!(drawable instanceof ToolForDataUser)) continue;
            ToolForDataUser toolForDataUser = (ToolForDataUser)((Object)drawable);
            List<ToolForDataUser> list = toolForDataUser.getToolForDataUsers();
            if (list == null) {
                arrayList.add(toolForDataUser.getToolForDataInfo());
                continue;
            }
            for (ToolForDataUser toolForDataUser2 : list) {
                arrayList.add(toolForDataUser2.getToolForDataInfo());
            }
        }
        return arrayList;
    }

    public static void showPopup(final ToolForDataUser toolForDataUser, final Component component, int n, int n2) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolForData.getTool().showTable(component, toolForDataUser.getToolForDataInfo());
            }
        });
        jPopupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetTool")){

            public void actionPerformed(ActionEvent actionEvent) {
                ToolForData.getTool().showDataTool(component, toolForDataUser.getToolForDataInfo());
            }
        });
        jPopupMenu.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetManager")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!(component instanceof DrawingPanel)) {
                    return;
                }
                ToolForData.getTool().showDataTool(component, ToolForDataInfo.getToolForDataUsersList((DrawingPanel)component));
            }
        });
        jPopupMenu.show(component, n, n2);
    }
}

