/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Point;
import org.opensourcephysics.display2d.ComplexSurfacePlot;

public final class ComplexSurfaceVertex {
    ComplexSurfacePlot surface;
    private Point projection;
    private int project_index;
    public double x;
    public double y;
    public double z;
    public double re;
    public double im;

    ComplexSurfaceVertex(double d, double d2, double d3, double d4, double d5, ComplexSurfacePlot complexSurfacePlot) {
        this.surface = complexSurfacePlot;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.re = d4;
        this.im = d5;
        this.project_index = complexSurfacePlot.master_project_indexV - 1;
    }

    public final boolean isInvalid() {
        return Double.isNaN(this.z);
    }

    public final Point projection() {
        if (this.project_index != this.surface.master_project_indexV) {
            this.projection = this.surface.projector.project(this.x, this.y, (this.z - this.surface.zminV) * this.surface.zfactorV - 10.0);
            this.project_index = this.surface.master_project_indexV;
        }
        return this.projection;
    }

    public final void project() {
        this.projection = this.surface.projector.project(this.x, this.y, (this.z - this.surface.zminV) * this.surface.zfactorV - 10.0);
    }

    public final void transform() {
        this.x /= this.surface.projector.getXScaling();
        this.y /= this.surface.projector.getYScaling();
        this.z = (this.surface.zmaxV - this.surface.zminV) * (this.z / this.surface.projector.getZScaling() + 10.0) / 20.0 + this.surface.zminV;
    }
}

