/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Point;
import java.awt.Rectangle;

public final class SurfacePlotProjector {
    private double scale_x;
    private double scale_y;
    private double scale_z;
    private double distance;
    private double _2D_scale;
    private double rotation;
    private double elevation;
    private double sin_rotation;
    private double cos_rotation;
    private double sin_elevation;
    private double cos_elevation;
    private int _2D_trans_x;
    private int _2D_trans_y;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int center_x;
    private int center_y;
    private int trans_x;
    private int trans_y;
    private double factor;
    private double sx_cos;
    private double sy_cos;
    private double sz_cos;
    private double sx_sin;
    private double sy_sin;
    private double sz_sin;
    private final double DEGTORAD = Math.PI / 180;

    SurfacePlotProjector() {
        this.setScaling(1.0);
        this.setRotationAngle(0.0);
        this.setElevationAngle(0.0);
        this.setDistance(10.0);
        this.set2DScaling(1.0);
        this.set2DTranslation(0, 0);
    }

    public void setProjectionArea(Rectangle rectangle) {
        this.x1 = rectangle.x;
        this.x2 = this.x1 + rectangle.width;
        this.y1 = rectangle.y;
        this.y2 = this.y1 + rectangle.height;
        this.center_x = (this.x1 + this.x2) / 2;
        this.center_y = (this.y1 + this.y2) / 2;
        this.trans_x = this.center_x + this._2D_trans_x;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public void setRotationAngle(double d) {
        this.rotation = d;
        this.sin_rotation = Math.sin(d * (Math.PI / 180));
        this.cos_rotation = Math.cos(d * (Math.PI / 180));
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
    }

    public double getRotationAngle() {
        return this.rotation;
    }

    public double getSinRotationAngle() {
        return this.sin_rotation;
    }

    public double getCosRotationAngle() {
        return this.cos_rotation;
    }

    public void setElevationAngle(double d) {
        this.elevation = d;
        this.sin_elevation = Math.sin(d * (Math.PI / 180));
        this.cos_elevation = Math.cos(d * (Math.PI / 180));
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public double getElevationAngle() {
        return this.elevation;
    }

    public double getSinElevationAngle() {
        return this.sin_elevation;
    }

    public double getCosElevationAngle() {
        return this.cos_elevation;
    }

    public void setDistance(double d) {
        this.distance = d;
        this.factor = this.distance * this._2D_scale;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setXScaling(double d) {
        this.scale_x = d;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
    }

    public double getXScaling() {
        return this.scale_x;
    }

    public void setYScaling(double d) {
        this.scale_y = d;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
    }

    public double getYScaling() {
        return this.scale_y;
    }

    public void setZScaling(double d) {
        this.scale_z = d;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public double getZScaling() {
        return this.scale_z;
    }

    public void setScaling(double d, double d2, double d3) {
        this.scale_x = d;
        this.scale_y = d2;
        this.scale_z = d3;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public void setScaling(double d) {
        this.scale_y = this.scale_z = d;
        this.scale_x = this.scale_z;
        this.sx_cos = -this.scale_x * this.cos_rotation;
        this.sx_sin = -this.scale_x * this.sin_rotation;
        this.sy_cos = -this.scale_y * this.cos_rotation;
        this.sy_sin = this.scale_y * this.sin_rotation;
        this.sz_cos = this.scale_z * this.cos_elevation;
        this.sz_sin = this.scale_z * this.sin_elevation;
    }

    public void set2DScaling(double d) {
        this._2D_scale = d;
        this.factor = this.distance * this._2D_scale;
    }

    public double get2DScaling() {
        return this._2D_scale;
    }

    public void set2DTranslation(int n, int n2) {
        this._2D_trans_x = n;
        this._2D_trans_y = n2;
        this.trans_x = this.center_x + this._2D_trans_x;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public void set2D_xTranslation(int n) {
        this._2D_trans_x = n;
        this.trans_x = this.center_x + this._2D_trans_x;
    }

    public int get2D_xTranslation() {
        return this._2D_trans_x;
    }

    public void set2D_yTranslation(int n) {
        this._2D_trans_y = n;
        this.trans_y = this.center_y + this._2D_trans_y;
    }

    public int get2D_yTranslation() {
        return this._2D_trans_y;
    }

    public final Point project(double d, double d2, double d3) {
        double d4 = d;
        d = d * this.sx_cos + d2 * this.sy_sin;
        d2 = d4 * this.sx_sin + d2 * this.sy_cos;
        d4 = this.factor / (d2 * this.cos_elevation - d3 * this.sz_sin + this.distance);
        return new Point((int)(Math.round(d * d4) + (long)this.trans_x), (int)(Math.round((d2 * this.sin_elevation + d3 * this.sz_cos) * -d4) + (long)this.trans_y));
    }
}

