/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.False3D;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPlot;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.SurfacePlotProjector;
import org.opensourcephysics.display2d.SurfaceVertex;
import org.opensourcephysics.display2d.ZExpansion;

public class SurfacePlot
implements Plot2D,
False3D {
    protected boolean visible = true;
    protected DecimalFormat labelFormat = new DecimalFormat("0.00");
    private static final int TOP = 0;
    private static final int CENTER = 1;
    public static final int INIT_CALC_DIV = 33;
    public static final int INIT_DISP_DIV = 33;
    protected GridData griddata;
    private int calc_divisions = 33;
    private int disp_divisions = 33;
    private int plot_mode = 0;
    private boolean isBoxed;
    private boolean isMesh;
    private boolean isScaleBox;
    private boolean isDisplayXY;
    private boolean isDisplayZ;
    private boolean isDisplayGrids;
    private double zmin = -2.0;
    private double zmax = 2.0;
    private boolean autoscaleZ = true;
    private boolean symmetricZ = false;
    private double color_factor;
    private Point projection;
    private SurfaceVertex cop;
    private SurfaceVertex[] vertexArray;
    private final SurfaceVertex[] values1 = new SurfaceVertex[4];
    private Color line_color = Color.black;
    private int factor_x;
    private int factor_y;
    private int t_x;
    private int t_y;
    private int t_z;
    private int click_x;
    private int click_y;
    private boolean invalidProjection = true;
    private int iwidth = 0;
    private int iheight = 0;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private int ampIndex = 0;
    SurfacePlotProjector projector;
    double zminV;
    double zmaxV;
    double zfactorV;
    int master_project_indexV = 0;
    private JFrame legendFrame;
    String xLabel = "x";
    String yLabel = "y";
    String zLabel = "z";
    ZExpansion zMap;
    private final int[] poly_x = new int[9];
    private final int[] poly_y = new int[9];
    Color[] colors;

    public SurfacePlot() {
        this(null);
    }

    public SurfacePlot(GridData gridData) {
        this.griddata = gridData;
        this.defaultVariables();
        this.autoscaleZ = true;
        this.projector = new SurfacePlotProjector();
        this.projector.setDistance(200.0);
        this.projector.set2DScaling(8.0);
        this.projector.setRotationAngle(125.0);
        this.projector.setElevationAngle(10.0);
        this.update();
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public void setAll(Object object) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyData(double[][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray.length || this.griddata.getNy() != dArray[0].length) {
            this.griddata = new ArrayData(dArray.length, dArray[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        int n = dArray2[0].length;
        int n2 = 0;
        int n3 = dArray2.length;
        while (n2 < n3) {
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            ++n2;
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
    }

    private void generateVerticesFromArray(ArrayData arrayData) throws IllegalArgumentException {
        int n;
        double[][] dArray = arrayData.getData()[0];
        int n2 = dArray.length;
        if (n2 != (n = dArray[0].length)) {
            throw new IllegalArgumentException("Surface Plots require square datasets.");
        }
        this.calc_divisions = n2 - 1;
        double d = 20.0 / (this.xmax - this.xmin);
        double d2 = 20.0 / (this.ymax - this.ymin);
        if (this.vertexArray == null || this.vertexArray.length != n2 * n) {
            this.vertexArray = new SurfaceVertex[n2 * n];
        }
        double d3 = Math.abs(arrayData.getDx());
        double d4 = Math.abs(arrayData.getDy());
        double d5 = this.xmin;
        int n3 = 0;
        while (n3 < n) {
            double d6 = this.ymin;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = arrayData.getDy() > 0.0 ? n4 : n - n4 - 1;
                int n6 = arrayData.getDx() > 0.0 ? n3 : n - n3 - 1;
                double d7 = dArray[n6][n5];
                if (this.zMap != null) {
                    d7 = this.zMap.evaluate(d7);
                }
                this.vertexArray[n3 * n2 + n4] = new SurfaceVertex(-10.0 + (d5 - this.xmin) * d, -10.0 + (d6 - this.ymin) * d2, d7, this);
                d6 += d4;
                ++n4;
            }
            d5 += d3;
            ++n3;
        }
        dArray = null;
    }

    private void generateVerticesFromPoints(GridPointData gridPointData) throws IllegalArgumentException {
        int n;
        double[][][] dArray = gridPointData.getData();
        int n2 = dArray.length;
        if (n2 != (n = dArray[0].length)) {
            throw new IllegalArgumentException("Surface Plots require square datasets.");
        }
        this.calc_divisions = n2 - 1;
        double d = 20.0 / (this.xmax - this.xmin);
        double d2 = 20.0 / (this.ymax - this.ymin);
        if (this.vertexArray == null || this.vertexArray.length != n2 * n) {
            this.vertexArray = new SurfaceVertex[n2 * n];
        }
        double d3 = Math.abs(gridPointData.getDx());
        double d4 = Math.abs(gridPointData.getDy());
        double d5 = this.xmin;
        int n3 = 0;
        while (n3 < n) {
            double d6 = this.ymin;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = gridPointData.getDy() > 0.0 ? n4 : n - n4 - 1;
                int n6 = gridPointData.getDx() > 0.0 ? n3 : n - n3 - 1;
                double d7 = dArray[n6][n5][2];
                if (this.zMap != null) {
                    d7 = this.zMap.evaluate(d7);
                }
                this.vertexArray[n3 * n2 + n4] = new SurfaceVertex(-10.0 + (d5 - this.xmin) * d, -10.0 + (d6 - this.ymin) * d2, d7, this);
                d6 += d4;
                ++n4;
            }
            d5 += d3;
            ++n3;
        }
        dArray = null;
    }

    void projectVertexArray() {
        SurfaceVertex[] surfaceVertexArray = this.vertexArray;
        if (surfaceVertexArray == null) {
            return;
        }
        int n = 0;
        int n2 = surfaceVertexArray.length;
        while (n < n2) {
            surfaceVertexArray[n].project();
            ++n;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.griddata == null) {
            return;
        }
        this.projector.setProjectionArea(new Rectangle(0, 0, drawingPanel.getBounds().width, drawingPanel.getBounds().height));
        if (this.invalidProjection || this.iwidth != drawingPanel.getWidth() || this.iheight != drawingPanel.getHeight()) {
            ++this.master_project_indexV;
            this.invalidProjection = false;
            this.projectVertexArray();
            this.iwidth = drawingPanel.getWidth();
            this.iheight = drawingPanel.getHeight();
        }
        this.plotSurface(graphics);
    }

    private void defaultVariables() {
        this.plot_mode = 0;
        this.isBoxed = true;
        this.isMesh = true;
        this.isScaleBox = false;
        this.isDisplayXY = true;
        this.isDisplayZ = true;
        this.isDisplayGrids = false;
    }

    private final boolean plottable(SurfaceVertex[] surfaceVertexArray) {
        try {
            return !surfaceVertexArray[0].isInvalid() && !surfaceVertexArray[1].isInvalid() && !surfaceVertexArray[2].isInvalid() && !surfaceVertexArray[3].isInvalid();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final void setAxesScale() {
        double d;
        int n;
        if (!this.isScaleBox) {
            this.projector.setScaling(1.0);
            this.t_z = 4;
            this.t_y = 4;
            this.t_x = 4;
            return;
        }
        double d2 = this.xmax - this.xmin;
        double d3 = this.ymax - this.ymin;
        double d4 = this.zmax - this.zmin;
        if (d2 < d3) {
            if (d3 < d4) {
                n = 3;
                d = d4;
            } else {
                n = 2;
                d = d3;
            }
        } else if (d2 < d4) {
            n = 3;
            d = d4;
        } else {
            n = 1;
            d = d2;
        }
        d3 /= d;
        d4 /= d;
        if ((d2 /= d) < (double)0.2f || d3 < (double)0.2f && d4 < (double)0.2f) {
            switch (n) {
                case 1: {
                    if (d3 < d4) {
                        d3 /= d4;
                        d4 = 1.0;
                        break;
                    }
                    d4 /= d3;
                    d3 = 1.0;
                    break;
                }
                case 2: {
                    if (d2 < d4) {
                        d2 /= d4;
                        d4 = 1.0;
                        break;
                    }
                    d4 /= d2;
                    d2 = 1.0;
                    break;
                }
                case 3: {
                    if (d3 < d2) {
                        d3 /= d2;
                        d2 = 1.0;
                        break;
                    }
                    d2 /= d3;
                    d3 = 1.0;
                }
            }
        }
        if (d2 < (double)0.2f) {
            d2 = 1.0;
        }
        this.projector.setXScaling(d2);
        if (d3 < (double)0.2f) {
            d3 = 1.0;
        }
        this.projector.setYScaling(d3);
        if (d4 < (double)0.2f) {
            d4 = 1.0;
        }
        this.projector.setZScaling(d4);
        this.t_x = d2 < 0.5 ? 8 : 4;
        this.t_y = d3 < 0.5 ? 8 : 4;
        this.t_z = d4 < 0.5 ? 8 : 4;
    }

    private int getDispDivisions() {
        int n = this.disp_divisions;
        if (n > this.calc_divisions) {
            n = this.calc_divisions;
        }
        while (this.calc_divisions % n != 0) {
            ++n;
        }
        return n;
    }

    private final void plotSurface(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        double d = this.zmin;
        double d2 = this.zmax;
        int n7 = this.getDispDivisions();
        int n8 = this.calc_divisions / n7;
        this.disp_divisions = n7;
        this.zmin = d;
        this.zmax = d2;
        this.color_factor = 0.8 / (this.zmax - this.zmin);
        if (this.plot_mode == 2 || this.plot_mode == 3 || this.plot_mode == 4 || this.plot_mode == 5) {
            this.color_factor *= 0.7499999999999999;
        }
        if (this.vertexArray == null) {
            this.drawBoxGridsTicksLabels(graphics, false);
            this.drawBoundingBox(graphics);
            return;
        }
        if (this.plot_mode == 8) {
            this.drawBoxGridsTicksLabels(graphics, true);
            this.drawBoundingBox(graphics);
            return;
        }
        this.drawBoxGridsTicksLabels(graphics, false);
        this.zmaxV = this.zmax;
        this.zminV = this.zmin;
        this.zfactorV = 20.0 / (this.zmaxV - this.zminV);
        double d3 = this.projector.getDistance() * this.projector.getCosElevationAngle();
        this.cop = new SurfaceVertex(d3 * this.projector.getSinRotationAngle(), d3 * this.projector.getCosRotationAngle(), this.projector.getDistance() * this.projector.getSinElevationAngle(), this);
        this.cop.transform();
        boolean bl2 = this.cop.x > 0.0;
        boolean bl3 = bl = this.cop.y > 0.0;
        if (bl2) {
            n6 = 0;
            n5 = this.calc_divisions;
            n4 = n8;
        } else {
            n6 = this.calc_divisions;
            n5 = 0;
            n4 = -n8;
        }
        if (bl) {
            n3 = 0;
            n2 = this.calc_divisions;
            n = n8;
        } else {
            n3 = this.calc_divisions;
            n2 = 0;
            n = -n8;
        }
        if (this.cop.x > 10.0 || this.cop.x < -10.0) {
            if (this.cop.y > 10.0 || this.cop.y < -10.0) {
                this.plotArea(graphics, n6, n3, n5, n2, n4, n);
            } else {
                int n9 = (int)((this.cop.y + 10.0) * (double)n7 / 20.0) * n8;
                this.plotArea(graphics, n6, 0, n5, n9, n4, n8);
                this.plotArea(graphics, n6, this.calc_divisions, n5, n9, n4, -n8);
            }
        } else if (this.cop.y > 10.0 || this.cop.y < -10.0) {
            int n10 = (int)((this.cop.x + 10.0) * (double)n7 / 20.0) * n8;
            this.plotArea(graphics, 0, n3, n10, n2, n8, n);
            this.plotArea(graphics, this.calc_divisions, n3, n10, n2, -n8, n);
        } else {
            int n11 = (int)((this.cop.x + 10.0) * (double)n7 / 20.0) * n8;
            int n12 = (int)((this.cop.y + 10.0) * (double)n7 / 20.0) * n8;
            this.plotArea(graphics, 0, 0, n11, n12, n8, n8);
            this.plotArea(graphics, 0, this.calc_divisions, n11, n12, n8, -n8);
            this.plotArea(graphics, this.calc_divisions, 0, n11, n12, -n8, n8);
            this.plotArea(graphics, this.calc_divisions, this.calc_divisions, n11, n12, -n8, -n8);
        }
        if (this.isBoxed) {
            this.drawBoundingBox(graphics);
        }
    }

    private final void plotPlane(Graphics graphics, SurfaceVertex[] surfaceVertexArray, int n) {
        if (n < 3) {
            return;
        }
        int n2 = 0;
        double d = 0.0;
        this.line_color = Color.black;
        boolean bl = surfaceVertexArray[0].z < this.zmin;
        boolean bl2 = !bl && surfaceVertexArray[0].z <= this.zmax;
        int n3 = 1;
        int n4 = 0;
        while (n4 < n) {
            boolean bl3;
            boolean bl4 = surfaceVertexArray[n3].z < this.zmin;
            boolean bl5 = bl3 = !bl4 && surfaceVertexArray[n3].z <= this.zmax;
            if (bl2 || bl3 || bl ^ bl4) {
                double d2;
                double d3;
                double d4;
                double d5;
                if (!bl2) {
                    d5 = bl ? this.zmin : this.zmax;
                    d4 = (d5 - surfaceVertexArray[n3].z) / (surfaceVertexArray[n4].z - surfaceVertexArray[n3].z);
                    d3 = d4 * (surfaceVertexArray[n4].x - surfaceVertexArray[n3].x) + surfaceVertexArray[n3].x;
                    d2 = d4 * (surfaceVertexArray[n4].y - surfaceVertexArray[n3].y) + surfaceVertexArray[n3].y;
                    this.projection = bl ? this.projector.project(d3, d2, -10.0) : this.projector.project(d3, d2, 10.0);
                    this.poly_x[n2] = this.projection.x;
                    this.poly_y[n2] = this.projection.y;
                    ++n2;
                    d += d5;
                }
                if (bl3) {
                    this.projection = surfaceVertexArray[n3].projection();
                    this.poly_x[n2] = this.projection.x;
                    this.poly_y[n2] = this.projection.y;
                    ++n2;
                    d += surfaceVertexArray[n3].z;
                } else {
                    d5 = bl4 ? this.zmin : this.zmax;
                    d4 = (d5 - surfaceVertexArray[n4].z) / (surfaceVertexArray[n3].z - surfaceVertexArray[n4].z);
                    d3 = d4 * (surfaceVertexArray[n3].x - surfaceVertexArray[n4].x) + surfaceVertexArray[n4].x;
                    d2 = d4 * (surfaceVertexArray[n3].y - surfaceVertexArray[n4].y) + surfaceVertexArray[n4].y;
                    this.projection = bl4 ? this.projector.project(d3, d2, -10.0) : this.projector.project(d3, d2, 10.0);
                    this.poly_x[n2] = this.projection.x;
                    this.poly_y[n2] = this.projection.y;
                    ++n2;
                    d += d5;
                }
            }
            if (++n3 == n) {
                n3 = 0;
            }
            bl2 = bl3;
            bl = bl4;
            ++n4;
        }
        if (n2 > 0) {
            switch (this.plot_mode) {
                case 0: {
                    d = (double)0.8f - (d / (double)n2 - this.zmin) * this.color_factor;
                    graphics.setColor(Color.getHSBColor((float)d, 1.0f, 1.0f));
                    break;
                }
                case 1: {
                    d = (d / (double)n2 - this.zmin) * this.color_factor;
                    graphics.setColor(Color.getHSBColor(0.0f, 0.0f, (float)d));
                    if (!(d < (double)0.3f)) break;
                    this.line_color = new Color(0.6f, 0.6f, 0.6f);
                    break;
                }
                case 2: {
                    d = (d / (double)n2 - this.zmin) * this.color_factor + (double)0.4f;
                    graphics.setColor(Color.getHSBColor((float)(1.0 - d), 0.7f, (float)d));
                    break;
                }
                case 3: {
                    d = (d / (double)n2 - this.zmin) * this.color_factor + (double)0.4f;
                    graphics.setColor(Color.getHSBColor(0.0f, 0.7f, (float)d));
                    break;
                }
                case 4: {
                    d = (d / (double)n2 - this.zmin) * this.color_factor + (double)0.4f;
                    graphics.setColor(Color.getHSBColor(0.3f, 0.7f, (float)d));
                    break;
                }
                case 5: {
                    d = (d / (double)n2 - this.zmin) * this.color_factor + (double)0.4f;
                    graphics.setColor(Color.getHSBColor(0.65f, 0.7f, (float)d));
                    break;
                }
                default: {
                    graphics.setColor(Color.lightGray);
                }
            }
            graphics.fillPolygon(this.poly_x, this.poly_y, n2);
            graphics.setColor(this.line_color);
            if (this.isMesh) {
                this.poly_x[n2] = this.poly_x[0];
                this.poly_y[n2] = this.poly_y[0];
                graphics.drawPolygon(this.poly_x, this.poly_y, ++n2);
            }
        }
    }

    private final void plotArea(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        n5 *= this.calc_divisions + 1;
        n3 *= this.calc_divisions + 1;
        int n7 = n *= this.calc_divisions + 1;
        int n8 = n2;
        while (n8 != n4) {
            this.values1[1] = this.vertexArray[n7 + n8];
            this.values1[2] = this.vertexArray[n7 + n8 + n6];
            while (n7 != n3) {
                this.values1[0] = this.values1[1];
                this.values1[1] = this.vertexArray[n7 + n5 + n8];
                this.values1[3] = this.values1[2];
                this.values1[2] = this.vertexArray[n7 + n5 + n8 + n6];
                if (this.plottable(this.values1)) {
                    this.plotPlane(graphics, this.values1, 4);
                }
                n7 += n5;
            }
            n8 += n6;
            n7 = n;
        }
    }

    private final void drawBoxGridsTicksLabels(Graphics graphics, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        if (this.projector == null) {
            return;
        }
        if (bl) {
            this.drawBase(graphics, nArray, nArray2);
            Point point = this.projector.project(0.0, 0.0, -10.0);
            nArray[0] = point.x;
            nArray2[0] = point.y;
            point = this.projector.project(10.5, 0.0, -10.0);
            graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            if (point.x < nArray[0]) {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], this.xLabel, 2, 0);
            } else {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], this.xLabel, 0, 0);
            }
            point = this.projector.project(0.0, 11.5, -10.0);
            graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            if (point.x < nArray[0]) {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], this.yLabel, 2, 0);
            } else {
                this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], this.yLabel, 0, 0);
            }
            point = this.projector.project(0.0, 0.0, 10.5);
            graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            this.outString(graphics, (int)(1.05 * (double)(point.x - nArray[0])) + nArray[0], (int)(1.05 * (double)(point.y - nArray2[0])) + nArray2[0], this.zLabel, 1, 1);
        } else {
            this.factor_y = 1;
            this.factor_x = 1;
            Point point = this.projector.project(0.0, 0.0, -10.0);
            nArray[0] = point.x;
            point = this.projector.project(10.5, 0.0, -10.0);
            bl3 = point.x > nArray[0];
            int n = point.y;
            point = this.projector.project(-10.5, 0.0, -10.0);
            if (point.y > n) {
                this.factor_x = -1;
                bl3 = point.x > nArray[0];
            }
            point = this.projector.project(0.0, 10.5, -10.0);
            bl2 = point.x > nArray[0];
            n = point.y;
            point = this.projector.project(0.0, -10.5, -10.0);
            if (point.y > n) {
                this.factor_y = -1;
                bl2 = point.x > nArray[0];
            }
            this.setAxesScale();
            this.drawBase(graphics, nArray, nArray2);
            if (this.isBoxed) {
                point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, -10.0);
                nArray[0] = point.x;
                nArray2[0] = point.y;
                point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, 10.0);
                nArray[1] = point.x;
                nArray2[1] = point.y;
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0);
                nArray[2] = point.x;
                nArray2[2] = point.y;
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0);
                nArray[3] = point.x;
                nArray2[3] = point.y;
                nArray[4] = nArray[0];
                nArray2[4] = nArray2[0];
                if (this.plot_mode != 7) {
                    if (this.plot_mode == 8) {
                        graphics.setColor(Color.lightGray);
                    } else {
                        graphics.setColor(new Color(192, 220, 192));
                    }
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
                graphics.setColor(Color.black);
                graphics.drawPolygon(nArray, nArray2, 5);
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0);
                nArray[2] = point.x;
                nArray2[2] = point.y;
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0);
                nArray[3] = point.x;
                nArray2[3] = point.y;
                nArray[4] = nArray[0];
                nArray2[4] = nArray2[0];
                if (this.plot_mode != 7) {
                    if (this.plot_mode == 8) {
                        graphics.setColor(Color.lightGray);
                    } else {
                        graphics.setColor(new Color(192, 220, 192));
                    }
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
                graphics.setColor(Color.black);
                graphics.drawPolygon(nArray, nArray2, 5);
            } else if (this.isDisplayZ) {
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, -10.0);
                nArray[0] = point.x;
                nArray2[0] = point.y;
                point = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0);
                graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, -10.0);
                nArray[0] = point.x;
                nArray2[0] = point.y;
                point = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0);
                graphics.drawLine(nArray[0], nArray2[0], point.x, point.y);
            }
            n = -9;
            while (n <= 9) {
                Point point2;
                if (this.isDisplayXY || this.isDisplayGrids) {
                    if (!this.isDisplayGrids || n % (this.t_y / 2) == 0 || this.isDisplayXY) {
                        point = this.isDisplayGrids && n % this.t_y == 0 ? this.projector.project(-this.factor_x * 10, n, -10.0) : (n % this.t_y != 0 ? this.projector.project((float)this.factor_x * 9.8f, n, -10.0) : this.projector.project((float)this.factor_x * 9.5f, n, -10.0));
                        point2 = this.projector.project(this.factor_x * 10, n, -10.0);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        if (n % this.t_y == 0 && this.isDisplayXY) {
                            point2 = this.projector.project((float)this.factor_x * 10.5f, n, -10.0);
                            if (bl3) {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.ymax - this.ymin) + this.ymin, 0, 0);
                            } else {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.ymax - this.ymin) + this.ymin, 2, 0);
                            }
                        }
                    }
                    if (!this.isDisplayGrids || n % (this.t_x / 2) == 0 || this.isDisplayXY) {
                        point = this.isDisplayGrids && n % this.t_x == 0 ? this.projector.project(n, -this.factor_y * 10, -10.0) : (n % this.t_x != 0 ? this.projector.project(n, (float)this.factor_y * 9.8f, -10.0) : this.projector.project(n, (float)this.factor_y * 9.5f, -10.0));
                        point2 = this.projector.project(n, this.factor_y * 10, -10.0);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        if (n % this.t_x == 0 && this.isDisplayXY) {
                            point2 = this.projector.project(n, (float)this.factor_y * 10.5f, -10.0);
                            if (bl2) {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.xmax - this.xmin) + this.xmin, 0, 0);
                            } else {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.xmax - this.xmin) + this.xmin, 2, 0);
                            }
                        }
                    }
                }
                if (this.isDisplayXY) {
                    point2 = this.projector.project(0.0, this.factor_y * 14, -10.0);
                    this.outString(graphics, point2.x, point2.y, this.xLabel, 1, 0);
                    point2 = this.projector.project(this.factor_x * 14, 0.0, -10.0);
                    this.outString(graphics, point2.x, point2.y, this.yLabel, 1, 0);
                }
                if ((this.isDisplayZ || this.isDisplayGrids && this.isBoxed) && (!this.isDisplayGrids || n % (this.t_z / 2) == 0 || this.isDisplayZ)) {
                    if (this.isBoxed && this.isDisplayGrids && n % this.t_z == 0) {
                        point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, n);
                        point2 = this.projector.project(-this.factor_x * 10, this.factor_y * 10, n);
                    } else {
                        point = n % this.t_z == 0 ? this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.5f, n) : this.projector.project(-this.factor_x * 10, (float)this.factor_y * 9.8f, n);
                        point2 = this.projector.project(-this.factor_x * 10, this.factor_y * 10, n);
                    }
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                    if (this.isDisplayZ) {
                        point2 = this.projector.project(-this.factor_x * 10, (float)this.factor_y * 10.5f, n);
                        if (n % this.t_z == 0) {
                            if (bl2) {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 0, 1);
                            } else {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 2, 1);
                            }
                        }
                    }
                    if (this.isDisplayGrids && this.isBoxed && n % this.t_z == 0) {
                        point = this.projector.project(-this.factor_x * 10, -this.factor_y * 10, n);
                        point2 = this.projector.project(this.factor_x * 10, -this.factor_y * 10, n);
                    } else {
                        point = n % this.t_z == 0 ? this.projector.project((float)this.factor_x * 9.5f, -this.factor_y * 10, n) : this.projector.project((float)this.factor_x * 9.8f, -this.factor_y * 10, n);
                        point2 = this.projector.project(this.factor_x * 10, -this.factor_y * 10, n);
                    }
                    graphics.drawLine(point.x, point.y, point2.x, point2.y);
                    if (this.isDisplayZ) {
                        point2 = this.projector.project((float)this.factor_x * 10.5f, -this.factor_y * 10, n);
                        if (n % this.t_z == 0) {
                            if (bl3) {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 0, 1);
                            } else {
                                this.outFloat(graphics, point2.x, point2.y, (double)(n + 10) / 20.0 * (this.zmax - this.zmin) + this.zmin, 2, 1);
                            }
                        }
                    }
                    if (this.isDisplayGrids && this.isBoxed) {
                        if (n % this.t_y == 0) {
                            point = this.projector.project(-this.factor_x * 10, n, -10.0);
                            point2 = this.projector.project(-this.factor_x * 10, n, 10.0);
                            graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        }
                        if (n % this.t_x == 0) {
                            point = this.projector.project(n, -this.factor_y * 10, -10.0);
                            point2 = this.projector.project(n, -this.factor_y * 10, 10.0);
                            graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private final void drawBase(Graphics graphics, int[] nArray, int[] nArray2) {
        Point point = this.projector.project(-10.0, -10.0, -10.0);
        nArray[0] = point.x;
        nArray2[0] = point.y;
        point = this.projector.project(-10.0, 10.0, -10.0);
        nArray[1] = point.x;
        nArray2[1] = point.y;
        point = this.projector.project(10.0, 10.0, -10.0);
        nArray[2] = point.x;
        nArray2[2] = point.y;
        point = this.projector.project(10.0, -10.0, -10.0);
        nArray[3] = point.x;
        nArray2[3] = point.y;
        nArray[4] = nArray[0];
        nArray2[4] = nArray2[0];
        if (this.plot_mode != 7) {
            if (this.plot_mode == 8) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(new Color(192, 220, 192));
            }
            graphics.fillPolygon(nArray, nArray2, 4);
        }
        graphics.setColor(Color.black);
        graphics.drawPolygon(nArray, nArray2, 5);
    }

    private final void drawBoundingBox(Graphics graphics) {
        Point point = this.projector.project(this.factor_x * 10, this.factor_y * 10, 10.0);
        graphics.setColor(Color.black);
        Point point2 = this.projector.project(-this.factor_x * 10, this.factor_y * 10, 10.0);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        point2 = this.projector.project(this.factor_x * 10, -this.factor_y * 10, 10.0);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        point2 = this.projector.project(this.factor_x * 10, this.factor_y * 10, -10.0);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    private final void outString(Graphics graphics, int n, int n2, String string, int n3, int n4) {
        if (string == null || string.trim().equals("")) {
            return;
        }
        switch (n4) {
            case 0: {
                n2 += graphics.getFontMetrics(graphics.getFont()).getAscent();
                break;
            }
            case 1: {
                n2 += graphics.getFontMetrics(graphics.getFont()).getAscent() / 2;
            }
        }
        switch (n3) {
            case 0: {
                graphics.drawString(string, n, n2);
                break;
            }
            case 2: {
                graphics.drawString(string, n - graphics.getFontMetrics(graphics.getFont()).stringWidth(string), n2);
                break;
            }
            case 1: {
                graphics.drawString(string, n - graphics.getFontMetrics(graphics.getFont()).stringWidth(string) / 2, n2);
            }
        }
    }

    private final void outFloat(Graphics graphics, int n, int n2, double d, int n3, int n4) {
        String string = this.labelFormat.format(d);
        this.outString(graphics, n, n2, string, n3, n4);
    }

    public void setPaletteType(int n) {
        this.plot_mode = n;
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
    }

    public void setLabelFormat(String string) {
        this.labelFormat = new DecimalFormat(string);
    }

    public void setAxisLabels(String string, String string2, String string3) {
        this.xLabel = string;
        this.yLabel = string2;
        this.zLabel = string3;
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.zmax = d2;
            this.zmin = d;
            if (this.zMap != null) {
                this.zMap.setMinMax(this.zmin, this.zmax);
            }
        }
    }

    public void setSymmetricZ(boolean bl) {
        this.symmetricZ = bl;
    }

    public boolean isSymmetricZ() {
        return this.symmetricZ;
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.zmin;
    }

    public double getCeiling() {
        return this.zmax;
    }

    public void setExpandedZ(boolean bl, double d) {
        if (bl && d > 0.0) {
            this.zMap = new ZExpansion(d);
            this.zMap.setMinMax(this.zmin, this.zmax);
        } else {
            this.zMap = null;
        }
    }

    public synchronized void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            if (this.symmetricZ) {
                this.zmax = Math.max(Math.abs(dArray[1]), Math.abs(dArray[0]));
                this.zmin = -this.zmax;
            } else {
                this.zmax = dArray[1];
                this.zmin = dArray[0];
            }
            if (this.zMap != null) {
                this.zMap.setMinMax(this.zmin, this.zmax);
            }
        }
        double d = this.griddata.getLeft();
        double d2 = this.griddata.getRight();
        double d3 = this.griddata.getTop();
        double d4 = this.griddata.getBottom();
        this.xmin = Math.min(d, d2);
        this.xmax = Math.max(d, d2);
        this.ymin = Math.min(d4, d3);
        this.ymax = Math.max(d4, d3);
        if (this.griddata instanceof ArrayData) {
            this.generateVerticesFromArray((ArrayData)this.griddata);
        } else if (this.griddata instanceof GridPointData) {
            this.generateVerticesFromPoints((GridPointData)this.griddata);
        }
        this.updateLegend();
    }

    public void setTranslation(int n, int n2) {
        this.projector.set2DTranslation(n, n2);
    }

    public void setRotationAngle(double d) {
        this.projector.setRotationAngle(d);
    }

    public void setElevationAngle(double d) {
        this.projector.setElevationAngle(d);
    }

    public void setDistance(double d) {
        this.projector.setDistance(d);
    }

    public void set2DScaling(double d) {
        this.projector.set2DScaling(d);
    }

    public boolean mousePressed(MouseEvent mouseEvent, DrawingPanel drawingPanel) {
        this.click_x = mouseEvent.getX();
        this.click_y = mouseEvent.getY();
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent, DrawingPanel drawingPanel) {
    }

    public void mouseDragged(MouseEvent mouseEvent, DrawingPanel drawingPanel) {
        double d = 0.0;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.isControlDown()) {
            this.projector.set2D_xTranslation(this.projector.get2D_xTranslation() + (n - this.click_x));
            this.projector.set2D_yTranslation(this.projector.get2D_yTranslation() + (n2 - this.click_y));
        } else if (mouseEvent.isShiftDown()) {
            d = this.projector.get2DScaling() + (double)(n2 - this.click_y) * 0.5;
            if (d > 60.0) {
                d = 60.0;
            }
            if (d < 2.0) {
                d = 2.0;
            }
            this.projector.set2DScaling(d);
        } else {
            d = this.projector.getRotationAngle() + (double)(n - this.click_x);
            while (d > 360.0) {
                d -= 360.0;
            }
            while (d < 0.0) {
                d += 360.0;
            }
            this.projector.setRotationAngle(d);
            d = this.projector.getElevationAngle() + (double)(n2 - this.click_y);
            if (d > 90.0) {
                d = 90.0;
            } else if (d < 0.0) {
                d = 0.0;
            }
            this.projector.setElevationAngle(d);
        }
        this.click_x = n;
        this.click_y = n2;
        this.invalidProjection = true;
        drawingPanel.render();
    }

    public void setShowGridLines(boolean bl) {
        this.isMesh = bl;
    }

    public void setGridLineColor(Color color) {
        this.line_color = color;
    }

    void updateLegend() {
        if (this.legendFrame != null && this.legendFrame.isVisible() && this.legendFrame.isDisplayable()) {
            this.showLegend();
        }
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(true);
        this.legendFrame.setContentPane(interactivePanel);
        int n = 256;
        GridPointData gridPointData = new GridPointData(n + 2, 1, 1);
        double[][][] dArray = gridPointData.getData();
        double d = (this.zmax - this.zmin) / (double)n;
        double d2 = this.zmin - d / 2.0;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            double d3 = d2;
            if (this.zMap != null) {
                d3 = this.zMap.evaluate(d3);
            }
            dArray[n2][0][2] = d3;
            d2 += d;
            ++n2;
        }
        gridPointData.setScale(this.zmin - d, this.zmax + d, 0.0, 1.0);
        GridPlot gridPlot = new GridPlot(gridPointData);
        gridPlot.setShowGridLines(false);
        gridPlot.setAutoscaleZ(false, this.zmin, this.zmax);
        if (this.colors == null) {
            this.colors = new Color[n];
        }
        this.computeColors();
        gridPlot.setColorPalette(this.colors);
        gridPlot.update();
        interactivePanel.addDrawable(gridPlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    void computeColors() {
        if (this.colors == null) {
            return;
        }
        int n = this.colors.length;
        double d = 0.0;
        double d2 = 1.0 / (double)n;
        int n2 = 0;
        while (n2 < n) {
            this.colors[n2] = this.getZColor(d);
            d += d2;
            ++n2;
        }
    }

    Color getZColor(double d) {
        switch (this.plot_mode) {
            case 0: {
                d = (double)0.8f - d * 0.8;
                return Color.getHSBColor((float)d, 1.0f, 1.0f);
            }
            case 1: {
                return Color.getHSBColor(0.0f, 0.0f, (float)(d *= 0.8));
            }
            case 2: {
                d = d * 0.6 + (double)0.4f;
                return Color.getHSBColor((float)(1.0 - d), 0.7f, (float)d);
            }
            case 3: {
                d = d * 0.6 + (double)0.4f;
                return Color.getHSBColor(0.0f, 0.7f, (float)d);
            }
            case 4: {
                d = d * 0.6 + (double)0.4f;
                return Color.getHSBColor(0.3f, 0.7f, (float)d);
            }
            case 5: {
                d = d * 0.6 + (double)0.4f;
                return Color.getHSBColor(0.65f, 0.7f, (float)d);
            }
        }
        return Color.lightGray;
    }

    public void setColorPalette(Color[] colorArray) {
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setFloorCeilColor(Color color, Color color2) {
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return 0.0;
    }

    public boolean isMeasured() {
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new SurfacePlot(null);
            }
        };
    }
}

