/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.ElementSegment;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementSegment
extends SimpleElement {
    protected int div = -1;
    protected int[] aCoord = null;
    protected int[] bCoord = null;
    protected double[][] points = null;
    private double[] pixel = new double[3];

    public SimpleElementSegment(ElementSegment elementSegment) {
        super(elementSegment);
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 0x136) != 0) {
            this.computeDivisions();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
        graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n + 1], this.bCoord[n + 1]);
    }

    public void drawQuickly(Graphics2D graphics2D) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.style.getLineColor());
        graphics2D.drawLine(this.aCoord[0], this.bCoord[0], this.aCoord[this.div], this.bCoord[this.div]);
    }

    private final void computeDivisions() {
        int n = 1;
        Resolution resolution = this.style.getResolution();
        if (resolution != null) {
            switch (resolution.getType()) {
                case 1: {
                    n = Math.max((int)Math.round(0.49 + this.element.getDiagonalSize() / resolution.getMaxLength()), 1);
                    break;
                }
                case 0: {
                    n = Math.max(resolution.getN1(), 1);
                }
            }
        }
        if (this.div != n) {
            this.div = n;
            this.points = new double[this.div + 1][3];
            this.aCoord = new int[this.div + 1];
            this.bCoord = new int[this.div + 1];
            this.objects = new Object3D[this.div];
            int n2 = 0;
            while (n2 < this.div) {
                this.objects[n2] = new Object3D(this, n2);
                ++n2;
            }
        }
        double d = 0.0;
        double d2 = 1.0;
        switch (this.style.getRelativePosition()) {
            case 5: {
                d = 0.0;
                d2 = 1.0;
                break;
            }
            default: {
                d = -0.5;
                d2 = 0.5;
                break;
            }
            case 8: {
                d = 1.0;
                d2 = 0.0;
            }
        }
        double d3 = d;
        this.points[0][2] = d3;
        this.points[0][1] = d3;
        this.points[0][0] = d3;
        double d4 = d2;
        this.points[this.div][2] = d4;
        this.points[this.div][1] = d4;
        this.points[this.div][0] = d4;
        double d5 = (d2 - d) / (double)this.div;
        int n3 = 1;
        while (n3 < this.div) {
            double d6 = d + (double)n3 * d5;
            this.points[n3][2] = d6;
            this.points[n3][1] = d6;
            this.points[n3][0] = d6;
            ++n3;
        }
        n3 = 0;
        while (n3 <= this.div) {
            this.element.sizeAndToSpaceFrame(this.points[n3]);
            ++n3;
        }
    }

    protected void projectPoints() {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        int n = 0;
        while (n < this.div) {
            System.arraycopy(this.points[n], 0, this.pixel, 0, 3);
            drawingPanel3D.projectPosition(this.pixel);
            this.aCoord[n] = (int)this.pixel[0];
            this.bCoord[n] = (int)this.pixel[1];
            int n2 = 0;
            while (n2 < 3) {
                this.pixel[n2] = (this.points[n][n2] + this.points[n + 1][n2]) / 2.0;
                ++n2;
            }
            drawingPanel3D.projectPosition(this.pixel);
            this.objects[n].setDistance(this.pixel[2] * this.style.getDepthFactor());
            ++n;
        }
        System.arraycopy(this.points[this.div], 0, this.pixel, 0, 3);
        drawingPanel3D.projectPosition(this.pixel);
        this.aCoord[this.div] = (int)this.pixel[0];
        this.bCoord[this.div] = (int)this.pixel[1];
    }
}

