/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawables;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.DataCollector;
import org.colos.ejs.library.control.Resetable;
import org.colos.ejs.library.control.drawables.ControlDrawable2D;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display2d.DataRaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDataRaster
extends ControlDrawable2D
implements Resetable,
DataCollector {
    protected DataRaster raster;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double x;
    private double y;
    private double[] xArray = null;
    private double[] yArray = null;
    private int z;
    private int[] zArray = null;
    private boolean xIsConstant = true;
    private boolean xIsSet = false;
    private boolean yIsConstant = true;
    private boolean yIsSet = false;
    private boolean zIsConstant = true;
    private boolean zIsSet = false;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.raster = new DataRaster(null, -1.0, 1.0, -1.0, 1.0);
        this.minX = this.raster.getXMin();
        this.maxX = this.raster.getXMax();
        this.minY = this.raster.getYMin();
        this.maxY = this.raster.getYMax();
        this.y = 0.0;
        this.x = 0.0;
        this.z = 0;
        this.zIsConstant = true;
        this.yIsConstant = true;
        this.xIsConstant = true;
        this.zIsSet = false;
        this.yIsSet = false;
        this.xIsSet = false;
        return this.raster;
    }

    @Override
    public void initialize() {
        this.raster.clear();
        this.zIsSet = false;
        this.yIsSet = false;
        this.xIsSet = false;
    }

    @Override
    public void reset() {
        this.raster.clear();
        this.zIsSet = false;
        this.yIsSet = false;
        this.xIsSet = false;
    }

    @Override
    public void setParent(ControlParentOfDrawables controlParentOfDrawables) {
        if (controlParentOfDrawables instanceof ControlDrawablesParent) {
            this.raster.primaryDrawingPanel = ((ControlDrawablesParent)controlParentOfDrawables).getDrawingPanel();
            this.raster.primaryDrawingPanel.setPixelScale();
        }
        super.setParent(controlParentOfDrawables);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("index");
            infoList.add("visible");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double[]|double";
        }
        if (string.equals("y")) {
            return "int|double[]|double";
        }
        if (string.equals("index")) {
            return "int|int[]";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("x")) {
            Value value;
            this.xArray = null;
            this.xIsConstant = string2 == null ? true : (value = Value.parseConstantOrArray(string2, true)) != null;
        } else if (string.equals("y")) {
            Value value;
            this.yArray = null;
            this.yIsConstant = string2 == null ? true : (value = Value.parseConstantOrArray(string2, true)) != null;
        } else if (string.equals("index")) {
            Value value;
            this.zArray = null;
            this.zIsConstant = string2 == null ? true : (value = Value.parseConstantOrArray(string2, true)) != null;
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.raster.setXMin(this.minX);
                break;
            }
            case 1: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.raster.setXMax(this.maxX);
                break;
            }
            case 2: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.raster.setYMin(this.minY);
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.raster.setYMax(this.maxY);
                break;
            }
            case 4: {
                if (value.getObject() instanceof double[]) {
                    this.xArray = (double[])value.getObject();
                } else {
                    this.x = value.getDouble();
                }
                if ((this.yIsConstant || this.yIsSet) && (this.zIsConstant || this.zIsSet)) {
                    this.appendData();
                    break;
                }
                this.xIsSet = true;
                break;
            }
            case 5: {
                if (value.getObject() instanceof double[]) {
                    this.yArray = (double[])value.getObject();
                } else {
                    this.y = value.getDouble();
                }
                if ((this.xIsConstant || this.xIsSet) && (this.zIsConstant || this.zIsSet)) {
                    this.appendData();
                    break;
                }
                this.yIsSet = true;
                break;
            }
            case 6: {
                if (value.getObject() instanceof int[]) {
                    this.zArray = (int[])value.getObject();
                } else {
                    this.z = value.getInteger();
                }
                if ((this.xIsConstant || this.xIsSet) && (this.yIsConstant || this.yIsSet)) {
                    this.appendData();
                    break;
                }
                this.zIsSet = true;
                break;
            }
            case 7: {
                this.raster.setVisible(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 8, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.minX = -1.0;
                this.raster.setXMin(-1.0);
                break;
            }
            case 1: {
                this.maxX = 1.0;
                this.raster.setXMax(1.0);
                break;
            }
            case 2: {
                this.minY = -1.0;
                this.raster.setYMin(-1.0);
                break;
            }
            case 3: {
                this.maxY = 1.0;
                this.raster.setYMax(1.0);
                break;
            }
            case 4: {
                this.xIsConstant = true;
                break;
            }
            case 5: {
                this.yIsConstant = true;
                break;
            }
            case 6: {
                this.zIsConstant = true;
                break;
            }
            case 7: {
                this.raster.setVisible(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 8);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "-1";
            }
            case 1: {
                return "1";
            }
            case 2: {
                return "-1";
            }
            case 3: {
                return "1";
            }
            case 4: 
            case 5: 
            case 6: {
                return "<none>";
            }
            case 7: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 8);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        return super.getValue(n - 8);
    }

    private void appendData() {
        if (this.zArray == null) {
            if (this.xArray == null) {
                if (this.yArray == null) {
                    this.raster.append(this.z, this.x, this.y);
                } else {
                    int n = 0;
                    int n2 = this.yArray.length;
                    while (n < n2) {
                        this.raster.append(this.z, this.x, this.yArray[n]);
                        ++n;
                    }
                }
            } else if (this.yArray == null) {
                int n = 0;
                int n3 = this.xArray.length;
                while (n < n3) {
                    this.raster.append(this.z, this.xArray[n], this.y);
                    ++n;
                }
            } else {
                int n = 0;
                int n4 = Math.min(this.xArray.length, this.yArray.length);
                while (n < n4) {
                    this.raster.append(this.z, this.xArray[n], this.yArray[n]);
                    ++n;
                }
            }
        } else if (this.xArray == null) {
            if (this.yArray == null) {
                this.raster.append(this.zArray[0], this.x, this.y);
            } else {
                int n = 0;
                int n5 = Math.min(this.zArray.length, this.yArray.length);
                while (n < n5) {
                    this.raster.append(this.zArray[n], this.x, this.yArray[n]);
                    ++n;
                }
            }
        } else if (this.yArray == null) {
            int n = 0;
            int n6 = Math.min(this.zArray.length, this.xArray.length);
            while (n < n6) {
                this.raster.append(this.zArray[n], this.xArray[n], this.y);
                ++n;
            }
        } else {
            int n = 0;
            int n7 = Math.min(Math.min(this.zArray.length, this.xArray.length), this.yArray.length);
            while (n < n7) {
                this.raster.append(this.zArray[n], this.xArray[n], this.yArray[n]);
                ++n;
            }
        }
        this.zIsSet = false;
        this.yIsSet = false;
        this.xIsSet = false;
    }
}

