/*
 * Decompiled with CFR 0.152.
 */
package RoessMa.Reihenentwicklung.FourierAnalysis_R_pkg;

import RoessMa.Reihenentwicklung.FourierAnalysis_R_pkg.FourierAnalysis_RSimulation;
import RoessMa.Reihenentwicklung.FourierAnalysis_R_pkg.FourierAnalysis_RView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorResourceUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FourierAnalysis_R
extends Model {
    public FourierAnalysis_RSimulation _simulation = null;
    public FourierAnalysis_RView _view = null;
    public FourierAnalysis_R _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    public int n = 1000;
    public double[] x;
    public double[] leftX;
    public double[] rightX;
    public double[] y;
    public double domain = Math.PI * 2;
    public double dx = this.domain / (double)this.n;
    public double c = 4.0;
    public double oben = 20.0;
    public double df = 0.0;
    public double a0 = 0.0;
    public double[] sinCoef;
    public double[] cosCoef;
    public double[] powCoef;
    public double[] freqs;
    public double[] coef;
    public String functionString = "-1+2*step(x-pi)";
    public String analysisTitle = "Power Spectrum";
    public boolean synthesize = false;
    public Object synthesizeColor = Color.BLUE;
    public double arrowDx = 0.0;
    public boolean arrowDrag = false;
    public Object arrowColor = Color.GRAY;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_constraints1 = true;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return FourierAnalysis_R._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/RoessMa/Reihenentwicklung/FourierAnalysis_R.xml";
    }

    public static String _getModelDirectory() {
        return "RoessMa/Reihenentwicklung/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(680, 373);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("RoessMa/Reihenentwicklung/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
        }
        FourierAnalysis_R._addHtmlPageInfo("Fourier Analysis", "_default_", "Fourier Analysis", "./FourierAnalysis_R_Intro 1.html");
        FourierAnalysis_R._addHtmlPageInfo("Bedienung", "_default_", "Bedienung", "./FourierAnalysis_R_Intro 2.html");
        FourierAnalysis_R._addHtmlPageInfo("Experimente", "_default_", "Experimente", "./FourierAnalysis_R_Intro 3.html");
        FourierAnalysis_R._addHtmlPageInfo("Autoren", "_default_", "Autoren", "./FourierAnalysis_R_Intro 4.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!FourierAnalysis_R._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        FourierAnalysis_R fourierAnalysis_R = new FourierAnalysis_R(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!FourierAnalysis_R._common_initialization(stringArray)) {
            return null;
        }
        FourierAnalysis_R fourierAnalysis_R = new FourierAnalysis_R("plottingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)fourierAnalysis_R._getView().getComponent("plottingFrame");
    }

    public FourierAnalysis_R() {
        this(null, null, null, null, null, false);
    }

    public FourierAnalysis_R(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public FourierAnalysis_R(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new FourierAnalysis_RSimulation(this, string, frame, uRL, bl);
        this._view = (FourierAnalysis_RView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return FourierAnalysis_R._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return FourierAnalysis_R._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return FourierAnalysis_R._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_constraints1 = true;
        this.n = 1000;
        this.x = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = 0.0;
        }
        this.leftX = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.leftX[n] = 0.0;
        }
        this.rightX = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.rightX[n] = 0.0;
        }
        this.y = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.y[n] = 0.0;
        }
        this.domain = Math.PI * 2;
        this.dx = this.domain / (double)this.n;
        this.c = 4.0;
        this.oben = 20.0;
        this.df = 0.0;
        this.a0 = 0.0;
        this.sinCoef = new double[this.n / 2];
        for (n = 0; n < this.n / 2; ++n) {
            this.sinCoef[n] = 0.0;
        }
        this.cosCoef = new double[this.n / 2];
        for (n = 0; n < this.n / 2; ++n) {
            this.cosCoef[n] = 0.0;
        }
        this.powCoef = new double[this.n / 2];
        for (n = 0; n < this.n / 2; ++n) {
            this.powCoef[n] = 0.0;
        }
        this.freqs = new double[this.n / 2];
        for (n = 0; n < this.n / 2; ++n) {
            this.freqs[n] = 0.0;
        }
        this.coef = new double[this.n / 2];
        for (n = 0; n < this.n / 2; ++n) {
            this.coef[n] = 0.0;
        }
        this.functionString = "-1+2*step(x-pi)";
        this.analysisTitle = "Power Spectrum";
        this.synthesize = false;
        this.synthesizeColor = Color.BLUE;
        this.arrowDx = 0.0;
        this.arrowDrag = false;
        this.arrowColor = Color.GRAY;
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (this._isEnabled_initialization2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
    }

    @Override
    public void _resetSolvers() {
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.leftX = null;
        this.rightX = null;
        this.y = null;
        this.sinCoef = null;
        this.cosCoef = null;
        this.powCoef = null;
        this.freqs = null;
        this.coef = null;
        System.gc();
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Initialize Variables".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("html-start".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("Synthesize".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.n = Math.max(2, this.n);
        this.dx = this.domain / (double)this.n;
        this.x = new double[this.n];
        this.leftX = new double[this.n];
        this.rightX = new double[this.n];
        this.y = new double[this.n];
        this.sinCoef = new double[this.n / 2];
        this.cosCoef = new double[this.n / 2];
        this.powCoef = new double[this.n / 2];
        this.freqs = new double[this.n / 2];
        this.setFunction();
        this.coef = this.powCoef;
        this.analysisTitle = "Power Spectrum";
        this.arrowDrag = false;
        this.arrowColor = Color.GRAY;
    }

    public void _initialization2() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FourierAnalysis_R.this._view.showDescription(true);
            }
        });
        thread.start();
    }

    public void _constraints1() {
        this._view.synthesizeTrace.clear();
        this.synthesize = true;
        this.setFunction();
        double d = -this.domain;
        double d2 = 3.0 * this.domain / 1000.0;
        for (int i = 0; i < 1000; ++i) {
            double d3 = this.a0;
            int n = this.sinCoef.length;
            for (int j = 0; j < n; ++j) {
                d3 += this.sinCoef[j] * Math.sin((double)(j + 1) * d);
                d3 += this.cosCoef[j] * Math.cos((double)(j + 1) * d);
            }
            this._view.synthesizeTrace.addPoint(d, d3);
            d += d2;
        }
    }

    public void setFunction() {
        int n;
        double d = this.dx / 2.0;
        int n2 = this.x.length;
        for (n = 0; n < n2; ++n) {
            this.x[n] = d;
            this.leftX[n] = d - this.domain;
            this.rightX[n] = d + this.domain;
            this.y[n] = this._view.function.evaluate(d);
            d += this.dx;
        }
        n2 = this.freqs.length;
        for (n = 0; n < n2; ++n) {
            this.freqs[n] = n + 1;
        }
        this.computeCoefficients();
    }

    public void computeCoefficients() {
        int n = this.sinCoef.length;
        for (int i = 0; i < n; ++i) {
            this.sinCoef[i] = this.getSinCoef(i + 1);
            this.cosCoef[i] = this.getCosCoef(i + 1);
            this.powCoef[i] = this.sinCoef[i] * this.sinCoef[i] + this.cosCoef[i] * this.cosCoef[i];
        }
        this.a0 = this.getConstantCoef();
    }

    public double getSinCoef(int n) {
        double d = 0.0;
        double d2 = (double)(n * 2) * Math.PI / this.domain;
        int n2 = this.x.length;
        for (int i = 0; i < n2; ++i) {
            d += this.y[i] * Math.sin(d2 * this.x[i]);
        }
        if (2 * n == this.n) {
            return d * this.dx / this.domain;
        }
        return 2.0 * d * this.dx / this.domain;
    }

    public double getCosCoef(int n) {
        double d = 0.0;
        double d2 = (double)(n * 2) * Math.PI / this.domain;
        int n2 = this.x.length;
        for (int i = 0; i < n2; ++i) {
            d += this.y[i] * Math.cos(d2 * this.x[i]);
        }
        return 2.0 * d * this.dx / this.domain;
    }

    public double getConstantCoef() {
        double d = 0.0;
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            d += this.y[i];
        }
        return d * this.dx / this.domain;
    }

    public void set_sinCoefficients() {
        this.analysisTitle = "Sine Coefficients";
        this.coef = this.sinCoef;
        this.arrowDrag = true;
        this.setArrowColor();
    }

    public void set_cosCoefficients() {
        this.analysisTitle = "Cosine Coefficients";
        this.coef = this.cosCoef;
        this.arrowDrag = true;
        this.setArrowColor();
    }

    public void set_powCoefficients() {
        this.analysisTitle = "Power Spectrum";
        this.coef = this.powCoef;
        this.arrowDrag = false;
        this.setArrowColor();
    }

    public void setArrowColor() {
        if (!this.synthesize) {
            this.setFunction();
        }
        this.arrowColor = this.synthesize && this.arrowDrag ? Color.BLUE : Color.GRAY;
    }

    public void dragCoefficients() {
        this.arrowDx = 0.0;
        int n = this.sinCoef.length;
        for (int i = 0; i < n; ++i) {
            this.powCoef[i] = this.sinCoef[i] * this.sinCoef[i] + this.cosCoef[i] * this.cosCoef[i];
        }
    }

    public double _method_for_plottingPanel_minimumX() {
        return -this.domain / 2.0;
    }

    public double _method_for_plottingPanel_maximumX() {
        return 1.5 * this.domain;
    }

    public void _method_for_particles_dragaction() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            this.x[i] = d;
            d += this.dx;
        }
    }

    public void _method_for_function_action() {
        this._pause();
        this.setFunction();
    }

    public void _method_for__c_action() {
        this.setArrowColor();
    }

    public void _method_for_nField_action() {
        this._initialize();
    }

    public void _method_for_order_n_dragaction() {
        this._initialize();
    }

    public void _method_for_order_n_action() {
        this._initialize();
    }

    public void _method_for_resetButton_action() {
        this._reset();
        this._initialize();
    }

    public int _method_for_zeroCoefficientsSet_elementnumber() {
        return this.n / 2;
    }

    public int _method_for_coefArrowSet_elementnumber() {
        return this.n / 2;
    }

    public void _method_for_coefArrowSet_dragaction() {
        this.dragCoefficients();
    }

    public void _method_for_sinRadioButton_actionon() {
        this.set_sinCoefficients();
    }

    public void _method_for_cosRadioButton_actionon() {
        this.set_cosCoefficients();
    }

    public void _method_for_powerRadioButton_actionon() {
        this.set_powCoefficients();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
        __translatorUtil = new TranslatorResourceUtil("RoessMa.Reihenentwicklung.FourierAnalysis_R_pkg.FourierAnalysis_R");
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }
}

