/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DataFunctionEditor;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.ToolsRes;

public class FunctionPanel
extends JPanel
implements PropertyChangeListener {
    protected FunctionTool functionTool;
    protected ParamEditor paramEditor;
    protected FunctionEditor functionEditor;
    protected Container box;
    protected JTextPane instructions;
    private JButton undoButton;
    private JButton redoButton;
    private UndoableEditSupport undoSupport;
    protected UndoManager undoManager;
    private int varBegin;
    private int varEnd;
    protected JTextField tableEditorField;
    protected String prevName;
    private Icon icon;

    public FunctionPanel(FunctionEditor functionEditor) {
        super(new BorderLayout());
        this.functionEditor = functionEditor;
        functionEditor.functionPanel = this;
        this.createGUI();
        this.refreshGUI();
    }

    public ParamEditor getParamEditor() {
        return this.paramEditor;
    }

    public FunctionEditor getFunctionEditor() {
        return this.functionEditor;
    }

    public FunctionEditor.Table getFunctionTable() {
        return this.functionEditor.getTable();
    }

    public FunctionEditor.Table getParamTable() {
        return this.paramEditor.getTable();
    }

    public String getLabel() {
        return ToolsRes.getString("FunctionPanel.Label");
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.paramEditor.buttonPanel.getPreferredSize().width;
        return dimension;
    }

    protected void addForbiddenNames(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.functionEditor.forbiddenNames.add(stringArray[n]);
            if (this.paramEditor != null) {
                this.paramEditor.forbiddenNames.add(stringArray[n]);
            }
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("edit")) {
            if (propertyChangeEvent.getNewValue() instanceof UndoableEdit) {
                this.undoSupport.postEdit((UndoableEdit)propertyChangeEvent.getNewValue());
            }
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null && this.functionEditor.getObjects().size() > 0) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = null;
                if (propertyChangeEvent.getNewValue() instanceof FunctionEditor.DefaultEdit) {
                    FunctionEditor.DefaultEdit defaultEdit = (FunctionEditor.DefaultEdit)propertyChangeEvent.getNewValue();
                    if (defaultEdit.editType == 2) {
                        string2 = defaultEdit.undoObj.toString();
                    }
                } else if (propertyChangeEvent.getNewValue() instanceof String) {
                    string2 = propertyChangeEvent.getNewValue().toString();
                }
                this.functionTool.firePropertyChange("function", string2, string);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("function")) {
            this.refreshFunctions();
            this.refreshGUI();
            if (this.functionTool != null) {
                this.functionTool.firePropertyChange("function", null, null);
            }
        }
    }

    protected void clearSelection() {
        this.getFunctionTable().clearSelection();
        this.getParamTable().clearSelection();
        this.refreshInstructions(null, false, -1);
    }

    protected void createGUI() {
        JComponent jComponent;
        this.instructions = new JTextPane(){

            public void paintComponent(Graphics graphics) {
                if (OSPRuntime.antiAliasText.booleanValue()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    RenderingHints renderingHints = graphics2D.getRenderingHints();
                    renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paintComponent(graphics);
            }
        };
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setFocusable(false);
        this.instructions.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        StyledDocument styledDocument = this.instructions.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style2 = styledDocument.addStyle("blue", style);
        StyleConstants.setBold(style2, false);
        StyleConstants.setForeground(style2, Color.blue);
        Style style3 = styledDocument.addStyle("red", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, Color.red);
        this.instructions.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (FunctionPanel.this.varEnd == 0) {
                    return;
                }
                FunctionPanel.this.instructions.setCaretPosition(FunctionPanel.this.varBegin);
                FunctionPanel.this.instructions.moveCaretPosition(FunctionPanel.this.varEnd);
                FunctionPanel.this.tableEditorField.replaceSelection(FunctionPanel.this.instructions.getSelectedText());
                FunctionPanel.this.tableEditorField.setBackground(Color.yellow);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (!FunctionPanel.this.hasCircularErrors() && !FunctionPanel.this.hasInvalidExpressions()) {
                    StyledDocument styledDocument = FunctionPanel.this.instructions.getStyledDocument();
                    Style style = styledDocument.getStyle("blue");
                    styledDocument.setCharacterAttributes(0, FunctionPanel.this.instructions.getText().length(), style, false);
                    FunctionPanel.this.varEnd = 0;
                    FunctionPanel.this.varBegin = 0;
                }
            }
        });
        this.instructions.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * Unable to fully structure code
             */
            public void mouseMoved(MouseEvent var1_1) {
                FunctionPanel.access$2(FunctionPanel.this, 0);
                FunctionPanel.access$3(FunctionPanel.this, 0);
                var2_2 = FunctionPanel.this.instructions.getText();
                var3_3 = var2_2.indexOf(": ");
                if (var3_3 == -1) {
                    return;
                }
                var4_4 = var2_2.substring(var3_3 += 2);
                var5_5 = FunctionPanel.this.instructions.getStyledDocument();
                var6_6 = var5_5.getStyle("blue");
                var7_7 = var5_5.getStyle("red");
                var8_8 = FunctionPanel.this.instructions.viewToModel(var1_1.getPoint()) - var3_3;
                if (var8_8 >= 0) ** GOTO lbl17
                var5_5.setCharacterAttributes(0, var2_2.length(), var6_6, false);
                return;
                while (!(var9_9 = var4_4.substring(0, var8_8)).endsWith(" ")) {
                    --var8_8;
lbl17:
                    // 2 sources

                    if (var8_8 > 0) continue;
                }
                FunctionPanel.access$3(FunctionPanel.this, var8_8 + var3_3);
                var9_9 = var4_4.substring(var8_8);
                var10_10 = var9_9.indexOf(",");
                if (var10_10 == -1) {
                    var10_10 = var9_9.indexOf(" ");
                }
                if (var10_10 == -1) {
                    var10_10 = var9_9.length();
                }
                FunctionPanel.access$2(FunctionPanel.this, FunctionPanel.access$1(FunctionPanel.this) + var10_10);
                var5_5.setCharacterAttributes(0, FunctionPanel.access$1(FunctionPanel.this), var6_6, false);
                var5_5.setCharacterAttributes(FunctionPanel.access$1(FunctionPanel.this), var10_10, var7_7, false);
                var5_5.setCharacterAttributes(FunctionPanel.access$0(FunctionPanel.this), var2_2.length() - FunctionPanel.access$0(FunctionPanel.this), var6_6, false);
            }
        });
        this.box = Box.createVerticalBox();
        this.add((Component)this.box, "Center");
        if (this.functionEditor instanceof DataFunctionEditor) {
            jComponent = (DataFunctionEditor)this.functionEditor;
            this.paramEditor = new ParamEditor(jComponent.getData());
        } else {
            this.paramEditor = new ParamEditor();
        }
        this.paramEditor.functionPanel = this;
        this.functionEditor.setParamEditor(this.paramEditor);
        this.paramEditor.setFunctionEditors(new FunctionEditor[]{this.functionEditor});
        this.box.add(this.paramEditor);
        this.box.add(this.functionEditor);
        this.paramEditor.addPropertyChangeListener(this);
        this.paramEditor.addPropertyChangeListener(this.functionEditor);
        this.functionEditor.addPropertyChangeListener(this);
        this.functionEditor.addPropertyChangeListener(this.paramEditor);
        jComponent = new JScrollPane(this.instructions){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                Font font = FunctionPanel.this.instructions.getFont();
                dimension.height = font.getSize() * 3;
                return dimension;
            }
        };
        this.box.add(jComponent);
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(this.undoManager);
        this.undoButton = new JButton();
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionPanel.this.undoManager.undo();
            }
        });
        this.redoButton = new JButton();
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionPanel.this.undoManager.redo();
            }
        });
    }

    protected void refreshGUI() {
        this.undoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Undo"));
        this.undoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Undo.Tooltip"));
        this.redoButton.setText(ToolsRes.getString("DataFunctionPanel.Button.Redo"));
        this.redoButton.setToolTipText(ToolsRes.getString("DataFunctionPanel.Button.Redo.Tooltip"));
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
        if (this.functionTool != null && this.functionTool.getSelectedPanel() == this) {
            boolean bl = true;
            Component[] componentArray = this.functionTool.buttonbar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component == this.undoButton) {
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                this.functionTool.buttonbar.removeAll();
                this.functionTool.buttonbar.add(this.functionTool.helpButton);
                this.functionTool.buttonbar.add(this.undoButton);
                this.functionTool.buttonbar.add(this.redoButton);
                this.functionTool.buttonbar.add(this.functionTool.fontButton);
                this.functionTool.buttonbar.add(this.functionTool.closeButton);
            }
            this.paramEditor.refreshGUI();
            this.functionEditor.refreshGUI();
        }
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        FontSizer.setFonts(this.undoButton, n);
        FontSizer.setFonts(this.redoButton, n);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    protected void refreshFunctions() {
        this.functionEditor.evaluateAll();
    }

    protected void setFunctionTool(FunctionTool functionTool) {
        this.functionTool = functionTool;
    }

    protected void tabToNext(FunctionEditor functionEditor) {
        if (functionEditor == this.functionEditor) {
            this.functionTool.helpButton.requestFocusInWindow();
        } else {
            this.functionEditor.newButton.requestFocusInWindow();
        }
    }

    protected void refreshInstructions(FunctionEditor functionEditor, boolean bl, int n) {
        String string;
        StyledDocument styledDocument = this.instructions.getStyledDocument();
        Style style = styledDocument.getStyle("blue");
        String string2 = string = this.isEmpty() ? ToolsRes.getString("FunctionPanel.Instructions.GetStarted") : ToolsRes.getString("FunctionPanel.Instructions.General");
        if (!bl && this.hasCircularErrors()) {
            string = ToolsRes.getString("FunctionPanel.Instructions.CircularErrors");
            style = styledDocument.getStyle("red");
        } else if (!bl && this.hasInvalidExpressions()) {
            string = ToolsRes.getString("FunctionPanel.Instructions.BadCell");
            style = styledDocument.getStyle("red");
        } else if (functionEditor != null) {
            if (n == 0 && bl) {
                string = ToolsRes.getString("FunctionPanel.Instructions.NameCell");
            } else if (n == 1 && bl) {
                string = functionEditor.getVariablesString(": ");
            } else if (n > -1) {
                string = ToolsRes.getString("FunctionPanel.Instructions.EditCell");
                string = n == 0 ? String.valueOf(string) + " " + ToolsRes.getString("FunctionPanel.Instructions.NameCell") : String.valueOf(string) + " " + ToolsRes.getString("FunctionPanel.Instructions.Help");
            }
        }
        this.instructions.setText(string);
        int n2 = this.instructions.getText().length();
        styledDocument.setCharacterAttributes(0, n2, style, false);
        this.revalidate();
    }

    protected boolean isEmpty() {
        return this.functionEditor.getObjects().size() == 0 && this.paramEditor.getObjects().size() == 0;
    }

    protected boolean hasInvalidExpressions() {
        return this.functionEditor.containsInvalidExpressions() || this.paramEditor.containsInvalidExpressions();
    }

    protected boolean hasCircularErrors() {
        return !this.functionEditor.circularErrors.isEmpty() || !this.paramEditor.circularErrors.isEmpty();
    }
}

