/*
 * Decompiled with CFR 0.152.
 */
package RoessMa.Differentialgleichungen_partiell.SuperpositionDemo_pkg;

import RoessMa.Differentialgleichungen_partiell.SuperpositionDemo_pkg.SuperpositionDemoSimulation;
import RoessMa.Differentialgleichungen_partiell.SuperpositionDemo_pkg.SuperpositionDemoView;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorResourceUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.specialfunctions.Factorials;
import org.opensourcephysics.numerics.specialfunctions.Hermite;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperpositionDemo
extends Model {
    public SuperpositionDemoSimulation _simulation = null;
    public SuperpositionDemoView _view = null;
    public SuperpositionDemo _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    public boolean centered = false;
    public int displayMode = 2;
    public int n = 500;
    public double a = 1.5707963267948966;
    public double[] x;
    public double[] rePsi;
    public double[] imPsi;
    public double t = 0.0;
    public double dt = 0.01;
    public String options = "";
    public String selection = "null";
    public String[] scenarioNames;
    public String[] scenarioData;
    public String qm_system = "null";
    public int first = 1;
    public double m = 1.0;
    public double hbar = 1.0;
    public int states = 1;
    public double[][] outArray;
    public Object[] H;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return SuperpositionDemo._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo.xml";
    }

    public static String _getModelDirectory() {
        return "RoessMa/Differentialgleichungen_partiell/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(676, 450);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition_Ex.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/expansion_table.jpg");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/isw.jpg");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/isw_eigen.jpg");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/isw_eigenfunctions.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/isw_eigenvalues.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/ISW_Superposition.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/ISW_Superposition_Ex.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/schroedinger_au.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/Shifted_SHO.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/sho.jpg");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/sho_eigen.jpg");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/sho_eigenfunctions.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/sho_eigenvalues.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition_Ex.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/spring_constant.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SuperpositionDemo.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/superposition_principle.gif");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/ISW_Superposition.html");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionData.txt");
        hashSet.add("/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SuperpositionDemo.html");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("RoessMa/Differentialgleichungen_partiell/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
        }
        SuperpositionDemo._addHtmlPageInfo("SuperpositionDemo", "_default_", "SuperpositionDemo", "/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SuperpositionDemo.html");
        SuperpositionDemo._addHtmlPageInfo("ISW", "_default_", "ISW", "/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/ISW_Superposition.html");
        SuperpositionDemo._addHtmlPageInfo("SHO", "_default_", "SHO", "/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition.html");
        SuperpositionDemo._addHtmlPageInfo("ISW Exercises", "_default_", "ISW Exercises", "/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition_Ex.html");
        SuperpositionDemo._addHtmlPageInfo("SHO Exercises", "_default_", "SHO Exercises", "/RoessMa/Differentialgleichungen_partiell/SuperpositionDemo/SHO_Superposition_Ex.html");
        SuperpositionDemo._addHtmlPageInfo("Authors", "_default_", "Authors", "./SuperpositionDemo_Intro 6.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!SuperpositionDemo._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        SuperpositionDemo superpositionDemo = new SuperpositionDemo(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!SuperpositionDemo._common_initialization(stringArray)) {
            return null;
        }
        SuperpositionDemo superpositionDemo = new SuperpositionDemo("wavefunctionFrame", jFrame, null, null, stringArray, true);
        return (JComponent)superpositionDemo._getView().getComponent("wavefunctionFrame");
    }

    public SuperpositionDemo() {
        this(null, null, null, null, null, false);
    }

    public SuperpositionDemo(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public SuperpositionDemo(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new SuperpositionDemoSimulation(this, string, frame, uRL, bl);
        this._view = (SuperpositionDemoView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return SuperpositionDemo._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return SuperpositionDemo._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return SuperpositionDemo._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.centered = false;
        this.displayMode = 2;
        this.n = 500;
        this.a = 1.5707963267948966;
        this.x = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.x[n] = 0.0;
        }
        this.rePsi = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.rePsi[n] = 0.0;
        }
        this.imPsi = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.imPsi[n] = 0.0;
        }
        this.t = 0.0;
        this.dt = 0.01;
        this.selection = "null";
        this.scenarioNames = new String[0];
        this.scenarioData = new String[0];
        this.qm_system = "null";
        this.first = 1;
        this.m = 1.0;
        this.hbar = 1.0;
        this.states = 1;
        this.outArray = new double[this.states][3];
        for (n = 0; n < this.states; ++n) {
            for (int i = 0; i < 3; ++i) {
                this.outArray[n][i] = 0.0;
            }
        }
        this.H = new Object[this.states];
        for (n = 0; n < this.states; ++n) {
            this.H[n] = null;
        }
    }

    public void _initializeSolvers() {
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (this._isEnabled_initialization2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
    }

    @Override
    public void _resetSolvers() {
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_evolution1) {
            this._evolution1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.rePsi = null;
        this.imPsi = null;
        this.scenarioNames = null;
        this.scenarioData = null;
        this.outArray = null;
        this.H = null;
        System.gc();
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("html-start".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("Increment Time".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
        }
        if ("position wave function".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        double d = Math.sqrt(Math.PI);
        for (int i = 0; i < this.states; ++i) {
            double d2 = Math.sqrt(Math.pow(2.0, i) * Factorials.factorial(i) * d);
            this.H[i] = Hermite.getPolynomial(i).divide(d2);
        }
        this.readDataFromFile();
    }

    public void _initialization2() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SuperpositionDemo.this._view.showDescription(true);
            }
        });
        thread.start();
    }

    public void _evolution1() {
        this.t += this.dt;
    }

    public void _constraints1() {
        if (this.qm_system.trim().equals("ISW")) {
            this.first = 1;
            this.ISW_Superpostion();
        } else {
            this.first = 0;
            this.SHO_Superpostion();
        }
    }

    public void ISW_Superpostion() {
        double d = -this.a;
        double d2 = 2.0 * this.a / (double)(this.x.length - 1);
        double d3 = Math.PI / this.a;
        double d4 = d3 * d3 / 2.0;
        double d5 = Math.sqrt(0.5 / this.a);
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            this.x[i] = d;
            this.rePsi[i] = 0.0;
            this.imPsi[i] = 0.0;
            int n2 = this.outArray.length;
            for (int j = 1; j <= n2; ++j) {
                if (Math.abs(d) >= this.a / 2.0) continue;
                double d6 = 0.0;
                double d7 = 0.0;
                if (j % 2 == 0) {
                    d6 = d5 * this.outArray[j - 1][1] * Math.sin((double)j * d3 * d);
                    d7 = d5 * this.outArray[j - 1][2] * Math.sin((double)j * d3 * d);
                } else {
                    d6 = d5 * this.outArray[j - 1][1] * Math.cos((double)j * d3 * d);
                    d7 = d5 * this.outArray[j - 1][2] * Math.cos((double)j * d3 * d);
                }
                int n3 = i;
                this.rePsi[n3] = this.rePsi[n3] + (d6 * Math.cos((double)(-j * j) * d4 * this.t) - d7 * Math.sin((double)(-j * j) * d4 * this.t));
                int n4 = i;
                this.imPsi[n4] = this.imPsi[n4] + (d6 * Math.sin((double)(-j * j) * d4 * this.t) + d7 * Math.cos((double)(-j * j) * d4 * this.t));
            }
            d += d2;
        }
    }

    public void SHO_Superpostion() {
        double d = -2.5 * this.a;
        double d2 = 5.0 * this.a / (double)(this.x.length - 1);
        double d3 = Math.pow(Math.PI, 0.25) / Math.sqrt(this.a);
        double d4 = Math.PI / this.a;
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            this.x[i] = d;
            double d5 = d * d4;
            this.rePsi[i] = 0.0;
            this.imPsi[i] = 0.0;
            int n2 = this.outArray.length;
            for (int j = 0; j < n2; ++j) {
                double d6 = ((double)j + 0.5) * Math.PI * Math.PI / this.a / this.a;
                if (this.H[j] == null) break;
                double d7 = d3 * this.outArray[j][1] * Math.exp(-d5 * d5 / 2.0) * ((Function)this.H[j]).evaluate(d5);
                double d8 = d3 * this.outArray[j][2] * Math.exp(-d5 * d5 / 2.0) * ((Function)this.H[j]).evaluate(d5);
                int n3 = i;
                this.rePsi[n3] = this.rePsi[n3] + (d7 * Math.cos(-d6 * this.t) - d8 * Math.sin(-d6 * this.t));
                int n4 = i;
                this.imPsi[n4] = this.imPsi[n4] + (d7 * Math.sin(-d6 * this.t) + d8 * Math.cos(-d6 * this.t));
            }
            d += d2;
        }
    }

    public void compute_Eigenvalues() {
        this.t = 0.0;
        int n = this.outArray.length;
        for (int i = 0; i < n; ++i) {
            this.outArray[i][0] = this.qm_system.equals("ISW") ? this.iswEnergy(i) : this.shoEnergy(i);
        }
    }

    double iswEnergy(int n) {
        double d = (double)(++n) * Math.PI / this.a;
        return d * d / 2.0;
    }

    double shoEnergy(int n) {
        return ((double)n + 0.5) * Math.PI * Math.PI / this.a / this.a;
    }

    private void readDataFromFile() {
        String string = "SuperpositionData.txt";
        String string2 = ResourceLoader.getString(string);
        if (string2 == null) {
            System.out.println("Error reading " + string);
            return;
        }
        this.scenarioData = string2.split("#");
        this.options = "";
        this.scenarioNames = new String[this.scenarioData.length];
        int n = this.scenarioData.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = this.scenarioData[i].split("\n");
            this.scenarioNames[i] = "";
            if (stringArray == null || stringArray.length < 10) continue;
            this.scenarioNames[i] = stringArray[0].trim();
            this.options = this.options + stringArray[0].trim() + ';';
        }
        this.selection = this.scenarioNames[1];
        this.readScenario(this.scenarioData[1]);
    }

    public void selectScenario() {
        this._pause();
        int n = this.scenarioData.length;
        for (int i = 0; i < n; ++i) {
            if (!this.selection.equals(this.scenarioNames[i])) continue;
            this.readScenario(this.scenarioData[i]);
            break;
        }
    }

    private void readScenario(String string) {
        String[] stringArray = string.split("\n");
        if (stringArray == null || stringArray.length < 10) {
            return;
        }
        String string2 = stringArray[1].trim();
        int n = string2.indexOf("=");
        this.qm_system = string2.substring(n + 1).trim();
        string2 = stringArray[2].trim();
        this.centered = string2.substring(n + 1).trim().equals("true");
        string2 = stringArray[3].trim();
        n = string2.indexOf("=");
        this.displayMode = (int)Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[4].trim();
        n = string2.indexOf("=");
        this.n = (int)Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[5].trim();
        this.a = string2.indexOf("=");
        this.a = Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[6].trim();
        n = string2.indexOf("=");
        this.t = Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[7].trim();
        n = string2.indexOf("=");
        this.dt = Double.parseDouble(string2.substring(n + 1).trim());
        string2 = stringArray[8].trim();
        n = string2.indexOf("=");
        this.states = (int)Double.parseDouble(string2.substring(n + 1).trim());
        this.allocateArrays();
        int n2 = stringArray.length;
        for (int i = 10; i < n2; ++i) {
            String[] stringArray2 = stringArray[i].trim().split("\\s");
            this.outArray[i - 10][1] = Double.parseDouble(stringArray2[0]);
            this.outArray[i - 10][2] = Double.parseDouble(stringArray2[1]);
        }
        this.compute_Eigenvalues();
    }

    public void allocateArrays() {
        this.x = new double[this.n];
        this.rePsi = new double[this.n];
        this.imPsi = new double[this.n];
        this.outArray = new double[this.states][3];
        this.H = new Object[this.states];
        double d = Math.sqrt(Math.PI);
        for (int i = 0; i < this.states; ++i) {
            double d2 = Math.sqrt(Math.pow(2.0, i) * Factorials.factorial(i) * d);
            this.H[i] = Hermite.getPolynomial(i).divide(d2);
        }
        this.compute_Eigenvalues();
    }

    public double _method_for_wavefunctionPlottingPanel_minimumY() {
        return this.centered ? -2.0 : 0.0;
    }

    public double _method_for_leftWall_x() {
        return -this.a / 2.0;
    }

    public boolean _method_for_leftWall_visible() {
        return this.first == 1;
    }

    public double _method_for_rightWall_x() {
        return this.a / 2.0;
    }

    public boolean _method_for_rightWall_visible() {
        return this.first == 1;
    }

    public void _method_for_startStopButton_actionOn() {
        this._play();
    }

    public void _method_for_startStopButton_actionOff() {
        this._pause();
    }

    public void _method_for_stepButton_action() {
        this._step();
    }

    public void _method_for_resetTime_action() {
        this.t = 0.0;
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_colorCheckBox_actionon() {
        this.displayMode = 2;
        this.centered = false;
    }

    public void _method_for_colorCheckBox_actionoff() {
        this.displayMode = 1;
        this.centered = true;
    }

    public boolean _method_for_comboBox_editable() {
        return this._isPaused();
    }

    public void _method_for_comboBox_action() {
        this.selectScenario();
    }

    public double _method_for_widthSlider_maximum() {
        return Math.PI;
    }

    public void _method_for_widthSlider_dragaction() {
        this.a = Math.max(this.a, 0.05);
        this.compute_Eigenvalues();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
        __translatorUtil = new TranslatorResourceUtil("RoessMa.Differentialgleichungen_partiell.SuperpositionDemo_pkg.SuperpositionDemo");
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }
}

