/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.GraphicsConfiguration;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.colos.ejs.library.Input;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model {
    protected static TranslatorUtil __translatorUtil;
    private static GraphicsConfiguration __graphicConfiguration;
    protected String[] __theArguments = null;
    protected LauncherApplet __theApplet = null;
    public ToolForData _tools = ToolForData.getTool();
    public Memory _memory = new Memory();
    protected Input _input = new Input();
    protected List<?> _scheduledConditionsList = new ArrayList();
    protected Hashtable<?, ?> _scheduledEventsList = new Hashtable();
    protected boolean __shouldBreak = false;
    public static final Function _ZERO_FUNCTION;
    private _ControlSimulationExperimentClass _cSE = new _ControlSimulationExperimentClass();

    static {
        __graphicConfiguration = null;
        _ZERO_FUNCTION = new Function(){

            public double evaluate(double d) {
                return 0.0;
            }
        };
    }

    public static final TranslatorUtil _getTranslatorUtil() {
        return __translatorUtil;
    }

    public static final GraphicsConfiguration getGraphicsConfiguration() {
        return __graphicConfiguration;
    }

    public String _getStringProperty(String string) {
        return __translatorUtil.translateString(string);
    }

    public abstract View _getView();

    public View getView() {
        return this._getView();
    }

    public abstract Simulation _getSimulation();

    public Simulation getSimulation() {
        return this._getSimulation();
    }

    public abstract int _getPreferredStepsPerDisplay();

    public abstract void _resetModel();

    public abstract void _initializeModel();

    public abstract void _automaticResetSolvers();

    public abstract void _resetSolvers();

    public abstract void _stepModel();

    public abstract void _updateModel();

    public abstract void _freeMemory();

    public int _firstThreadIndex(int n, int n2) {
        return n;
    }

    public int _lastThreadIndex(int n, int n2) {
        return n2;
    }

    public LauncherApplet _getApplet() {
        return this.__theApplet;
    }

    public void _play() {
        this._getSimulation().play();
    }

    public void _playAndWait() {
        this._play();
        this._cSE._controlForSimulation();
    }

    public void _pause() {
        this._getSimulation().pause();
        this._cSE._controlForExperiment();
    }

    public void _breakAfterThisPage() {
        this.__shouldBreak = true;
    }

    public void _step() {
        this._pause();
        this._getSimulation().step();
    }

    public void _setFPS(int n) {
        this._getSimulation().setFPS(n);
    }

    public void _setFPS(Integer n) {
        this._getSimulation().setFPS(n);
    }

    public void _setDelay(int n) {
        this._getSimulation().setDelay(n);
    }

    public int _getDelay() {
        if (this._getSimulation() != null) {
            return this._getSimulation().getDelay();
        }
        return 0;
    }

    public void _resetRealTime() {
        this._getSimulation().resetRealTime();
    }

    protected double _getRealTime() {
        return Double.NaN;
    }

    public void _reset() {
        this._getSimulation().reset();
    }

    public void _initialize() {
        this._getSimulation().initialize();
    }

    public boolean _isApplet() {
        return this.__theApplet != null;
    }

    public boolean _isPlaying() {
        return this._getSimulation().isPlaying();
    }

    public boolean _isPaused() {
        return this._getSimulation().isPaused();
    }

    public void _resetView() {
        if (this._getView() != null) {
            this._getView().reset();
            this._getView().initialize();
        }
    }

    public void _clearView() {
        if (this._getView() != null) {
            this._getView().initialize();
        }
    }

    public void _setStepsPerDisplay(int n) {
        this._setSPD(n);
    }

    public void _setSPD(int n) {
        this._getSimulation().setStepsPerDisplay(n);
    }

    public void _setUpdateView(boolean bl) {
        this._getSimulation().setUpdateView(bl);
    }

    public void _showDescriptionAtStartUp(boolean bl) {
        this._getSimulation().showDescriptionAtStartUp(bl);
    }

    public void _showDescription(boolean bl) {
        this._getSimulation().showDescription(bl);
    }

    public URL _getDescriptionPageURL(String string) {
        return this._getSimulation().getDescriptionPageURL(string);
    }

    public void _setParentComponent(String string) {
        this._getSimulation().setParentComponent(string);
    }

    public abstract HtmlPageInfo _getHtmlPageInfo(String var1, LocaleItem var2);

    public Set<String> _getClassEjsResources() {
        return new HashSet<String>();
    }

    public String _getClassEjsModel() {
        return null;
    }

    public String _getClassModelDirectory() {
        return "";
    }

    public String[] _getArguments() {
        return this.__theArguments;
    }

    public boolean _hasDefaultState() {
        return this._getSimulation().hasDefaultState();
    }

    public boolean _readDefaultState() {
        return this._getSimulation().readDefaultState();
    }

    public boolean _saveDefaultStateToJar() {
        return this._saveDefaultStateToJar(null);
    }

    public boolean _saveDefaultStateToJar(String string) {
        if (this._getSimulation().isUnderEjs()) {
            return false;
        }
        File file = null;
        try {
            URL uRL = Simulation.class.getProtectionDomain().getCodeSource().getLocation();
            file = new File(uRL.toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JFileChooser jFileChooser = OSPRuntime.createChooser("JAR", new String[]{"jar"});
            String string2 = OSPRuntime.chooseFilename(jFileChooser, this._getSimulation().getParentComponent(), false);
            if (string2 == null) {
                return false;
            }
            file = new File(string2);
        }
        return this._getSimulation().saveDefaultStateToJar(file, string);
    }

    public boolean _saveState(String string) {
        return this._getSimulation().saveState(string);
    }

    public boolean _readState(String string) {
        return this._getSimulation().readState(string);
    }

    public boolean _saveVariables(String string, String string2) {
        return this._getSimulation().saveVariables(string, string2);
    }

    public boolean _saveVariables(String string, List<String> list) {
        return this._getSimulation().saveVariables(string, list);
    }

    public boolean _readVariables(String string, String string2) {
        return this._getSimulation().readVariables(string, null, string2);
    }

    public boolean _readVariables(String string, List<String> list) {
        URL uRL = null;
        if (this.__theApplet != null) {
            uRL = this.__theApplet.getCodeBase();
        }
        return this._getSimulation().readVariables(string, uRL, list);
    }

    public boolean _saveText(String string, String string2) {
        return this._getSimulation().saveText(string, string2);
    }

    public boolean _saveText(String string, StringBuffer stringBuffer) {
        return this._getSimulation().saveText(string, stringBuffer);
    }

    public String _readText(String string) {
        return this._getSimulation().readText(string);
    }

    public boolean _saveImage(String string, String string2) {
        return this._getSimulation().saveImage(string, string2);
    }

    public void _alert(String string, String string2, String string3) {
        if (this._getView() != null) {
            JOptionPane.showMessageDialog(this._getView().getComponent(string), string3, string2, 1);
        } else {
            JOptionPane.showMessageDialog(this._getSimulation().getParentComponent(), string3, string2, 1);
        }
    }

    public String _format(double d, String string) {
        return new DecimalFormat(string).format(d);
    }

    public void _print(String string) {
        if (this._getView() != null) {
            this._getView().print(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println(String string) {
        if (this._getView() != null) {
            this._getView().println(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println() {
        if (this._getView() != null) {
            this._getView().println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this._getView() != null) {
            this._getView().clearMessages();
        }
    }

    public String _getParameter(String string) {
        if (this.__theApplet != null) {
            return this.__theApplet.getParameter(string);
        }
        if (this.__theArguments == null) {
            return null;
        }
        int n = 0;
        while (n < this.__theArguments.length) {
            if (this.__theArguments[n].equals("-" + string) && n + 1 < this.__theArguments.length) {
                return this.__theArguments[n + 1];
            }
            ++n;
        }
        return null;
    }

    public boolean _setVariables(String string, String string2, String string3) {
        return this._getSimulation().setVariables(string, string2, string3);
    }

    public boolean _setVariables(String string) {
        return this._getSimulation().setVariables(string);
    }

    public String _getVariable(String string) {
        return this._getSimulation().getVariable(string);
    }

    public void _resetIC() {
        this._resetSolvers();
    }

    private class _ControlSimulationExperimentClass {
        private _ControlSimulationExperimentClass() {
        }

        public synchronized void _controlForSimulation() {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }

        public synchronized void _controlForExperiment() {
            this.notify();
        }
    }
}

