/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.False3D;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.dialogs.DrawingPanelInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.display.dialogs.XMLDrawingPanelInspector;
import org.opensourcephysics.frames.ImageFrame;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.VideoTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingPanel
extends JPanel
implements ActionListener,
Renderable {
    static final boolean RECORD_PAINT_TIMES = false;
    long currentTime = System.currentTimeMillis();
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int TOP_LEFT = 3;
    protected JPopupMenu popupmenu = new JPopupMenu();
    protected JMenuItem propertiesItem;
    protected JMenuItem autoscaleItem;
    protected JMenuItem scaleItem;
    protected JMenuItem zoomInItem;
    protected JMenuItem zoomOutItem;
    protected JMenuItem snapshotItem;
    protected int leftGutter = 0;
    protected int topGutter = 0;
    protected int rightGutter = 0;
    protected int bottomGutter = 0;
    protected int leftGutterPreferred = 0;
    protected int topGutterPreferred = 0;
    protected int rightGutterPreferred = 0;
    protected int bottomGutterPreferred = 0;
    protected boolean clipAtGutter = true;
    protected boolean adjustableGutter = false;
    protected int width;
    protected int height;
    protected Color bgColor = new Color(239, 239, 255);
    protected boolean antialiasTextOn = false;
    protected boolean antialiasShapeOn = false;
    protected boolean squareAspect = false;
    protected boolean autoscaleX = true;
    protected boolean autoscaleY = true;
    protected boolean autoscaleXMin = true;
    protected boolean autoscaleXMax = true;
    protected boolean autoscaleYMin = true;
    protected boolean autoscaleYMax = true;
    protected double autoscaleMargin = 0.0;
    protected double xminPreferred = -10.0;
    protected double xmaxPreferred = 10.0;
    protected double yminPreferred = -10.0;
    protected double ymaxPreferred = 10.0;
    protected double xfloor = Double.NaN;
    protected double xceil = Double.NaN;
    protected double yfloor = Double.NaN;
    protected double yceil = Double.NaN;
    protected double xmin = this.xminPreferred;
    protected double xmax = this.xmaxPreferred;
    protected double ymin = this.yminPreferred;
    protected double ymax = this.xmaxPreferred;
    protected boolean fixedPixelPerUnit = false;
    protected double xPixPerUnit = 1.0;
    protected double yPixPerUnit = 1.0;
    protected AffineTransform pixelTransform = new AffineTransform();
    protected double[] pixelMatrix = new double[6];
    protected ArrayList<Drawable> drawableList = new ArrayList();
    private volatile boolean validImage = false;
    protected BufferedImage offscreenImage;
    protected BufferedImage workingImage = this.offscreenImage = new BufferedImage(1, 1, 1);
    private boolean buffered = false;
    protected TextPanel trMessageBox = new TextPanel();
    protected TextPanel tlMessageBox = new TextPanel();
    protected TextPanel brMessageBox = new TextPanel();
    protected TextPanel blMessageBox = new TextPanel();
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected MouseInputAdapter mouseController = new CMController();
    protected boolean showCoordinates = false;
    protected MouseInputAdapter optionController = new OptionController();
    protected ZoomBox zoomBox = new ZoomBox();
    protected boolean enableZoom = true;
    protected boolean fixedScale = false;
    protected Window customInspector;
    protected Dimensioned dimensionSetter = null;
    protected Rectangle viewRect = null;
    protected CoordinateStringBuilder coordinateStrBuilder = CoordinateStringBuilder.createCartesian();
    protected GlassPanel glassPanel = new GlassPanel();
    protected OSPLayout glassPanelLayout = new OSPLayout();
    int refreshDelay = 100;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    VideoTool vidCap;
    double imageRatio = 1.0;
    protected double xLeftMarginPercentage = 0.0;
    protected double xRightMarginPercentage = 0.0;
    protected double yTopMarginPercentage = 0.0;
    protected double yBottomMarginPercentage = 0.0;
    boolean logScaleX = false;
    boolean logScaleY = false;
    int zoomDelay = 40;
    int zoomCount;
    Timer zoomTimer;
    double dxmin;
    double dxmax;
    double dymin;
    double dymax;

    public DrawingPanel() {
        this.glassPanel.setLayout(this.glassPanelLayout);
        super.setLayout(new BorderLayout());
        this.glassPanel.add((Component)this.trMessageBox, "TopRightCorner");
        this.glassPanel.add((Component)this.tlMessageBox, "TopLeftCorner");
        this.glassPanel.add((Component)this.brMessageBox, "BottomRightCorner");
        this.glassPanel.add((Component)this.blMessageBox, "BottomLeftCorner");
        this.glassPanel.setOpaque(false);
        super.add((Component)this.glassPanel, "Center");
        this.setBackground(this.bgColor);
        this.setPreferredSize(new Dimension(300, 300));
        this.showCoordinates = true;
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.addOptionController();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DrawingPanel.this.invalidateImage();
            }
        });
        this.buildPopupmenu();
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setFontLevel(FontSizer.getLevel());
        this.zoomTimer = new Timer(this.zoomDelay, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawingPanel.this.zoomBox.xstart = 0;
                DrawingPanel.this.zoomBox.xstop = 0;
                DrawingPanel.this.zoomBox.xlast = 0;
                DrawingPanel.this.zoomBox.ystart = 0;
                DrawingPanel.this.zoomBox.ystop = 0;
                DrawingPanel.this.zoomBox.ylast = 0;
                DrawingPanel.this.zoomBox.dragged = false;
                DrawingPanel.this.zoomBox.visible = false;
                int n = 4;
                if (DrawingPanel.this.zoomCount < n) {
                    ++DrawingPanel.this.zoomCount;
                    double d = DrawingPanel.this.getXMin() + DrawingPanel.this.dxmin / (double)n;
                    double d2 = DrawingPanel.this.getXMax() + DrawingPanel.this.dxmax / (double)n;
                    double d3 = DrawingPanel.this.getYMin() + DrawingPanel.this.dymin / (double)n;
                    double d4 = DrawingPanel.this.getYMax() + DrawingPanel.this.dymax / (double)n;
                    DrawingPanel.this.setPreferredMinMax(d, d2, d3, d4);
                    DrawingPanel.this.repaint();
                } else {
                    DrawingPanel.this.zoomTimer.stop();
                    DrawingPanel.this.invalidateImage();
                    DrawingPanel.this.repaint();
                }
            }
        });
        this.zoomTimer.setInitialDelay(0);
        FontSizer.addPropertyChangeListener("level", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                DrawingPanel.this.setFontLevel(n);
            }
        });
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DrawingPanel.this.refreshGUI();
            }
        });
    }

    protected void refreshGUI() {
        this.zoomInItem.setText(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"));
        this.zoomOutItem.setText(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"));
        this.scaleItem.setText(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
        this.autoscaleItem.setText(DisplayRes.getString("DrawingFrame.Autoscale_menu_item"));
        this.snapshotItem.setText(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.propertiesItem.setText(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
    }

    protected void setFontLevel(int n) {
        Font font;
        this.trMessageBox.font = font = FontSizer.getResizedFont(this.trMessageBox.font, n);
        this.tlMessageBox.font = font;
        this.brMessageBox.font = font;
        this.blMessageBox.font = font;
        this.invalidateImage();
    }

    public void setFontFactor(double d) {
        Font font;
        this.trMessageBox.font = font = FontSizer.getResizedFont(this.trMessageBox.font, d);
        this.tlMessageBox.font = font;
        this.brMessageBox.font = font;
        this.blMessageBox.font = font;
        this.invalidateImage();
        this.repaint();
    }

    protected void buildPopupmenu() {
        this.popupmenu.removeAll();
        this.popupmenu.setEnabled(true);
        PopupmenuListener popupmenuListener = new PopupmenuListener();
        if (this.isZoom()) {
            this.zoomInItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"));
            this.zoomInItem.addActionListener(popupmenuListener);
            this.popupmenu.add(this.zoomInItem);
            this.zoomOutItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"));
            this.zoomOutItem.addActionListener(popupmenuListener);
            this.popupmenu.add(this.zoomOutItem);
        }
        if (!this.isFixedScale()) {
            this.autoscaleItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Autoscale_menu_item"));
            this.autoscaleItem.addActionListener(popupmenuListener);
            this.popupmenu.add(this.autoscaleItem);
            this.scaleItem = new JMenuItem(DisplayRes.getString("DrawingFrame.Scale_menu_item"));
            this.scaleItem.addActionListener(popupmenuListener);
            this.popupmenu.add(this.scaleItem);
            this.popupmenu.addSeparator();
        }
        this.snapshotItem = new JMenuItem(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"));
        this.snapshotItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.snapshotItem);
        this.popupmenu.addSeparator();
        this.propertiesItem = new JMenuItem(DisplayRes.getString("DrawingFrame.InspectMenuItem"));
        this.propertiesItem.addActionListener(popupmenuListener);
        this.popupmenu.add(this.propertiesItem);
    }

    public void setAutoscaleMargin(double d) {
        if (this.autoscaleMargin == d) {
            return;
        }
        this.autoscaleMargin = d;
        this.invalidateImage();
    }

    public void setXMarginPercentage(double d) {
        if (this.xLeftMarginPercentage == d && this.xRightMarginPercentage == d) {
            return;
        }
        this.xLeftMarginPercentage = this.xRightMarginPercentage = d;
        this.invalidateImage();
    }

    public void setXMarginPercentage(double d, double d2) {
        if (this.xLeftMarginPercentage == d && this.xRightMarginPercentage == d2) {
            return;
        }
        this.xLeftMarginPercentage = d;
        this.xRightMarginPercentage = d2;
        this.invalidateImage();
    }

    public void setXLeftMarginPercentage(double d) {
        if (this.xLeftMarginPercentage == d) {
            return;
        }
        this.xLeftMarginPercentage = d;
        this.invalidateImage();
    }

    public void setXRightMarginPercentage(double d) {
        if (this.xRightMarginPercentage == d) {
            return;
        }
        this.xRightMarginPercentage = d;
        this.invalidateImage();
    }

    public void setYMarginPercentage(double d) {
        if (this.yTopMarginPercentage == d && this.yBottomMarginPercentage == d) {
            return;
        }
        this.yTopMarginPercentage = this.yBottomMarginPercentage = d;
        this.invalidateImage();
    }

    public void setYMarginPercentage(double d, double d2) {
        if (this.yBottomMarginPercentage == d && this.yTopMarginPercentage == d2) {
            return;
        }
        this.yTopMarginPercentage = d2;
        this.yBottomMarginPercentage = d;
        this.invalidateImage();
    }

    public void setYTopMarginPercentage(double d) {
        if (this.yTopMarginPercentage == d) {
            return;
        }
        this.yTopMarginPercentage = d;
        this.invalidateImage();
    }

    public void setYBottomMarginPercentage(double d) {
        if (this.yBottomMarginPercentage == d) {
            return;
        }
        this.yBottomMarginPercentage = d;
        this.invalidateImage();
    }

    public void setClipAtGutter(boolean bl) {
        if (this.clipAtGutter == bl) {
            return;
        }
        this.clipAtGutter = bl;
        this.invalidateImage();
    }

    public boolean isClipAtGutter() {
        return this.clipAtGutter;
    }

    public void setAdjustableGutter(boolean bl) {
        if (this.adjustableGutter == bl) {
            return;
        }
        this.adjustableGutter = bl;
        this.invalidateImage();
    }

    public boolean isAdjustableGutter() {
        return this.adjustableGutter;
    }

    public void setMouseCursor(Cursor cursor) {
        Container container = this.getTopLevelAncestor();
        this.setCursor(cursor);
        if (container != null) {
            container.setCursor(cursor);
        }
    }

    protected boolean checkWorkingImage() {
        Runnable runnable = new Runnable(){

            public void run() {
                DrawingPanel.this.workingImage();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            return this.workingImage();
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
            return true;
        }
        catch (Exception exception) {
            OSPLog.finest("Exception in Check Working Image:" + exception.toString());
            return false;
        }
    }

    private boolean workingImage() {
        Rectangle rectangle = this.getBounds();
        int n = (int)rectangle.getWidth();
        int n2 = (int)rectangle.getHeight();
        if (n <= 2 || n2 <= 2) {
            return false;
        }
        if (this.workingImage == null || n != this.workingImage.getWidth() || n2 != this.workingImage.getHeight()) {
            this.workingImage = this.getGraphicsConfiguration().createCompatibleImage(n, n2);
            this.invalidateImage();
        }
        if (this.workingImage == null) {
            this.invalidateImage();
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isValidImage()) {
            this.render();
        }
    }

    public boolean isIconified() {
        Container container = this.getTopLevelAncestor();
        if (container instanceof Frame) {
            return (((Frame)container).getExtendedState() & 1) == 1;
        }
        return false;
    }

    @Override
    public BufferedImage render() {
        Object object;
        if (!this.isShowing() || this.isIconified()) {
            return this.offscreenImage;
        }
        if (this.buffered && this.checkWorkingImage()) {
            this.validImage = true;
            this.render(this.workingImage);
            object = this.offscreenImage;
            this.offscreenImage = this.workingImage;
            this.workingImage = object;
        }
        object = new Runnable(){

            public void run() {
                DrawingPanel.this.paintImmediately(DrawingPanel.this.getVisibleRect());
            }
        };
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.paintImmediately(this.getVisibleRect());
            } else {
                SwingUtilities.invokeAndWait((Runnable)object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (this.vidCap != null) {
            if (this.buffered) {
                this.vidCap.addFrame(this.offscreenImage);
            } else if (this.vidCap.isRecording()) {
                this.vidCap.addFrame(this.render());
            }
        }
        return this.offscreenImage;
    }

    @Override
    public BufferedImage render(BufferedImage bufferedImage) {
        Graphics graphics = bufferedImage.getGraphics();
        this.imageRatio = (float)this.getWidth() <= 0.0f ? 1.0f : (float)bufferedImage.getWidth() / (float)this.getWidth();
        if (graphics != null) {
            Rectangle rectangle;
            this.paintEverything(graphics);
            if (bufferedImage == this.workingImage) {
                this.zoomBox.paint(graphics);
            }
            if ((rectangle = this.viewRect) != null) {
                Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
                this.glassPanel.setBounds(rectangle2);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle2);
                this.glassPanel.render(graphics);
                this.glassPanel.setBounds(rectangle);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle);
            } else {
                this.glassPanel.render(graphics);
            }
            graphics.dispose();
        }
        this.imageRatio = 1.0;
        return bufferedImage;
    }

    @Override
    public int getWidth() {
        return (int)(this.imageRatio * (double)super.getWidth());
    }

    @Override
    public int getHeight() {
        return (int)(this.imageRatio * (double)super.getHeight());
    }

    public double getImageRatio() {
        return this.imageRatio;
    }

    public void invalidateImage() {
        this.validImage = false;
    }

    public void validateImage() {
        this.validImage = true;
    }

    protected boolean isValidImage() {
        return this.validImage;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = this.buffered;
        if (graphics2D.getDeviceConfiguration().getDevice().getType() == 1) {
            this.buffered = false;
        }
        super.paint(graphics);
        this.buffered = bl;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (OSPRuntime.disableAllDrawing) {
            graphics.setColor(this.bgColor);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        this.viewRect = this.findViewRect();
        if (this.buffered) {
            if (!this.validImage || this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                if (this.getWidth() != this.offscreenImage.getWidth() || this.getHeight() != this.offscreenImage.getHeight()) {
                    graphics.setColor(Color.WHITE);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    graphics.drawImage(this.offscreenImage, 0, 0, null);
                }
                this.refreshTimer.start();
            } else {
                graphics.drawImage(this.offscreenImage, 0, 0, null);
            }
        } else {
            this.validImage = true;
            this.paintEverything(graphics);
        }
        this.zoomBox.paint(graphics);
    }

    protected Rectangle getViewRect() {
        return this.viewRect;
    }

    protected Rectangle findViewRect() {
        Rectangle rectangle = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof JViewport) {
                rectangle = ((JViewport)container).getViewRect();
                this.glassPanel.setBounds(rectangle);
                this.glassPanelLayout.checkLayoutRect(this.glassPanel, rectangle);
                break;
            }
            container = container.getParent();
        }
        return rectangle;
    }

    protected void computeGutters() {
        Dimension dimension;
        if (this.dimensionSetter != null && (dimension = this.dimensionSetter.getInterior(this)) != null) {
            this.squareAspect = false;
            this.leftGutter = this.rightGutter = Math.max(0, this.getWidth() - dimension.width) / 2;
            this.topGutter = this.bottomGutter = Math.max(0, this.getHeight() - dimension.height) / 2;
        }
    }

    protected void paintFirst(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
    }

    protected void paintLast(Graphics graphics) {
    }

    protected void paintEverything(Graphics graphics) {
        this.computeGutters();
        ArrayList<Drawable> arrayList = this.getDrawables();
        this.scale(arrayList);
        this.setPixelScale();
        if (!OSPRuntime.isMac()) {
            if (this.antialiasTextOn) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            } else {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            }
            if (this.antialiasShapeOn) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        if (!this.validImage) {
            return;
        }
        this.paintFirst(graphics);
        if (!this.validImage) {
            return;
        }
        this.paintDrawableList(graphics, arrayList);
        if (!this.validImage) {
            return;
        }
        this.paintLast(graphics);
    }

    public void setAutoscaleX(boolean bl) {
        if (this.autoscaleX == bl && this.autoscaleXMax == bl && this.autoscaleXMin == bl) {
            return;
        }
        this.autoscaleXMax = this.autoscaleXMin = bl;
        this.autoscaleX = this.autoscaleXMin;
        this.invalidateImage();
    }

    public boolean isAutoscaleX() {
        return this.autoscaleX;
    }

    public boolean isAutoscaleXMax() {
        return this.autoscaleXMax;
    }

    public boolean isAutoscaleXMin() {
        return this.autoscaleXMin;
    }

    public void setAutoscaleY(boolean bl) {
        if (this.autoscaleY == bl && this.autoscaleYMax == bl && this.autoscaleYMin == bl) {
            return;
        }
        this.autoscaleYMax = this.autoscaleYMin = bl;
        this.autoscaleY = this.autoscaleYMin;
        this.invalidateImage();
    }

    public boolean isAutoscaleY() {
        return this.autoscaleY;
    }

    public boolean isAutoscaleYMax() {
        return this.autoscaleYMax;
    }

    public boolean isAutoscaleYMin() {
        return this.autoscaleYMin;
    }

    public boolean isLogScaleX() {
        return this.logScaleX;
    }

    public boolean isLogScaleY() {
        return this.logScaleY;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.getBounds().x == n && this.getBounds().y == n2 && this.getBounds().width == n3 && this.getBounds().height == n4) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.invalidateImage();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        if (this.getBounds().equals(rectangle)) {
            return;
        }
        super.setBounds(rectangle);
        this.invalidateImage();
    }

    public void setBuffered(boolean bl) {
        if (this.buffered == bl) {
            return;
        }
        this.buffered = bl;
        if (this.buffered) {
            this.setDoubleBuffered(false);
        } else {
            this.offscreenImage = this.workingImage = new BufferedImage(1, 1, 1);
            this.setDoubleBuffered(true);
        }
        this.invalidateImage();
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.isVisible() == bl) {
            return;
        }
        super.setVisible(bl);
        this.invalidateImage();
    }

    public void limitAutoscaleX(double d, double d2) {
        if (d2 - d < (double)1.4E-45f) {
            d = 0.9 * d - (double)1.4E-45f;
            d2 = 1.1 * d2 + (double)1.4E-45f;
        }
        this.xfloor = d;
        this.xceil = d2;
    }

    public void limitAutoscaleY(double d, double d2) {
        if (d2 - d < (double)1.4E-45f) {
            d = 0.9 * d - (double)1.4E-45f;
            d2 = 1.1 * d2 + (double)1.4E-45f;
        }
        this.yfloor = d;
        this.yceil = d2;
    }

    public void setPixelsPerUnit(boolean bl, double d, double d2) {
        if (this.fixedPixelPerUnit == bl && this.xPixPerUnit == d && this.yPixPerUnit == d2) {
            return;
        }
        this.fixedPixelPerUnit = bl;
        this.xPixPerUnit = d;
        this.yPixPerUnit = d2;
        this.invalidateImage();
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4, boolean bl) {
        this.autoscaleXMax = false;
        this.autoscaleXMin = false;
        this.autoscaleX = false;
        this.autoscaleYMax = false;
        this.autoscaleYMin = false;
        this.autoscaleY = false;
        if (this.xminPreferred == d && this.xmaxPreferred == d2 && this.yminPreferred == d3 && this.ymaxPreferred == d4) {
            return;
        }
        if (Double.isNaN(d)) {
            this.autoscaleXMin = true;
            d = this.xminPreferred;
        }
        if (Double.isNaN(d2)) {
            this.autoscaleXMax = true;
            d2 = this.xmaxPreferred;
        }
        boolean bl2 = this.autoscaleX = this.autoscaleXMin || this.autoscaleXMax;
        if (d == d2) {
            d = 0.9 * d - 0.5;
            d2 = 1.1 * d2 + 0.5;
        }
        this.xminPreferred = d;
        this.xmaxPreferred = d2;
        if (Double.isNaN(d3)) {
            this.autoscaleYMin = true;
            d3 = this.yminPreferred;
        }
        if (Double.isNaN(d4)) {
            this.autoscaleYMax = true;
            d4 = this.ymaxPreferred;
        }
        boolean bl3 = this.autoscaleY = this.autoscaleYMin || this.autoscaleYMax;
        if (d3 == d4) {
            d3 = 0.9 * d3 - 0.5;
            d4 = 1.1 * d4 + 0.5;
        }
        this.yminPreferred = d3;
        this.ymaxPreferred = d4;
        if (bl) {
            this.invalidateImage();
        }
    }

    public void setPreferredMinMax(double d, double d2, double d3, double d4) {
        this.setPreferredMinMax(d, d2, d3, d4, false);
    }

    public void setPreferredMinMaxX(double d, double d2) {
        this.autoscaleXMax = false;
        this.autoscaleXMin = false;
        this.autoscaleX = false;
        if (this.xminPreferred == d && this.xmaxPreferred == d2) {
            return;
        }
        if (Double.isNaN(d)) {
            this.autoscaleXMin = true;
            d = this.xminPreferred;
        }
        if (Double.isNaN(d2)) {
            this.autoscaleXMax = true;
            d2 = this.xmaxPreferred;
        }
        boolean bl = this.autoscaleX = this.autoscaleXMin || this.autoscaleXMax;
        if (d == d2) {
            d = 0.9 * d - 0.5;
            d2 = 1.1 * d2 + 0.5;
        }
        this.xminPreferred = d;
        this.xmaxPreferred = d2;
        this.invalidateImage();
    }

    public void setPreferredMinMaxY(double d, double d2) {
        this.autoscaleYMax = false;
        this.autoscaleYMin = false;
        this.autoscaleY = false;
        if (this.yminPreferred == d && this.ymaxPreferred == d2) {
            return;
        }
        if (Double.isNaN(d)) {
            this.autoscaleYMin = true;
            d = this.yminPreferred;
        }
        if (Double.isNaN(d2)) {
            this.autoscaleYMax = true;
            d2 = this.ymaxPreferred;
        }
        boolean bl = this.autoscaleY = this.autoscaleYMin || this.autoscaleYMax;
        if (d == d2) {
            d = 0.9 * d - 0.5;
            d2 = 1.1 * d2 + 0.5;
        }
        this.yminPreferred = d;
        this.ymaxPreferred = d2;
        this.invalidateImage();
    }

    public void setSquareAspect(boolean bl) {
        if (this.squareAspect == bl) {
            return;
        }
        this.squareAspect = bl;
        this.invalidateImage();
        this.repaint();
    }

    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    public void setAntialiasTextOn(boolean bl) {
        this.antialiasTextOn = bl;
    }

    public boolean isAntialiasTextOn() {
        return this.antialiasTextOn;
    }

    public void setAntialiasShapeOn(boolean bl) {
        this.antialiasShapeOn = bl;
    }

    public boolean isAntialiasShapeOn() {
        return this.antialiasShapeOn;
    }

    public boolean isPointInside(double d, double d2) {
        if (this.xmin < this.xmax) {
            if (d < this.xmin) {
                return false;
            }
            if (d > this.xmax) {
                return false;
            }
        } else {
            if (d > this.xmin) {
                return false;
            }
            if (d < this.xmax) {
                return false;
            }
        }
        if (this.ymin < this.ymax) {
            if (d2 < this.ymin) {
                return false;
            }
            if (d2 > this.ymax) {
                return false;
            }
        } else {
            if (d2 > this.ymin) {
                return false;
            }
            if (d2 < this.ymax) {
                return false;
            }
        }
        return true;
    }

    public boolean isFixedScale() {
        return this.fixedScale;
    }

    public void setFixedScale(boolean bl) {
        if (this.fixedScale == bl) {
            return;
        }
        this.fixedScale = bl;
        this.buildPopupmenu();
    }

    public boolean isZoom() {
        return this.enableZoom && !this.isFixedScale();
    }

    public void setZoom(boolean bl) {
        if (this.enableZoom == bl) {
            return;
        }
        this.enableZoom = bl;
        this.buildPopupmenu();
    }

    protected void zoomOut() {
        int n = (this.zoomBox.xstart + this.zoomBox.xstop) / 2;
        int n2 = (this.zoomBox.ystart + this.zoomBox.ystop) / 2;
        double d = this.pixToX(n);
        double d2 = this.pixToY(n2);
        double d3 = Math.abs(this.xmax - this.xmin);
        double d4 = Math.abs(this.ymax - this.ymin);
        this.dxmin = d - d3 - this.getXMin();
        this.dxmax = d + d3 - this.getXMax();
        this.dymin = d2 - d4 - this.getYMin();
        this.dymax = d2 + d4 - this.getYMax();
        this.zoomCount = 0;
        this.zoomTimer.start();
    }

    public ZoomBox getZoomBox() {
        return this.zoomBox;
    }

    protected void zoomIn() {
        this.dxmin = this.pixToX(Math.min(this.zoomBox.xstart, this.zoomBox.xstop)) - this.getXMin();
        this.dxmax = this.pixToX(Math.max(this.zoomBox.xstart, this.zoomBox.xstop)) - this.getXMax();
        this.dymin = this.pixToY(Math.max(this.zoomBox.ystart, this.zoomBox.ystop)) - this.getYMin();
        this.dymax = this.pixToY(Math.min(this.zoomBox.ystart, this.zoomBox.ystop)) - this.getYMax();
        this.zoomCount = 0;
        this.zoomTimer.start();
    }

    public void snapshot() {
        int n;
        int n2 = this.isVisible() ? this.getWidth() : this.getPreferredSize().width;
        int n3 = n = this.isVisible() ? this.getHeight() : this.getPreferredSize().height;
        if (n2 == 0 || n == 0) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        this.render(bufferedImage);
        MeasuredImage measuredImage = new MeasuredImage(bufferedImage, this.pixToX(0), this.pixToX(n2), this.pixToY(n), this.pixToY(0));
        ImageFrame imageFrame = new ImageFrame(measuredImage);
        imageFrame.setTitle(DisplayRes.getString("Snapshot.Title"));
        imageFrame.setDefaultCloseOperation(2);
        imageFrame.setKeepHidden(false);
        imageFrame.setVisible(true);
    }

    public boolean hasInspector() {
        return this.popupmenu != null && this.popupmenu.isEnabled();
    }

    public void enableInspector(boolean bl) {
        this.popupmenu.setEnabled(bl);
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupmenu = jPopupMenu;
    }

    public void showInspector() {
        if (this.customInspector == null) {
            XMLDrawingPanelInspector.getInspector(this);
        } else {
            this.customInspector.setVisible(true);
        }
    }

    public void hideInspector() {
        if (this.customInspector == null) {
            DrawingPanelInspector.hideInspector();
        } else {
            this.customInspector.setVisible(false);
        }
    }

    public void setCustomInspector(Window window) {
        if (this.customInspector != null) {
            this.customInspector.setVisible(false);
        }
        this.customInspector = window;
    }

    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
        if (this.vidCap != null) {
            this.setBuffered(true);
        }
    }

    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    public double getAspectRatio() {
        return this.pixelMatrix[3] == 1.0 ? 1.0 : Math.abs(this.pixelMatrix[0] / this.pixelMatrix[3]);
    }

    public double getXPixPerUnit() {
        return this.pixelMatrix[0];
    }

    public double getYPixPerUnit() {
        return -this.pixelMatrix[3];
    }

    public double getMaxPixPerUnit() {
        return Math.max(Math.abs(this.pixelMatrix[0]), Math.abs(this.pixelMatrix[3]));
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getPreferredXMin() {
        return this.xminPreferred;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getPreferredXMax() {
        return this.xmaxPreferred;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getPreferredYMax() {
        return this.ymaxPreferred;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getPreferredYMin() {
        return this.yminPreferred;
    }

    public CoordinateStringBuilder getCoordinateStringBuilder() {
        return this.coordinateStrBuilder;
    }

    public void setCoordinateStringBuilder(CoordinateStringBuilder coordinateStringBuilder) {
        this.coordinateStrBuilder = coordinateStringBuilder;
    }

    public Rectangle2D getScale() {
        this.setPixelScale();
        return new Rectangle2D.Double(this.xmin, this.ymin, this.xmax - this.xmin, this.ymax - this.ymin);
    }

    public Rectangle2D getMeasure() {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        boolean bl = false;
        ArrayList<Drawable> arrayList = this.getDrawables();
        for (Drawable drawable : arrayList) {
            if (!(drawable instanceof Measurable) || !((Measurable)drawable).isMeasured()) continue;
            Measurable measurable = (Measurable)drawable;
            double d5 = measurable.getXMax();
            double d6 = measurable.getXMin();
            if (this.logScaleX && measurable instanceof LogMeasurable) {
                d5 = ((LogMeasurable)measurable).getXMaxLogscale();
                d6 = ((LogMeasurable)measurable).getXMinLogscale();
            }
            double d7 = measurable.getYMax();
            double d8 = measurable.getYMin();
            if (this.logScaleY && measurable instanceof LogMeasurable) {
                d7 = ((LogMeasurable)measurable).getYMaxLogscale();
                d8 = ((LogMeasurable)measurable).getYMinLogscale();
            }
            if (Double.isNaN(d5) || Double.isNaN(d6) || Double.isNaN(d7) || Double.isNaN(d8)) continue;
            d = Math.min(d, d6);
            d2 = Math.max(d2, d5);
            d3 = Math.min(d3, d8);
            d4 = Math.max(d4, d7);
            bl = true;
        }
        if (bl) {
            return new Rectangle2D.Double(d, d3, d2 - d, d4 - d3);
        }
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public AffineTransform getPixelTransform() {
        return (AffineTransform)this.pixelTransform.clone();
    }

    public double[] getPixelMatrix() {
        return this.pixelMatrix;
    }

    public void setPixelScale() {
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        this.leftGutter = this.leftGutterPreferred;
        this.topGutter = this.topGutterPreferred;
        this.rightGutter = this.rightGutterPreferred;
        this.bottomGutter = this.bottomGutterPreferred;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.fixedPixelPerUnit) {
            this.xmin = (this.xmaxPreferred + this.xminPreferred) / 2.0 - (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.xmax = (this.xmaxPreferred + this.xminPreferred) / 2.0 + (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.ymin = (this.ymaxPreferred + this.yminPreferred) / 2.0 - (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.ymax = (this.ymaxPreferred + this.yminPreferred) / 2.0 + (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
            this.pixelTransform.getMatrix(this.pixelMatrix);
            return;
        }
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
        if (this.squareAspect) {
            double d = Math.abs(this.xPixPerUnit / this.yPixPerUnit);
            if (d >= 1.0) {
                d = Math.min(d, (double)this.width);
                this.xmin = this.xminPreferred - (this.xmaxPreferred - this.xminPreferred) * (d - 1.0) / 2.0;
                this.xmax = this.xmaxPreferred + (this.xmaxPreferred - this.xminPreferred) * (d - 1.0) / 2.0;
                this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
            } else {
                d = Math.max(d, 1.0 / (double)this.height);
                this.ymin = this.yminPreferred - (this.ymaxPreferred - this.yminPreferred) * (1.0 / d - 1.0) / 2.0;
                this.ymax = this.ymaxPreferred + (this.ymaxPreferred - this.yminPreferred) * (1.0 / d - 1.0) / 2.0;
                this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
            }
        }
        this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    public void recomputeTransform() {
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
        this.pixelTransform = new AffineTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        this.pixelTransform.getMatrix(this.pixelMatrix);
    }

    public double[] project(double[] dArray, double[] dArray2) {
        switch (dArray.length) {
            case 2: 
            case 3: {
                dArray2[0] = this.xToGraphics(dArray[0]);
                dArray2[1] = this.yToGraphics(dArray[1]);
                break;
            }
            case 4: {
                dArray2[0] = this.xToGraphics(dArray[0]);
                dArray2[1] = this.yToGraphics(dArray[1]);
                dArray2[2] = this.xPixPerUnit * dArray[2];
                dArray2[3] = this.yPixPerUnit * dArray[3];
                break;
            }
            case 6: {
                dArray2[0] = this.xToGraphics(dArray[0]);
                dArray2[1] = this.yToGraphics(dArray[1]);
                dArray2[2] = this.xPixPerUnit * dArray[3];
                dArray2[3] = this.yPixPerUnit * dArray[4];
                break;
            }
            default: {
                throw new IllegalArgumentException("Method project not supported for this length.");
            }
        }
        return dArray2;
    }

    public double pixToX(int n) {
        return this.xmin + (double)(n - this.leftGutter) / this.xPixPerUnit;
    }

    public int xToPix(double d) {
        double d2 = this.pixelMatrix[0] * d + this.pixelMatrix[4];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    public float xToGraphics(double d) {
        float f = (float)(this.pixelMatrix[0] * d + this.pixelMatrix[4]);
        if (f > 2.1474836E9f) {
            return 2.1474836E9f;
        }
        if (f < -2.1474836E9f) {
            return -2.1474836E9f;
        }
        return f;
    }

    public double pixToY(int n) {
        return this.ymax - (double)(n - this.topGutter) / this.yPixPerUnit;
    }

    public int yToPix(double d) {
        double d2 = this.pixelMatrix[3] * d + this.pixelMatrix[5];
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor((float)d2);
    }

    public float yToGraphics(double d) {
        float f = (float)(this.pixelMatrix[3] * d + this.pixelMatrix[5]);
        if (f > 2.1474836E9f) {
            return 2.1474836E9f;
        }
        if (f < -2.1474836E9f) {
            return -2.1474836E9f;
        }
        return f;
    }

    public void scale() {
        ArrayList<Drawable> arrayList = this.getDrawables();
        this.scale(arrayList);
    }

    protected void scale(ArrayList<Drawable> arrayList) {
        if (this.autoscaleX) {
            this.scaleX(arrayList);
        }
        if (this.autoscaleY) {
            this.scaleY(arrayList);
        }
    }

    public void measure() {
        ArrayList<Drawable> arrayList = this.getDrawables();
        this.scaleX(arrayList);
        this.scaleY(arrayList);
        this.setPixelScale();
        this.invalidateImage();
    }

    protected void scaleX() {
        ArrayList<Drawable> arrayList = this.getDrawables();
        this.scaleX(arrayList);
    }

    protected void scaleX(ArrayList<Drawable> arrayList) {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        boolean bl = false;
        for (Drawable drawable : arrayList) {
            Measurable measurable;
            if (!(drawable instanceof Measurable) || !(measurable = (Measurable)drawable).isMeasured()) continue;
            d = measurable.getXMin();
            double d4 = measurable.getXMax();
            if (this.logScaleX && measurable instanceof LogMeasurable) {
                d = ((LogMeasurable)measurable).getXMinLogscale();
                d4 = ((LogMeasurable)measurable).getXMaxLogscale();
            }
            if (Double.isNaN(d) || Double.isNaN(d4)) continue;
            d2 = Math.min(d2, d);
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
            d3 = Math.max(d3, d);
            bl = true;
        }
        if (bl) {
            if (this.logScaleX && (this.xLeftMarginPercentage > 0.0 || this.xRightMarginPercentage > 0.0)) {
                d3 *= 1.0 + this.xRightMarginPercentage / 100.0;
                d2 /= 1.0 + this.xLeftMarginPercentage / 100.0;
            } else if (!this.logScaleX && (this.xLeftMarginPercentage > 0.0 || this.xRightMarginPercentage > 0.0)) {
                double d5 = (d2 + d3) / 2.0;
                d = (d3 - d2) / 2.0;
                d3 = d5 + d * (1.0 + this.xRightMarginPercentage / 100.0);
                d2 = d5 - d * (1.0 + this.xLeftMarginPercentage / 100.0);
            }
            if (d3 - d2 < (double)1.4E-45f) {
                d2 = Double.isNaN(this.xfloor) ? 0.9 * d2 - 0.5 : Math.min(d2, this.xfloor);
                d3 = Double.isNaN(this.xceil) ? 1.1 * d3 + 0.5 : Math.max(d3, this.xceil);
            }
            double d6 = Math.max(d3 - d2, (double)1.4E-45f);
            while (Math.abs((d3 + d6) / d6) > 100000.0) {
                d2 -= (d6 *= 2.0);
                d3 += d6;
            }
            if (this.autoscaleXMin) {
                this.xminPreferred = d2 - this.autoscaleMargin * d6;
            }
            if (this.autoscaleXMax) {
                this.xmaxPreferred = d3 + this.autoscaleMargin * d6;
            }
        } else {
            if (!Double.isNaN(this.xfloor) && this.autoscaleXMin) {
                this.xminPreferred = this.xfloor;
            }
            if (!Double.isNaN(this.xceil) && this.autoscaleXMax) {
                this.xmaxPreferred = this.xceil;
            }
        }
        if (!Double.isNaN(this.xfloor)) {
            this.xminPreferred = Math.min(this.xfloor, this.xminPreferred);
        }
        if (!Double.isNaN(this.xceil)) {
            this.xmaxPreferred = Math.max(this.xceil, this.xmaxPreferred);
        }
        if (Math.abs(this.xmaxPreferred - this.xminPreferred) < (double)1.4E-45f) {
            this.xminPreferred = 0.9 * this.xmaxPreferred - (double)1.4E-45f;
            this.xmaxPreferred = 1.1 * this.xmaxPreferred + (double)1.4E-45f;
        }
    }

    protected void scaleY() {
        ArrayList<Drawable> arrayList = this.getDrawables();
        this.scaleY(arrayList);
    }

    protected void scaleY(ArrayList<Drawable> arrayList) {
        double d;
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        boolean bl = false;
        for (Drawable drawable : arrayList) {
            Measurable measurable;
            if (!(drawable instanceof Measurable) || !(measurable = (Measurable)drawable).isMeasured()) continue;
            d = measurable.getYMin();
            double d4 = measurable.getYMax();
            if (this.logScaleY && measurable instanceof LogMeasurable) {
                d4 = ((LogMeasurable)measurable).getYMaxLogscale();
                d = ((LogMeasurable)measurable).getYMinLogscale();
            }
            if (Double.isNaN(d) || Double.isNaN(d4)) continue;
            d2 = Math.min(d2, d);
            d2 = Math.min(d2, d4);
            d3 = Math.max(d3, d4);
            d3 = Math.max(d3, d);
            bl = true;
        }
        if (bl) {
            if (this.logScaleY && (this.yTopMarginPercentage > 0.0 || this.yBottomMarginPercentage > 0.0)) {
                d3 *= 1.0 + this.yTopMarginPercentage / 100.0;
                d2 /= 1.0 + this.yBottomMarginPercentage / 100.0;
            } else if (!this.logScaleY && (this.yTopMarginPercentage > 0.0 || this.yBottomMarginPercentage > 0.0)) {
                double d5 = (d2 + d3) / 2.0;
                d = (d3 - d2) / 2.0;
                d3 = d5 + d * (1.0 + this.yTopMarginPercentage / 100.0);
                d2 = d5 - d * (1.0 + this.yBottomMarginPercentage / 100.0);
            }
            if (d3 - d2 < (double)1.4E-45f) {
                d2 = Double.isNaN(this.yfloor) ? 0.9 * d2 - 0.5 : Math.min(d2, this.yfloor);
                d3 = Double.isNaN(this.yceil) ? 1.1 * d3 + 0.5 : Math.max(d3, this.yceil);
            }
            double d6 = Math.max(d3 - d2, (double)1.4E-45f);
            while (Math.abs((d3 + d6) / d6) > 100000.0) {
                d2 -= (d6 *= 2.0);
                d3 += d6;
            }
            if (this.autoscaleYMin) {
                this.yminPreferred = d2 - this.autoscaleMargin * d6;
            }
            if (this.autoscaleYMax) {
                this.ymaxPreferred = d3 + this.autoscaleMargin * d6;
            }
        } else {
            if (!Double.isNaN(this.yfloor) && this.autoscaleYMin) {
                this.yminPreferred = this.yfloor;
            }
            if (!Double.isNaN(this.yceil) && this.autoscaleYMax) {
                this.ymaxPreferred = this.yceil;
            }
        }
        if (!Double.isNaN(this.yfloor)) {
            this.yminPreferred = Math.min(this.yfloor, this.yminPreferred);
        }
        if (!Double.isNaN(this.yceil)) {
            this.ymaxPreferred = Math.max(this.yceil, this.ymaxPreferred);
        }
        if (Math.abs(this.ymaxPreferred - this.yminPreferred) < (double)1.4E-45f) {
            this.yminPreferred = 0.9 * this.ymaxPreferred - (double)1.4E-45f;
            this.ymaxPreferred = 1.1 * this.ymaxPreferred + (double)1.4E-45f;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void paintDrawableList(Graphics var1_1, ArrayList<Drawable> var2_2) {
        block4: {
            if (var2_2 == null) {
                return;
            }
            var3_3 = (Graphics2D)var1_1;
            var4_4 = var2_2.iterator();
            var5_5 = var3_3.getClip();
            var6_6 = this.getWidth() - this.leftGutter - this.rightGutter;
            var7_7 = this.getHeight() - this.bottomGutter - this.topGutter;
            if (var6_6 < 0 || var7_7 < 0) {
                return;
            }
            if (this.clipAtGutter) {
                var3_3.clipRect(this.leftGutter, this.topGutter, var6_6, var7_7);
            }
            if (var2_2.isEmpty() || !(var2_2.get(0) instanceof False3D)) ** GOTO lbl18
            var2_2.get(0).draw(this, var3_3);
            break block4;
            while (this.validImage) {
                var8_8 = var4_4.next();
                var8_8.draw(this, var3_3);
lbl18:
                // 2 sources

                if (var4_4.hasNext()) continue;
            }
        }
        var3_3.setClip(var5_5);
    }

    public JPanel getGlassPanel() {
        return this.glassPanel;
    }

    @Override
    public void setIgnoreRepaint(boolean bl) {
        super.setIgnoreRepaint(bl);
        this.glassPanel.setIgnoreRepaint(bl);
    }

    public Dimensioned getDimensionSetter() {
        return this.dimensionSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawable(Drawable drawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            if (drawable != null && !this.drawableList.contains(drawable)) {
                this.drawableList.add(drawable);
                this.invalidateImage();
            }
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = (Dimensioned)((Object)drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawables(Collection<Drawable> collection) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            for (Drawable drawable : collection) {
                if (!(drawable instanceof Drawable)) continue;
                this.addDrawable(drawable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawableAtIndex(int n, Drawable drawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            if (drawable != null && !this.drawableList.contains(drawable)) {
                this.drawableList.add(n, drawable);
                this.invalidateImage();
            }
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = (Dimensioned)((Object)drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDrawable(Drawable drawable, Drawable drawable2) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            if (drawable != null && this.drawableList.contains(drawable)) {
                int n = this.drawableList.indexOf(drawable);
                this.drawableList.set(n, drawable2);
                if (drawable2 instanceof Dimensioned) {
                    this.dimensionSetter = (Dimensioned)((Object)drawable2);
                }
            } else {
                this.addDrawable(drawable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDrawable(Drawable drawable) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            this.drawableList.remove(drawable);
        }
        if (drawable instanceof Dimensioned) {
            this.dimensionSetter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> void removeObjectsOfClass(Class<T> clazz) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            Iterator<Drawable> iterator = this.drawableList.iterator();
            while (iterator.hasNext()) {
                Drawable drawable = iterator.next();
                if (drawable.getClass() != clazz) continue;
                iterator.remove();
                if (!(drawable instanceof Dimensioned)) continue;
                this.dimensionSetter = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> void removeDrawables(Class<T> clazz) {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            Iterator<Drawable> iterator = this.drawableList.iterator();
            while (iterator.hasNext()) {
                Drawable drawable = iterator.next();
                if (!clazz.isInstance(drawable)) continue;
                iterator.remove();
                if (!(drawable instanceof Dimensioned)) continue;
                this.dimensionSetter = null;
            }
        }
    }

    public void removeOptionController() {
        this.removeMouseListener(this.optionController);
        this.removeMouseMotionListener(this.optionController);
    }

    public void addOptionController() {
        this.addMouseListener(this.optionController);
        this.addMouseMotionListener(this.optionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            this.drawableList.clear();
        }
        this.dimensionSetter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = this.drawableList;
        synchronized (arrayList) {
            return new ArrayList<Drawable>(this.drawableList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> ArrayList<T> getDrawables(Class<T> clazz) {
        ArrayList<Drawable> arrayList = null;
        ArrayList<Drawable> arrayList2 = this.drawableList;
        synchronized (arrayList2) {
            arrayList = new ArrayList<Drawable>(this.drawableList);
        }
        arrayList2 = new ArrayList();
        for (Drawable drawable : arrayList) {
            if (!clazz.isInstance(drawable)) continue;
            arrayList2.add((Drawable)clazz.cast(drawable));
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Drawable> ArrayList<T> getObjectOfClass(Class<T> clazz) {
        ArrayList<Drawable> arrayList = null;
        ArrayList<Drawable> arrayList2 = this.drawableList;
        synchronized (arrayList2) {
            arrayList = new ArrayList<Drawable>(this.drawableList);
        }
        arrayList2 = new ArrayList();
        for (Drawable drawable : arrayList) {
            if (drawable.getClass() != clazz) continue;
            arrayList2.add((Drawable)clazz.cast(drawable));
        }
        return arrayList2;
    }

    public int[] getGutters() {
        return new int[]{this.leftGutter, this.topGutter, this.rightGutter, this.bottomGutter};
    }

    public void setGutters(int[] nArray) {
        this.leftGutter = nArray[0];
        this.topGutter = nArray[1];
        this.rightGutter = nArray[2];
        this.bottomGutter = nArray[3];
    }

    public void setGutters(int n, int n2, int n3, int n4) {
        this.leftGutter = n;
        this.topGutter = n2;
        this.rightGutter = n3;
        this.bottomGutter = n4;
    }

    public void setPreferredGutters(int n, int n2, int n3, int n4) {
        this.leftGutterPreferred = this.leftGutter = n;
        this.topGutterPreferred = this.topGutter = n2;
        this.rightGutterPreferred = this.rightGutter = n3;
        this.bottomGutterPreferred = this.bottomGutter = n4;
    }

    public void resetGutters() {
        this.leftGutter = this.leftGutterPreferred;
        this.topGutter = this.topGutterPreferred;
        this.rightGutter = this.rightGutterPreferred;
        this.bottomGutter = this.bottomGutterPreferred;
    }

    public int getBottomGutter() {
        return this.bottomGutter;
    }

    public int getTopGutter() {
        return this.topGutter;
    }

    public int getLeftGutter() {
        return this.leftGutter;
    }

    public int getRightGutter() {
        return this.rightGutter;
    }

    public void setMessage(String string) {
        this.brMessageBox.setText(string);
    }

    public void setMessage(String string, int n) {
        switch (n) {
            case 0: {
                this.blMessageBox.setText(string);
                break;
            }
            case 1: {
                this.brMessageBox.setText(string);
                break;
            }
            case 2: {
                this.trMessageBox.setText(string);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(string);
            }
        }
    }

    public void setShowCoordinates(boolean bl) {
        if (this.showCoordinates && !bl) {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
        } else if (!this.showCoordinates && bl) {
            this.addMouseListener(this.mouseController);
            this.addMouseMotionListener(this.mouseController);
        }
        this.showCoordinates = bl;
    }

    public boolean isZoomEvent(MouseEvent mouseEvent) {
        return OSPRuntime.isPopupTrigger(mouseEvent);
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanelLoader();
    }

    private class CMController
    extends MouseInputAdapter {
        private CMController() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            String string = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, mouseEvent);
            DrawingPanel.this.blMessageBox.setText(string);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DrawingPanel.this.blMessageBox.setText(null);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (DrawingPanel.this.showCoordinates) {
                DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DrawingPanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            String string = DrawingPanel.this.coordinateStrBuilder.getCoordinateString(DrawingPanel.this, mouseEvent);
            DrawingPanel.this.blMessageBox.setText(string);
        }
    }

    static class DrawingPanelLoader
    implements XML.ObjectLoader {
        DrawingPanelLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DrawingPanel drawingPanel = (DrawingPanel)object;
            xMLControl.setValue("preferred x min", drawingPanel.getPreferredXMin());
            xMLControl.setValue("preferred x max", drawingPanel.getPreferredXMax());
            xMLControl.setValue("preferred y min", drawingPanel.getPreferredYMin());
            xMLControl.setValue("preferred y max", drawingPanel.getPreferredYMax());
            xMLControl.setValue("autoscale x", drawingPanel.isAutoscaleX());
            xMLControl.setValue("autoscale y", drawingPanel.isAutoscaleY());
            xMLControl.setValue("square aspect", drawingPanel.isSquareAspect());
            xMLControl.setValue("drawables", drawingPanel.getDrawables());
        }

        public Object createObject(XMLControl xMLControl) {
            DrawingPanel drawingPanel = new DrawingPanel();
            double d = xMLControl.getDouble("preferred x min");
            double d2 = xMLControl.getDouble("preferred x max");
            double d3 = xMLControl.getDouble("preferred y min");
            double d4 = xMLControl.getDouble("preferred y max");
            drawingPanel.setPreferredMinMax(d, d2, d3, d4);
            if (xMLControl.getBoolean("autoscale x")) {
                drawingPanel.setAutoscaleX(true);
            }
            if (xMLControl.getBoolean("autoscale y")) {
                drawingPanel.setAutoscaleY(true);
            }
            return drawingPanel;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Collection collection;
            DrawingPanel drawingPanel = (DrawingPanel)object;
            double d = xMLControl.getDouble("preferred x min");
            double d2 = xMLControl.getDouble("preferred x max");
            double d3 = xMLControl.getDouble("preferred y min");
            double d4 = xMLControl.getDouble("preferred y max");
            drawingPanel.setPreferredMinMax(d, d2, d3, d4);
            drawingPanel.squareAspect = xMLControl.getBoolean("square aspect");
            if (xMLControl.getBoolean("autoscale x")) {
                drawingPanel.setAutoscaleX(true);
            }
            if (xMLControl.getBoolean("autoscale y")) {
                drawingPanel.setAutoscaleY(true);
            }
            if ((collection = (Collection)Collection.class.cast(xMLControl.getObject("drawables"))) != null) {
                drawingPanel.clear();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    drawingPanel.addDrawable((Drawable)iterator.next());
                }
            }
            return object;
        }
    }

    class GlassPanel
    extends JPanel {
        GlassPanel() {
        }

        public void render(Graphics graphics) {
            Component[] componentArray = DrawingPanel.this.glassPanelLayout.getComponents();
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                if (componentArray[n] != null) {
                    graphics.translate(componentArray[n].getX(), componentArray[n].getY());
                    componentArray[n].print(graphics);
                    graphics.translate(-componentArray[n].getX(), -componentArray[n].getY());
                }
                ++n;
            }
        }
    }

    class OptionController
    extends MouseInputAdapter {
        OptionController() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (DrawingPanel.this.isZoomEvent(mouseEvent)) {
                DrawingPanel.this.zoomBox.startZoom(mouseEvent.getX(), mouseEvent.getY());
            } else {
                DrawingPanel.this.zoomBox.visible = false;
                DrawingPanel.this.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            DrawingPanel.this.zoomBox.drag(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (DrawingPanel.this.isZoomEvent(mouseEvent) && DrawingPanel.this.popupmenu != null && DrawingPanel.this.popupmenu.isEnabled()) {
                Serializable serializable;
                if (DrawingPanel.this.isZoom() && !DrawingPanel.this.zoomBox.isDragged() && DrawingPanel.this.zoomBox.showUndraggedBox) {
                    serializable = DrawingPanel.this.viewRect == null ? DrawingPanel.this.getSize() : DrawingPanel.this.viewRect.getSize();
                    ((Dimension)serializable).width -= DrawingPanel.this.getLeftGutter() + DrawingPanel.this.getRightGutter();
                    ((Dimension)serializable).height -= DrawingPanel.this.getTopGutter() + DrawingPanel.this.getBottomGutter();
                    DrawingPanel.this.zoomBox.xstart = mouseEvent.getX() - ((Dimension)serializable).width / 4;
                    DrawingPanel.this.zoomBox.xstop = mouseEvent.getX() + ((Dimension)serializable).width / 4;
                    DrawingPanel.this.zoomBox.ystart = mouseEvent.getY() - ((Dimension)serializable).height / 4;
                    DrawingPanel.this.zoomBox.ystop = mouseEvent.getY() + ((Dimension)serializable).height / 4;
                    DrawingPanel.this.zoomBox.visible = true;
                    DrawingPanel.this.repaint();
                }
                if ((serializable = DrawingPanel.this.getPopupMenu()) != null) {
                    serializable.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                return;
            }
            if (OSPRuntime.isPopupTrigger(mouseEvent) && DrawingPanel.this.popupmenu == null && DrawingPanel.this.customInspector != null) {
                DrawingPanel.this.customInspector.setVisible(true);
                return;
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (component != null && !(component instanceof JTextComponent)) {
                DrawingPanel.this.requestFocusInWindow();
            }
        }
    }

    class PopupmenuListener
    implements ActionListener {
        PopupmenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DrawingPanel.this.zoomBox.visible = false;
            DrawingPanel.this.repaint();
            String string = actionEvent.getActionCommand();
            if (string.equals(DisplayRes.getString("DrawingFrame.InspectMenuItem"))) {
                DrawingPanel.this.showInspector();
            } else if (string.equals(DisplayRes.getString("DisplayPanel.Snapshot_menu_item"))) {
                DrawingPanel.this.snapshot();
            } else if (string.equals(DisplayRes.getString("DisplayPanel.Zoom_in_menu_item"))) {
                DrawingPanel.this.setAutoscaleX(false);
                DrawingPanel.this.setAutoscaleY(false);
                DrawingPanel.this.zoomIn();
            } else if (string.equals(DisplayRes.getString("DisplayPanel.Zoom_out_menu_item"))) {
                DrawingPanel.this.setAutoscaleX(false);
                DrawingPanel.this.setAutoscaleY(false);
                DrawingPanel.this.zoomOut();
            } else if (string.equals(DisplayRes.getString("DrawingFrame.Autoscale_menu_item"))) {
                double d = Double.NaN;
                DrawingPanel.this.setPreferredMinMax(d, d, d, d);
            } else if (string.equals(DisplayRes.getString("DrawingFrame.Scale_menu_item"))) {
                ScaleInspector scaleInspector = new ScaleInspector(DrawingPanel.this);
                scaleInspector.setLocationRelativeTo(DrawingPanel.this);
                scaleInspector.updateDisplay();
                scaleInspector.setVisible(true);
            }
        }
    }

    public class ZoomBox {
        int xstart;
        int ystart;
        int xstop;
        int ystop;
        int xlast;
        int ylast;
        boolean visible = false;
        boolean dragged = false;
        boolean showUndraggedBox = true;

        public void startZoom(int n, int n2) {
            if (!DrawingPanel.this.isZoom()) {
                return;
            }
            this.visible = true;
            this.dragged = false;
            this.xstop = this.xstart = n;
            this.xlast = this.xstart;
            this.ystop = this.ystart = n2;
            this.ylast = this.ystart;
            DrawingPanel.this.repaint();
        }

        public void hide() {
            this.visible = false;
            DrawingPanel.this.repaint();
        }

        public void setShowUndraggedBox(boolean bl) {
            this.showUndraggedBox = bl;
        }

        public void drag(int n, int n2) {
            if (!this.visible) {
                return;
            }
            this.dragged = true;
            this.xstop = n;
            this.ystop = n2;
            Graphics graphics = DrawingPanel.this.getGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setXORMode(Color.green);
            graphics.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            this.xlast = this.xstop;
            this.ylast = this.ystop;
            graphics.drawRect(Math.min(this.xstart, this.xlast), Math.min(this.ystart, this.ylast), Math.abs(this.xlast - this.xstart), Math.abs(this.ylast - this.ystart));
            graphics.setPaintMode();
            graphics.dispose();
        }

        void paint(Graphics graphics) {
            if (!this.visible) {
                return;
            }
            if (this.xstop == this.xstart || this.ystop == this.ystart) {
                return;
            }
            graphics.setColor(Color.magenta);
            graphics.drawRect(Math.min(this.xstart, this.xstop), Math.min(this.ystart, this.ystop), Math.abs(this.xstop - this.xstart), Math.abs(this.ystop - this.ystart));
        }

        public boolean isDragged() {
            return this.dragged && this.xstop != this.xstart && this.ystop != this.ystart;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public Rectangle reportZoom() {
            int n = Math.min(this.xstart, this.xstop);
            int n2 = Math.max(this.xstart, this.xstop);
            int n3 = Math.min(this.ystart, this.ystop);
            int n4 = Math.max(this.ystart, this.ystop);
            return new Rectangle(n, n3, n2 - n, n4 - n3);
        }
    }
}

