/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DiagnosticsForXuggle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsManager {
    static String xuggleHome = System.getenv("XUGGLE_HOME");
    static ExtensionsFilter extFilter = new ExtensionsFilter();

    public static void main(String[] stringArray) {
        ExtensionsManager extensionsManager = new ExtensionsManager();
        extensionsManager.printExtensionDirectoriesForXuggle(" ");
    }

    /*
     * WARNING - void declaration
     */
    public void printExtensionDirectoriesForXuggle(String string) {
        void var4_8;
        Collection<File> collection = this.findJavaExtensionDirectoriesForXuggle();
        StringBuffer stringBuffer = new StringBuffer(2);
        for (File object2 : collection) {
            String string2 = XML.forwardSlash(object2.getPath());
            stringBuffer.append("\"" + string2 + "\"" + string);
        }
        String string3 = stringBuffer.toString();
        if (string3.length() >= string.length()) {
            String string4 = string3.substring(0, string3.length() - string.length());
        }
        System.out.print((String)var4_8);
    }

    public boolean copyXuggleJarsTo(File file, boolean bl) {
        if (xuggleHome == null || file == null) {
            return false;
        }
        if (!new File(String.valueOf(xuggleHome) + "/share/java/jars/xuggle-xuggler.jar").exists()) {
            return false;
        }
        File file2 = new File(String.valueOf(xuggleHome) + "/share/java/jars");
        String[] stringArray = DiagnosticsForXuggle.xuggleJarNames;
        File file3 = new File(file2, stringArray[0]);
        long l = file3.lastModified();
        File file4 = new File(file, stringArray[0]);
        if (bl || !file4.exists() || file4.lastModified() != l) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                file3 = new File(file2, string);
                file4 = new File(file, string);
                if (!this.copyFile(file3, file4)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return true;
    }

    public boolean removeXuggleFrom(File file) {
        String[] stringArray;
        String[] stringArray2 = stringArray = new String[]{"xuggle-xuggler.jar", "slf4j-api.jar", "logback-core.jar", "logback-classic.jar"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            File file2 = new File(file, string);
            if (file2.exists() && !file2.delete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean copyQTJavaTo(File file, boolean bl) {
        Object object;
        String string = "QTJava.zip";
        String[] stringArray = new String[]{"C:/Program Files/QuickTime/QTSystem/", "C:/windows/system32/", "C:/windows/system/", "C:/winNT/system32/", "system/library/java/extensions/"};
        long l = 0L;
        File file2 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l2;
            object = stringArray2[n2];
            File file3 = new File(String.valueOf(object) + string);
            if (file3.exists() && (l2 = file3.lastModified()) > l) {
                l = Math.max(l, l2);
                file2 = file3;
            }
            ++n2;
        }
        if (file2 == null) {
            return false;
        }
        object = new File(file, string);
        if (bl || !((File)object).exists() || ((File)object).lastModified() < l) {
            return this.copyFile(file2, (File)object);
        }
        return false;
    }

    public boolean removeQTJavaFrom(File file) {
        File file2 = new File(file, "QTJava.zip");
        return !file2.exists() || file2.delete();
    }

    public Collection<File> findAllJavaExtensionDirectories() {
        HashSet<File> hashSet = new HashSet<File>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<Object> hashSet3 = new HashSet<Object>();
        try {
            Object object;
            String string = XML.forwardSlash(System.getProperty("java.ext.dirs"));
            String string2 = System.getProperty("path.separator");
            int n = string.indexOf(string2);
            while (n > -1) {
                hashSet2.add(string.substring(0, n));
                string = string.substring(n + 1);
                n = string.indexOf(string2);
            }
            if (!"".equals(string)) {
                hashSet2.add(string);
            }
            block3: for (String object2 : hashSet2) {
                object = new File(object2);
                if (!((File)object).exists()) continue;
                hashSet.add((File)object);
                if (OSPRuntime.isMac()) {
                    while (((File)object).getPath().indexOf("/JavaVirtualMachines") > -1) {
                        if (((File)object).getName().equals("JavaVirtualMachines")) {
                            hashSet3.add(object);
                            continue block3;
                        }
                        object = ((File)object).getParentFile();
                    }
                    continue;
                }
                if (!OSPRuntime.isLinux()) continue;
                while (((File)object).getPath().indexOf("/jvm") > -1) {
                    if (((File)object).getName().equals("jvm")) {
                        hashSet3.add(object);
                        continue block3;
                    }
                    object = ((File)object).getParentFile();
                }
            }
            if (OSPRuntime.isWindows()) {
                File file;
                String string3 = System.getenv("ProgramFiles");
                String string32 = System.getenv("ProgramW6432");
                object = System.getenv("ProgramFiles(x86)");
                if (string3 != null && (file = new File(string3, "Java")).exists()) {
                    hashSet3.add(file);
                }
                if (string32 != null && (file = new File(string32, "Java")).exists()) {
                    hashSet3.add(file);
                }
                if (object != null && (file = new File((String)object, "Java")).exists()) {
                    hashSet3.add(file);
                }
            }
            for (File file : hashSet3) {
                this.findJavaExtensionDirectories(file, hashSet);
            }
        }
        catch (Exception exception) {}
        return hashSet;
    }

    public Collection<File> findJavaExtensionDirectoriesForXuggle() {
        Collection<File> collection = this.findAllJavaExtensionDirectories();
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : collection) {
            File file2 = file.getParentFile().getParentFile();
            int n = file2.getPath().indexOf("jdk");
            n = Math.max(n, file2.getPath().indexOf("jre"));
            int n2 = file2.getPath().indexOf("1.5.");
            n2 = Math.max(n2, file2.getPath().indexOf("-5-"));
            n2 = Math.max(n2, file2.getPath().indexOf("1.4."));
            n2 = Math.max(n2, file2.getPath().indexOf("1.3."));
            n2 = Math.max(n2, file2.getPath().indexOf("1.2."));
            n2 = Math.max(n2, file2.getPath().indexOf("1.3."));
            n2 = Math.max(n2, file2.getPath().indexOf("1.2."));
            if (n <= -1 || n2 <= -1) continue;
            hashSet.add(file);
        }
        collection.removeAll(hashSet);
        return collection;
    }

    public Collection<File> findJavaExtensionDirectories(File file, Set<File> set) {
        try {
            if (!file.getCanonicalPath().equals(file.getAbsolutePath())) {
                return set;
            }
        }
        catch (IOException iOException) {}
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                File file2 = new File(file, string);
                if (extFilter.accept(file2, file2.getName())) {
                    set.add(file2);
                } else {
                    this.findJavaExtensionDirectories(file2, set);
                }
                ++n2;
            }
        }
        return set;
    }

    public Collection<File> findPublicJREsForXuggle(boolean bl) {
        Collection<File> collection = this.findJavaExtensionDirectoriesForXuggle();
        HashSet<File> hashSet = new HashSet<File>();
        try {
            String string = System.getenv("ProgramFiles(x86)");
            for (File file : collection) {
                String string2;
                File file2 = file.getParentFile().getParentFile();
                if (OSPRuntime.isWindows()) {
                    if (bl && string != null && file.getPath().indexOf(string) == -1 || file.getPath().indexOf("jdk") > -1 || !(file2 = new File(file2, "bin/java.exe")).exists()) continue;
                    string2 = OSPRuntime.getJREPath(file2);
                    hashSet.add(new File(string2));
                    continue;
                }
                if (!(file2 = new File(file2, "bin/java")).exists()) continue;
                string2 = OSPRuntime.getJREPath(file2);
                hashSet.add(new File(string2));
            }
        }
        catch (Exception exception) {}
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean copyFile(File file, File file2) {
        byte[] byArray = new byte[100000];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while (true) {
                byte[] byArray2 = byArray;
                // MONITORENTER : byArray
                int n = ((InputStream)fileInputStream).read(byArray);
                if (n == -1) {
                    // MONITOREXIT : byArray2
                    break;
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                // MONITOREXIT : byArray2
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            file2.setLastModified(file.lastModified());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static class ExtensionsFilter
    implements FilenameFilter {
        ExtensionsFilter() {
        }

        public boolean accept(File file, String string) {
            if (!file.isDirectory()) {
                return false;
            }
            String string2 = XML.forwardSlash(file.getPath());
            if (string2.endsWith("/lib/ext")) {
                if (string2.endsWith("/jre/lib/ext")) {
                    return true;
                }
                String string3 = XML.getName(string2.substring(0, string2.length() - 8));
                if (string3.indexOf("jre") > -1) {
                    return true;
                }
                if (string2.indexOf("jdk") > -1 && string2.indexOf("/Java/") > -1) {
                    return true;
                }
                if (string2.indexOf("jre") > -1 && string2.indexOf("/Java/") > -1) {
                    return true;
                }
            }
            if (string2.endsWith("java/packages/lib/ext")) {
                return true;
            }
            if (string2.endsWith("Java/lib/ext")) {
                return true;
            }
            return string2.endsWith("Java/Extensions");
        }
    }
}

