/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;

public class ClipInspector
extends JDialog {
    protected VideoClip clip;
    protected ClipControl clipControl;
    protected JLabel startLabel;
    protected JLabel stepSizeLabel;
    protected JLabel t0Label;
    protected JLabel endLabel;
    protected JLabel dtLabel;
    protected JLabel fpsLabel;
    protected IntegerField startField;
    protected IntegerField stepSizeField;
    protected IntegerField endField;
    protected NumberField t0Field;
    protected NumberField dtField;
    protected NumberField fpsField;
    protected JButton okButton;
    protected JButton cancelButton;
    protected int prevFrame;
    protected int prevStart;
    protected int prevEnd;
    protected int prevSize;
    protected int prevCount;
    protected double prevDt;
    protected double prevRate;
    protected double prevStartTime;
    protected boolean prevDefault;
    protected int currentStart;
    protected int currentCount;
    protected Box frameBox;
    protected Box timeBox;

    public ClipInspector(VideoClip videoClip, ClipControl clipControl, Frame frame) {
        super(frame, false);
        this.setResizable(false);
        this.clip = videoClip;
        this.clipControl = clipControl;
        this.createGUI();
        this.refresh();
        this.initialize();
    }

    public void initialize() {
        this.updateDisplay();
        this.prevStart = this.clip.getStartFrameNumber();
        this.prevEnd = this.clip.getEndFrameNumber();
        this.prevSize = this.clip.getStepSize();
        this.prevCount = this.clip.getStepCount();
        this.prevStartTime = this.clip.getStartTime();
        this.prevDefault = this.clip.isDefaultStartTime;
        this.prevDt = this.clipControl.getMeanFrameDuration();
        this.prevRate = this.clipControl.getRate();
        this.prevFrame = this.clipControl.getFrameNumber();
        this.currentStart = this.clip.getStartFrameNumber();
        this.currentCount = this.clip.getStepCount();
    }

    public void refresh() {
        this.setTitle(MediaRes.getString("ClipInspector.Title"));
        this.startLabel.setText(MediaRes.getString("ClipInspector.Label.StartFrame"));
        this.stepSizeLabel.setText(MediaRes.getString("ClipInspector.Label.StepSize"));
        this.t0Label.setText(MediaRes.getString("ClipInspector.Label.StartTime"));
        this.endLabel.setText(MediaRes.getString("ClipInspector.Label.EndFrame"));
        this.cancelButton.setText(MediaRes.getString("Dialog.Button.Cancel"));
        this.okButton.setText(MediaRes.getString("Dialog.Button.OK"));
        this.dtLabel.setText(MediaRes.getString("ClipInspector.Label.FrameDt"));
        this.fpsLabel.setText(MediaRes.getString("ClipInspector.Label.FPS"));
        this.frameBox.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("ClipInspector.Title.Frames")));
        this.timeBox.setBorder(BorderFactory.createTitledBorder(MediaRes.getString("ClipInspector.Title.FrameTimes")));
        this.pack();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        Border border = BorderFactory.createEmptyBorder(3, 2, 3, 2);
        this.startLabel = new JLabel();
        this.startLabel.setForeground(new Color(0, 0, 102));
        this.startLabel.setFont(new Font("Dialog", 0, 12));
        this.startLabel.setBorder(border);
        this.startField = new IntegerField(5);
        this.startField.setMaximumSize(this.startField.getPreferredSize());
        final ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClipInspector.this.clip.getStartFrameNumber();
                if (!ClipInspector.this.clip.setStartFrameNumber(ClipInspector.this.startField.getIntValue(), ClipInspector.this.clip.getEndFrameNumber())) {
                    ClipInspector.this.startField.selectAll();
                    return;
                }
                ClipInspector.this.currentStart = ClipInspector.this.clip.getStartFrameNumber();
                if (!ClipInspector.this.clip.isDefaultStartTime) {
                    double d = ClipInspector.this.clip.getStartTime();
                    ClipInspector.this.clip.setStartTime(d += (double)(ClipInspector.this.currentStart - n) * ClipInspector.this.clipControl.getMeanFrameDuration());
                }
                ClipInspector.this.clip.trimFrameCount();
                ClipInspector.this.currentCount = ClipInspector.this.clip.getStepCount();
                ClipInspector.this.updateDisplay();
                ClipInspector.this.startField.selectAll();
                ClipInspector.this.clipControl.setStepNumber(0);
            }
        };
        this.startField.addActionListener(actionListener);
        this.startField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.startField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                actionListener.actionPerformed(null);
            }
        });
        this.stepSizeLabel = new JLabel();
        this.stepSizeLabel.setForeground(new Color(0, 0, 102));
        this.stepSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.stepSizeLabel.setBorder(border);
        this.stepSizeField = new IntegerField(5);
        this.stepSizeField.setMaximumSize(this.stepSizeField.getPreferredSize());
        this.stepSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ClipInspector.this.clipControl.getFrameNumber();
                if (!ClipInspector.this.clip.setStepSize(ClipInspector.this.stepSizeField.getIntValue())) {
                    ClipInspector.this.stepSizeField.selectAll();
                    return;
                }
                ClipInspector.this.currentCount = ClipInspector.this.clip.getStepCount();
                ClipInspector.this.updateDisplay();
                ClipInspector.this.stepSizeField.selectAll();
                ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.frameToStep(n));
            }
        });
        this.stepSizeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.stepSizeField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                int n = ClipInspector.this.clipControl.getFrameNumber();
                if (!ClipInspector.this.clip.setStepSize(ClipInspector.this.stepSizeField.getIntValue())) {
                    ClipInspector.this.stepSizeField.selectAll();
                    return;
                }
                ClipInspector.this.currentCount = ClipInspector.this.clip.getStepCount();
                ClipInspector.this.updateDisplay();
                ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.frameToStep(n));
            }
        });
        this.endLabel = new JLabel();
        this.endLabel.setForeground(new Color(0, 0, 102));
        this.endLabel.setFont(new Font("Dialog", 0, 12));
        this.endLabel.setBorder(border);
        this.endField = new IntegerField(5);
        this.endField.setMaximumSize(this.endField.getPreferredSize());
        this.endField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ClipInspector.this.clip.setEndFrameNumber(ClipInspector.this.endField.getIntValue())) {
                    ClipInspector.this.endField.selectAll();
                    return;
                }
                ClipInspector.this.currentCount = ClipInspector.this.clip.getStepCount();
                ClipInspector.this.updateDisplay();
                ClipInspector.this.endField.selectAll();
                Video video2 = ClipInspector.this.clip.getVideo();
                if (video2 != null && video2.getFrameCount() > 1) {
                    ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.getStepCount() - 1);
                }
            }
        });
        this.endField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.endField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!ClipInspector.this.clip.setEndFrameNumber(ClipInspector.this.endField.getIntValue())) {
                    ClipInspector.this.endField.selectAll();
                    return;
                }
                ClipInspector.this.updateDisplay();
                Video video2 = ClipInspector.this.clip.getVideo();
                if (video2 != null && video2.getFrameCount() > 1) {
                    ClipInspector.this.clipControl.setStepNumber(ClipInspector.this.clip.getStepCount() - 1);
                }
            }
        });
        this.t0Label = new JLabel();
        this.t0Label.setForeground(new Color(0, 0, 102));
        this.t0Label.setFont(new Font("Dialog", 0, 12));
        this.t0Label.setBorder(border);
        this.t0Field = new NumberField(5);
        String string = "0.00E0";
        String string2 = "0.000";
        double[] dArray = new double[]{0.01, 0.1, 1.0, 10.0};
        this.t0Field.setPatterns(new String[]{string2, string2, string2, string2, string}, dArray);
        this.t0Field.setUnits(" s");
        this.t0Field.setMaximumSize(this.t0Field.getPreferredSize());
        this.t0Field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ClipInspector.this.t0Field.getText().equals("")) {
                    ClipInspector.this.clip.setStartTime(Double.NaN);
                } else {
                    ClipInspector.this.clip.setStartTime(ClipInspector.this.t0Field.getValue() * 1000.0);
                }
                ClipInspector.this.updateDisplay();
                ClipInspector.this.t0Field.selectAll();
            }
        });
        this.t0Field.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.t0Field.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (ClipInspector.this.t0Field.getText().equals("")) {
                    ClipInspector.this.clip.setStartTime(Double.NaN);
                } else {
                    ClipInspector.this.clip.setStartTime(ClipInspector.this.t0Field.getValue() * 1000.0);
                }
                ClipInspector.this.updateDisplay();
            }
        });
        this.dtLabel = new JLabel();
        this.dtLabel.setForeground(new Color(0, 0, 102));
        this.dtLabel.setFont(new Font("Dialog", 0, 12));
        this.dtLabel.setBorder(border);
        this.dtField = new NumberField(5);
        this.dtField.setPatterns(new String[]{string, string2, string2, string2, string}, dArray);
        this.dtField.setUnits(" s");
        this.dtField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clipControl.setFrameDuration(ClipInspector.this.dtField.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
                ClipInspector.this.dtField.selectAll();
            }
        });
        this.dtField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.dtField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clipControl.setFrameDuration(ClipInspector.this.dtField.getValue() * 1000.0);
                ClipInspector.this.updateDisplay();
            }
        });
        this.fpsLabel = new JLabel();
        this.fpsLabel.setForeground(new Color(0, 0, 102));
        this.fpsLabel.setFont(new Font("Dialog", 0, 12));
        this.fpsLabel.setBorder(border);
        this.fpsField = new NumberField(5);
        string = "0.0E0";
        string2 = "0.00";
        this.fpsField.setPatterns(new String[]{string, string2, string2, string2, string});
        this.fpsField.setMaxValue(100000.0);
        this.fpsField.setUnits(" /s");
        this.fpsField.setMinValue(1.0E-6);
        this.fpsField.setMaximumSize(this.fpsField.getPreferredSize());
        this.fpsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.clipControl.setFrameDuration(1000.0 / ClipInspector.this.fpsField.getValue());
                ClipInspector.this.updateDisplay();
                ClipInspector.this.fpsField.selectAll();
            }
        });
        this.fpsField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ClipInspector.this.fpsField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ClipInspector.this.clipControl.setFrameDuration(1000.0 / ClipInspector.this.fpsField.getValue());
                ClipInspector.this.updateDisplay();
            }
        });
        Box box = Box.createVerticalBox();
        Border border2 = BorderFactory.createLineBorder(Color.GRAY);
        Border border3 = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        box.setBorder(BorderFactory.createCompoundBorder(border2, border3));
        jPanel.add((Component)box, "Center");
        this.frameBox = Box.createVerticalBox();
        this.timeBox = Box.createVerticalBox();
        box.add(this.frameBox);
        box.add(this.timeBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        jPanel2.add((Component)this.startLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel2.add((Component)this.startField, gridBagConstraints);
        this.frameBox.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        jPanel3.add((Component)this.stepSizeLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel3.add((Component)this.stepSizeField, gridBagConstraints);
        this.frameBox.add(jPanel3);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        jPanel4.add((Component)this.endLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel4.add((Component)this.endField, gridBagConstraints);
        this.frameBox.add(jPanel4);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        jPanel5.add((Component)this.t0Label, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel5.add((Component)this.t0Field, gridBagConstraints);
        this.timeBox.add(jPanel5);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        jPanel6.add((Component)this.fpsLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel6.add((Component)this.fpsField, gridBagConstraints);
        this.timeBox.add(jPanel6);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.anchor = 22;
        jPanel7.add((Component)this.dtLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 21;
        jPanel7.add((Component)this.dtField, gridBagConstraints);
        this.timeBox.add(jPanel7);
        this.cancelButton = new JButton();
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.revert();
                ClipInspector.this.setVisible(false);
            }
        });
        this.okButton = new JButton();
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector.this.setVisible(false);
            }
        });
        JPanel jPanel8 = new JPanel();
        jPanel.add((Component)jPanel8, "South");
        jPanel8.add(this.okButton);
        jPanel8.add(this.cancelButton);
    }

    public void updateDisplay() {
        this.startField.setIntValue(this.clip.getStartFrameNumber());
        this.stepSizeField.setIntValue(this.clip.getStepSize());
        this.t0Field.setValue(this.clip.getStartTime() / 1000.0);
        this.endField.setIntValue(this.clip.getEndFrameNumber());
        double d = this.clipControl.getMeanFrameDuration();
        if (d > 0.0) {
            this.dtField.setValue(d / 1000.0);
            this.fpsField.setValue(1000.0 / d);
        } else {
            this.dtField.setText(null);
            this.fpsField.setText(null);
        }
        this.repaint();
    }

    private void revert() {
        this.clip.setStartFrameNumber(this.prevStart);
        this.clip.setStepSize(this.prevSize);
        this.clip.setStepCount(this.prevCount);
        if (this.prevDefault) {
            this.clip.setStartTime(Double.NaN);
        } else {
            this.clip.setStartTime(this.prevStartTime);
        }
        this.clipControl.setRate(this.prevRate);
        this.clipControl.setFrameDuration(this.prevDt);
        this.clipControl.setStepNumber(this.clip.frameToStep(this.prevFrame));
        this.clip.trimFrameCount();
    }
}

