/*
 * Decompiled with CFR 0.152.
 */
package RoessMa.Differentialgleichungen_Chaos.Wedge_pkg;

import RoessMa.Differentialgleichungen_Chaos.Wedge_pkg.WedgeSimulation;
import RoessMa.Differentialgleichungen_Chaos.Wedge_pkg.WedgeView;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorResourceUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.EJSODE;
import org.opensourcephysics.numerics.GeneralStateEvent;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.CashKarp45;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wedge
extends Model {
    public WedgeSimulation _simulation = null;
    public WedgeView _view = null;
    public Wedge _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EJSODE> _privateOdesList = new Hashtable();
    public double x = -0.02;
    public double vx = 0.5;
    public double y = 0.75;
    public double vy = 0.0;
    public double t = 0.0;
    public double dt = 0.2;
    public double angle = 0.3;
    public double g = 0.5;
    public int points_index = 0;
    public boolean high_speed = false;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_initialization2 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution1_Event1 = true;
    private boolean _isEnabled_evolution1_Event2 = true;
    private boolean _isEnabled_evolution1_Event3 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return Wedge._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/RoessMa/Differentialgleichungen_Chaos/Wedge.xml";
    }

    public static String _getModelDirectory() {
        return "RoessMa/Differentialgleichungen_Chaos/";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(380, 337);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("RoessMa/Differentialgleichungen_Chaos/");
        n = 0;
        boolean bl2 = false;
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("E:/EJS_Versionen/EJS_4.3.7_17.5.2012/EJS_4.3.7/bin/config/");
        }
        Wedge._addHtmlPageInfo("Intro Page", "_default_", "Intro Page", "./Wedge_Intro 1.html");
        Wedge._addHtmlPageInfo("Bedienung", "_default_", "Bedienung", "./Wedge_Intro 2.html");
        Wedge._addHtmlPageInfo("Authors", "_default_", "Authors", "./Wedge_Intro 3.html");
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!Wedge._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        Wedge wedge = new Wedge(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!Wedge._common_initialization(stringArray)) {
            return null;
        }
        Wedge wedge = new Wedge("drawingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)wedge._getView().getComponent("drawingFrame");
    }

    public Wedge() {
        this(null, null, null, null, null, false);
    }

    public Wedge(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public Wedge(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new WedgeSimulation(this, string, frame, uRL, bl);
        this._view = (WedgeView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public String _getClassEjsModel() {
        return Wedge._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return Wedge._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return Wedge._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_initialization2 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution1_Event1 = true;
        this._isEnabled_evolution1_Event2 = true;
        this._isEnabled_evolution1_Event3 = true;
        this.x = -0.02;
        this.vx = 0.5;
        this.y = 0.75;
        this.vy = 0.0;
        this.t = 0.0;
        this.dt = 0.2;
        this.angle = 0.3;
        this.g = 0.5;
        this.points_index = 0;
        this.high_speed = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EJSODE eJSODE : this._privateOdesList.values()) {
            eJSODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        if (this._isEnabled_initialization2) {
            this._initialization2();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.step();
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
    }

    @Override
    public void _freeMemory() {
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EJSODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("html-start".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization2 = bl;
        }
        if ("ODE".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("vertexEvent".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1_Event1 = bl;
            this._ODEi_evolution1.initializeSolver();
        }
        if ("rightEvent".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1_Event2 = bl;
            this._ODEi_evolution1.initializeSolver();
        }
        if ("leftEvent".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1_Event3 = bl;
            this._ODEi_evolution1.initializeSolver();
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.checkValidState();
        this._setStepsPerDisplay(1);
    }

    public void _initialization2() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Wedge.this._view.showDescription(true);
            }
        });
        thread.start();
    }

    public void setAngle(double d, double d2) {
        this.angle = Math.min(Math.abs(Math.atan(d / d2)), 1.5607963267948965);
        this.checkValidState();
        this.t = 0.0;
        this._view.points.clear();
        this._view.resetTraces();
    }

    public void checkValidState() {
        double d;
        this.angle = Math.min(Math.abs(this.angle), 1.5607963267948965);
        if (this.y < 0.0) {
            this.y = 0.0;
        }
        if (this.y > 1.0) {
            this.y = 1.0;
        }
        if ((d = Math.atan2(this.x, this.y)) > this.angle) {
            this.x = this.y * Math.tan(this.angle);
        }
        if (-d > this.angle) {
            this.x = -this.y * Math.tan(this.angle);
        }
        double d2 = Math.sqrt(1.0 - this.y);
        d = Math.atan2(this.vy, this.vx);
        this.vx = d2 * Math.cos(d);
        this.vy = d2 * Math.sin(d);
        this._view.resetTraces();
    }

    public void setPoincareState(double d, double d2) {
        double d3 = d * d + d2;
        if (d3 > 1.0) {
            return;
        }
        double d4 = Math.sqrt(d2);
        this.y = 1.0 - d3;
        this.x = this.y * Math.tan(this.angle);
        double d5 = Math.sin(this.angle);
        double d6 = Math.cos(this.angle);
        this.vx = d * d5 - d4 * d6;
        this.vy = d * d6 + d4 * d5;
        ++this.points_index;
        this._view.trace.clear();
    }

    public void setHighSpeed() {
        if (this.high_speed) {
            this._setStepsPerDisplay(20);
        } else {
            this._setStepsPerDisplay(1);
        }
    }

    public String _method_for_drawingPanel_TRmessage() {
        return "time=" + this._format(this.t, "0.00");
    }

    public void _method_for_particle_dragaction() {
        this.checkValidState();
    }

    public void _method_for_particle_action() {
        this.checkValidState();
    }

    public double _method_for_rightWedge_x() {
        return Math.sin(this.angle);
    }

    public double _method_for_rightWedge_y() {
        return Math.cos(this.angle);
    }

    public double _method_for_rightWedge_sizex() {
        return 10.0 * Math.sin(this.angle);
    }

    public double _method_for_rightWedge_sizey() {
        return 10.0 * Math.cos(this.angle);
    }

    public double _method_for_right_sizex() {
        return Math.sin(this.angle);
    }

    public double _method_for_right_sizey() {
        return Math.cos(this.angle);
    }

    public void _method_for_right_dragaction() {
        double d = this._view.drawingPanel.getMouseX();
        double d2 = this._view.drawingPanel.getMouseY();
        this.setAngle(d, d2);
    }

    public double _method_for_leftWedge_x() {
        return -Math.sin(this.angle);
    }

    public double _method_for_leftWedge_y() {
        return Math.cos(this.angle);
    }

    public double _method_for_leftWedge_sizex() {
        return -10.0 * Math.sin(this.angle);
    }

    public double _method_for_leftWedge_sizey() {
        return 10.0 * Math.cos(this.angle);
    }

    public double _method_for_left_sizex() {
        return -Math.sin(this.angle);
    }

    public double _method_for_left_sizey() {
        return Math.cos(this.angle);
    }

    public void _method_for_left_dragaction() {
        double d = this._view.drawingPanel.getMouseX();
        double d2 = this._view.drawingPanel.getMouseY();
        this.setAngle(d, d2);
    }

    public void _method_for_startStopButton_actionOn() {
        this._play();
    }

    public void _method_for_startStopButton_actionOff() {
        this._pause();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_angleField_action() {
        this.checkValidState();
    }

    public void _method_for_highSpeedBox_action() {
        this.setHighSpeed();
    }

    public void _method_for_poincarePanel_action() {
        double d = this._view.poincarePanel.getMouseX();
        double d2 = this._view.poincarePanel.getMouseY();
        this.setPoincareState(d, d2);
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
        __translatorUtil = new TranslatorResourceUtil("RoessMa.Differentialgleichungen_Chaos.Wedge_pkg.Wedge");
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements EJSODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;

        _ODE_evolution1() {
            this.__instantiateSolver();
            Wedge.this._privateOdesList.put("ODE", this);
        }

        @Override
        public ODEInterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else if (string.indexOf("qss") >= 0) {
                string = string2 + "qss.Qss3";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[4];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getSolver().getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            this.__pushState();
            this.__eventSolver.removeAllEvents();
            this.__eventSolver.initialize(Wedge.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            if (Wedge.this._isEnabled_evolution1_Event1) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event1());
            }
            if (Wedge.this._isEnabled_evolution1_Event2) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event2());
            }
            if (Wedge.this._isEnabled_evolution1_Event3) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event3());
            }
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n = 0;
            if (this.__state[n] != Wedge.this.x) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = Wedge.this.x;
            if (this.__state[n] != Wedge.this.y) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = Wedge.this.y;
            if (this.__state[n] != Wedge.this.vy) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = Wedge.this.vy;
            if (this.__state[n] != Wedge.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n++] = Wedge.this.t;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(Wedge.this._view.getComponent(Wedge.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                Wedge.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (Wedge.this.dt == 0.0) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(Wedge.this.dt);
            this.__eventSolver.setInternalStepSize(Wedge.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != 0) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            Wedge.this.x = this.__state[n++];
            Wedge.this.y = this.__state[n++];
            Wedge.this.vy = this.__state[n++];
            Wedge.this.t = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != 0) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            dArray2[dArray2.length - 1] = 0.0;
            int n = -1;
            int n2 = 0;
            double d = dArray[n2++];
            double d2 = dArray[n2++];
            double d3 = dArray[n2++];
            double d4 = dArray[n2++];
            int n3 = 0;
            dArray2[n3++] = Wedge.this.vx;
            dArray2[n3++] = d3;
            dArray2[n3++] = -Wedge.this.g;
            dArray2[n3++] = 1.0;
        }

        private class _ODE_evolution1_Event3
        implements GeneralStateEvent {
            private _ODE_evolution1_Event3() {
            }

            public int getTypeOfEvent() {
                return 0;
            }

            public int getRootFindingMethod() {
                return 0;
            }

            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "leftEvent";
            }

            public double getTolerance() {
                return 1.0E-4;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                return d2 + d / Math.tan(Wedge.this.angle);
            }

            public boolean action() {
                int n = 0;
                Wedge.this.x = _ODE_evolution1.this.__state[n++];
                Wedge.this.y = _ODE_evolution1.this.__state[n++];
                Wedge.this.vy = _ODE_evolution1.this.__state[n++];
                Wedge.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                int n2 = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                double d = -Math.sin(Wedge.this.angle);
                double d2 = Math.cos(Wedge.this.angle);
                double d3 = -Wedge.this.vx * d2 + Wedge.this.vy * d;
                double d4 = Wedge.this.vx * d + Wedge.this.vy * d2;
                Wedge.this.vx += 2.0 * d3 * d2;
                Wedge.this.vy -= 2.0 * d3 * d;
                double d5 = 1.0 - Wedge.this.y - d4 * d4;
                Wedge.this._view.points.append(Wedge.this.points_index, d4, d3 * d3);
                return true;
            }
        }

        private class _ODE_evolution1_Event2
        implements GeneralStateEvent {
            private _ODE_evolution1_Event2() {
            }

            public int getTypeOfEvent() {
                return 0;
            }

            public int getRootFindingMethod() {
                return 0;
            }

            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "rightEvent";
            }

            public double getTolerance() {
                return 1.0E-4;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                return d2 - d / Math.tan(Wedge.this.angle);
            }

            public boolean action() {
                int n = 0;
                Wedge.this.x = _ODE_evolution1.this.__state[n++];
                Wedge.this.y = _ODE_evolution1.this.__state[n++];
                Wedge.this.vy = _ODE_evolution1.this.__state[n++];
                Wedge.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                int n2 = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                double d = Math.sin(Wedge.this.angle);
                double d2 = Math.cos(Wedge.this.angle);
                double d3 = -Wedge.this.vx * d2 + Wedge.this.vy * d;
                double d4 = Wedge.this.vx * d + Wedge.this.vy * d2;
                Wedge.this.vx += 2.0 * d3 * d2;
                Wedge.this.vy -= 2.0 * d3 * d;
                double d5 = 1.0 - Wedge.this.y - d4 * d4;
                Wedge.this._view.points.append(Wedge.this.points_index, d4, d3 * d3);
                return true;
            }
        }

        private class _ODE_evolution1_Event1
        implements GeneralStateEvent {
            private _ODE_evolution1_Event1() {
            }

            public int getTypeOfEvent() {
                return 0;
            }

            public int getRootFindingMethod() {
                return 0;
            }

            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "vertexEvent";
            }

            public double getTolerance() {
                return 1.0E-4;
            }

            public double evaluate(double[] dArray) {
                int n = 0;
                double d = dArray[n++];
                double d2 = dArray[n++];
                double d3 = dArray[n++];
                double d4 = dArray[n++];
                if (d3 >= 0.0) {
                    return 1.0;
                }
                return d2;
            }

            public boolean action() {
                int n = 0;
                Wedge.this.x = _ODE_evolution1.this.__state[n++];
                Wedge.this.y = _ODE_evolution1.this.__state[n++];
                Wedge.this.vy = _ODE_evolution1.this.__state[n++];
                Wedge.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                int n2 = 0;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.x;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.y;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.vy;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = Wedge.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                Wedge.this.vy = Math.abs(Wedge.this.vy);
                return true;
            }
        }
    }
}

