/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.io.IOException;
import java.io.OutputStream;
import org.opensourcephysics.media.gif.BitUtils;

class ScreenDescriptor {
    short localScreenWidth_;
    short localScreenHeight_;
    private byte byte_;
    byte backgroundColorIndex_;
    byte pixelAspectRatio_;

    ScreenDescriptor(short s, short s2, int n) {
        this.localScreenWidth_ = s;
        this.localScreenHeight_ = s2;
        this.SetGlobalColorTableSize((byte)(BitUtils.BitsNeeded(n) - 1));
        this.SetGlobalColorTableFlag((byte)1);
        this.SetSortFlag((byte)0);
        this.SetColorResolution((byte)7);
        this.backgroundColorIndex_ = 0;
        this.pixelAspectRatio_ = 0;
    }

    void Write(OutputStream outputStream) throws IOException {
        BitUtils.WriteWord(outputStream, this.localScreenWidth_);
        BitUtils.WriteWord(outputStream, this.localScreenHeight_);
        outputStream.write(this.byte_);
        outputStream.write(this.backgroundColorIndex_);
        outputStream.write(this.pixelAspectRatio_);
    }

    void SetGlobalColorTableSize(byte by) {
        this.byte_ = (byte)(this.byte_ | by & 7);
    }

    void SetSortFlag(byte by) {
        this.byte_ = (byte)(this.byte_ | (by & 1) << 3);
    }

    void SetColorResolution(byte by) {
        this.byte_ = (byte)(this.byte_ | (by & 7) << 4);
    }

    void SetGlobalColorTableFlag(byte by) {
        this.byte_ = (byte)(this.byte_ | (by & 1) << 7);
    }
}

