/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.desktop.ostermiller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Vector;
import org.opensourcephysics.desktop.ostermiller.BrowserCommandLexer;

public class Browser {
    public static String[] exec = null;

    public static void init() {
        exec = Browser.defaultCommands();
    }

    public static String[] defaultCommands() {
        String[] stringArray = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            stringArray = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            Vector<String> vector = new Vector<String>();
            try {
                Process process = Runtime.getRuntime().exec("which open");
                if (process.waitFor() == 0) {
                    vector.add("open {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            if (vector.size() > 0) {
                stringArray = vector.toArray(new String[0]);
            }
        } else if (System.getProperty("os.name").startsWith("SunOS")) {
            stringArray = new String[]{"/usr/dt/bin/sdtwebclient {0}"};
        } else {
            Process process;
            Vector<String> vector = new Vector<String>();
            try {
                process = Runtime.getRuntime().exec("which firebird");
                if (process.waitFor() == 0) {
                    vector.add("firebird -remote openURL({0})");
                    vector.add("firebird {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which mozilla");
                if (process.waitFor() == 0) {
                    vector.add("mozilla -remote openURL({0})");
                    vector.add("mozilla {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which opera");
                if (process.waitFor() == 0) {
                    vector.add("opera -remote openURL({0})");
                    vector.add("opera {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which galeon");
                if (process.waitFor() == 0) {
                    vector.add("galeon {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which konqueror");
                if (process.waitFor() == 0) {
                    vector.add("konqueror {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which netscape");
                if (process.waitFor() == 0) {
                    vector.add("netscape -remote openURL({0})");
                    vector.add("netscape {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            try {
                process = Runtime.getRuntime().exec("which xterm");
                if (process.waitFor() == 0 && (process = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    vector.add("xterm -e lynx {0}");
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            if (vector.size() > 0) {
                stringArray = vector.toArray(new String[0]);
            }
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void displayURL(String string) throws IOException {
        if (exec == null || exec.length == 0) {
            Class<?> clazz;
            Object object;
            if (!System.getProperty("os.name").startsWith("Mac")) throw new IOException("Browser execute command not defined.");
            boolean bl = false;
            try {
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    object = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURI().toURL()});
                    clazz = Class.forName("com.apple.cocoa.application.NSWorkspace", true, (ClassLoader)object);
                } else {
                    clazz = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                object = clazz.getMethod("sharedWorkspace", new Class[0]);
                Object object2 = ((Method)object).invoke(null, new Object[0]);
                Method method = clazz.getMethod("openURL", Class.forName("java.net.URL"));
                bl = (Boolean)method.invoke(object2, new URL(string));
            }
            catch (Exception exception) {}
            if (bl) return;
            try {
                clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                object = clazz.getMethod("openURL", Class.forName("java.lang.String"));
                ((Method)object).invoke(null, string);
                return;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                throw new IOException("Browser launch failed.");
            }
        }
        new URL(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                stringBuffer.append(c);
            } else if ((c = (char)(c & 0xFF)) < '\u0010') {
                stringBuffer.append("%0" + Integer.toHexString(c));
            } else {
                stringBuffer.append("%" + Integer.toHexString(c));
            }
            ++n;
        }
        Object[] objectArray = new String[]{stringBuffer.toString()};
        String string2 = null;
        boolean bl = false;
        try {
            int n2 = 0;
            while (n2 < exec.length && !bl) {
                try {
                    String string3;
                    string2 = MessageFormat.format(exec[n2], objectArray);
                    Vector<String> vector = new Vector<String>();
                    BrowserCommandLexer browserCommandLexer = new BrowserCommandLexer(new StringReader(string2));
                    while ((string3 = browserCommandLexer.getNextToken()) != null) {
                        vector.add(string3);
                    }
                    String[] stringArray = new String[vector.size()];
                    if ((stringArray = vector.toArray(stringArray))[0].equals("rundll32") && stringArray[1].equals("url.dll,FileProtocolHandler")) {
                        if (stringArray[2].startsWith("file:/")) {
                            if (stringArray[2].charAt(6) != '/') {
                                stringArray[2] = "file://" + stringArray[2].substring(6);
                            }
                            if (stringArray[2].charAt(7) != '/') {
                                stringArray[2] = "file:///" + stringArray[2].substring(7);
                            }
                        } else if (!stringArray[2].toLowerCase().endsWith("html")) {
                            stringArray[2].toLowerCase().endsWith("htm");
                        }
                    }
                    Process process = Runtime.getRuntime().exec(stringArray);
                    int n3 = 0;
                    while (n3 < 2) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++n3;
                    }
                    if (process.exitValue() == 0) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Warning: " + iOException.getMessage());
                }
                ++n2;
            }
            if (bl) return;
            throw new IOException("Browser launch failed.");
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
    }

    public static void displayURLs(String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (stringArray.length == 1) {
            Browser.displayURL(stringArray[0]);
            return;
        }
        File file = File.createTempFile("DisplayURLs", ".html");
        file = file.getCanonicalFile();
        file.deleteOnExit();
        PrintWriter printWriter = new PrintWriter(new FileWriter(file));
        printWriter.println("<!-- saved from url=(0014)about:internet -->");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title> Open URLs </title>");
        printWriter.println("<script language=\"javascript\" type=\"text/javascript\">");
        printWriter.println("function displayURLs(){");
        int n = 1;
        while (n < stringArray.length) {
            printWriter.println("window.open(\"" + stringArray[n] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
            ++n;
        }
        printWriter.println("location.href=\"" + stringArray[0] + "\";");
        printWriter.println("}");
        printWriter.println("</script>");
        printWriter.println("</head>");
        printWriter.println("<body onload=\"javascript:displayURLs()\">");
        printWriter.println("<noscript>");
        n = 0;
        while (n < stringArray.length) {
            printWriter.println("<a target=\"_blank\" href=\"" + stringArray[n] + "\">" + stringArray[n] + "</a><br>");
            ++n;
        }
        printWriter.println("</noscript>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        printWriter.close();
        Browser.displayURL(file.toURI().toURL().toString());
    }
}

