/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.geom.AffineTransform;

public class TransformArray {
    private AffineTransform[] array;
    private int length;

    public TransformArray(int n) {
        this.length = n;
        this.array = new AffineTransform[this.length];
        this.array[0] = new AffineTransform();
        this.fill(this.array[0]);
    }

    public AffineTransform get(int n) {
        if (n >= this.length) {
            this.setLength(n + 1);
        }
        return this.array[n];
    }

    public void setLength(int n) {
        if (n == this.length || n < 1) {
            return;
        }
        AffineTransform[] affineTransformArray = new AffineTransform[n];
        System.arraycopy(this.array, 0, affineTransformArray, 0, Math.min(n, this.length));
        this.array = affineTransformArray;
        if (n > this.length) {
            AffineTransform affineTransform = this.array[this.length - 1];
            this.length = n;
            this.fill(affineTransform);
        } else {
            this.length = n;
        }
    }

    private void fill(AffineTransform affineTransform) {
        int n = 0;
        while (n < this.length) {
            if (this.array[n] == null) {
                this.array[n] = new AffineTransform(affineTransform);
            }
            ++n;
        }
    }
}

