/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.swing.JFrame;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ByteLattice;

public class ByteRaster
extends MeasuredImage
implements Dimensioned,
ByteLattice {
    boolean allowRescale = false;
    WritableRaster raster;
    ColorModel colorModel;
    byte[] packedData;
    int ny;
    int nx;
    Dimension dimension;
    protected double scaleFactor = 1.0;
    Color gridColor = Color.lightGray;
    boolean showGrid = false;
    byte[] reds = new byte[256];
    byte[] greens = new byte[256];
    byte[] blues = new byte[256];
    private JFrame legendFrame;
    private boolean isUnderEjs = false;

    public ByteRaster(int n, int n2) {
        this.ny = n2;
        this.nx = n;
        this.dimension = new Dimension(this.nx - 1, this.ny - 1);
        int n3 = this.nx * this.ny;
        this.packedData = new byte[n3];
        DataBufferByte dataBufferByte = new DataBufferByte(this.packedData, n3);
        this.raster = Raster.createPackedRaster(dataBufferByte, this.nx, this.ny, 8, null);
        this.colorModel = this.createColorModel();
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
        this.xmin = 0.0;
        this.xmax = this.nx;
        this.ymin = 0.0;
        this.ymax = this.ny;
    }

    public void resizeLattice(int n, int n2) {
        this.resizeRaster(n, n2);
        this.xmin = 0.0;
        this.xmax = n;
        this.ymin = 0.0;
        this.ymax = n2;
    }

    public void setUnderEjs(boolean bl) {
        this.isUnderEjs = bl;
    }

    public void resizeRaster(int n, int n2) {
        this.ny = n2;
        this.nx = n;
        this.dimension = new Dimension(this.nx - 1, this.ny - 1);
        int n3 = this.nx * this.ny;
        this.packedData = new byte[n3];
        DataBufferByte dataBufferByte = new DataBufferByte(this.packedData, n3);
        this.raster = Raster.createPackedRaster(dataBufferByte, this.nx, this.ny, 8, null);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public int getNx() {
        return this.nx;
    }

    public int getNy() {
        return this.ny;
    }

    public void randomize() {
        Random random = new Random();
        random.nextBytes(this.packedData);
    }

    public Dimension getInterior(DrawingPanel drawingPanel) {
        if (this.allowRescale) {
            return null;
        }
        float f = drawingPanel.getWidth() - drawingPanel.getLeftGutter() - drawingPanel.getRightGutter() - 1;
        float f2 = drawingPanel.getHeight() - drawingPanel.getTopGutter() - drawingPanel.getBottomGutter() - 1;
        this.scaleFactor = Math.min(f / (float)this.dimension.width, f2 / (float)this.dimension.height);
        if (this.scaleFactor > 1.0) {
            this.scaleFactor = 1.0;
            return this.dimension;
        }
        return new Dimension((int)(this.scaleFactor * ((double)this.nx - 0.5)), (int)(this.scaleFactor * ((double)this.ny - 0.5)));
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.allowRescale) {
            super.draw(drawingPanel, graphics);
        } else if (this.scaleFactor < 1.0 && !this.isUnderEjs) {
            graphics.drawImage(this.image.getScaledInstance((int)(this.scaleFactor * (double)this.image.getWidth()), (int)(this.scaleFactor * (double)this.image.getHeight()), 8), drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel);
        } else {
            graphics.drawImage(this.image, drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel);
        }
        if (this.showGrid) {
            graphics.setColor(this.gridColor);
            graphics.drawRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), (int)this.dimension.getWidth(), (int)this.dimension.getHeight());
        }
    }

    public void setAllowRescale(boolean bl) {
        this.allowRescale = bl;
    }

    public boolean getAllowRescale() {
        return this.allowRescale;
    }

    public void setAll(byte[][] byArray) {
        if (this.getNx() != byArray.length || this.getNy() != byArray[0].length) {
            this.resizeLattice(byArray.length, byArray[0].length);
        }
        this.setBlock(0, 0, byArray);
    }

    public void setAll(byte[][] byArray, double d, double d2, double d3, double d4) {
        this.setAll(byArray);
        this.setMinMax(d, d2, d3, d4);
    }

    public void setBlock(byte[][] byArray) {
        this.setBlock(0, 0, byArray);
    }

    public void setBlock(int n, int n2, byte[][] byArray) {
        if (n2 < 0 || n2 + byArray[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in byte raster setBlock.");
        }
        if (n < 0 || n + byArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in byte raster setBlock.");
        }
        int n3 = n2;
        int n4 = byArray[0].length + n2;
        while (n3 < n4) {
            int n5 = n;
            int n6 = byArray.length + n;
            while (n5 < n6) {
                this.packedData[(this.ny - n3 - 1) * this.nx + n5] = byArray[n5 - n][n3 - n2];
                ++n5;
            }
            ++n3;
        }
    }

    public void setBlock(int n, int n2, int[][] nArray) {
        if (n2 < 0 || n2 + nArray[0].length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in byte raster setBlock.");
        }
        if (n < 0 || n + nArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in byte raster setBlock.");
        }
        int n3 = n2;
        int n4 = nArray[0].length + n2;
        while (n3 < n4) {
            int n5 = n;
            int n6 = nArray.length + n;
            while (n5 < n6) {
                this.packedData[(this.ny - n3 - 1) * this.nx + n5] = (byte)nArray[n5 - n][n3 - n2];
                ++n5;
            }
            ++n3;
        }
    }

    public void setCol(int n, int n2, byte[] byArray) {
        if (n2 < 0 || n2 + byArray.length > this.ny) {
            throw new IllegalArgumentException("Row index out of range in byte raster setCol.");
        }
        if (n < 0 || n >= this.nx) {
            throw new IllegalArgumentException("Column index out of range in byte raster setCol.");
        }
        int n3 = n2;
        int n4 = byArray.length + n2;
        while (n3 < n4) {
            this.packedData[(this.ny - n3 - 1) * this.nx + n] = byArray[n3 - n2];
            ++n3;
        }
    }

    public void setRow(int n, int n2, byte[] byArray) {
        if (n < 0 || n >= this.ny) {
            throw new IllegalArgumentException("Row index out of range in binary lattice setRow.");
        }
        if (n2 < 0 || n2 + byArray.length > this.nx) {
            throw new IllegalArgumentException("Column index out of range in binary lattice setRow.");
        }
        int n3 = n2;
        int n4 = byArray.length + n2;
        while (n3 < n4) {
            this.packedData[(this.ny - n - 1) * this.nx + n3] = byArray[n3 - n2];
            ++n3;
        }
    }

    public void setValue(int n, int n2, byte by) {
        this.packedData[(this.ny - n2 - 1) * this.nx + n] = by;
    }

    public byte getValue(int n, int n2) {
        return this.packedData[(this.ny - n2 - 1) * this.nx + n];
    }

    public void setBWPalette() {
        Color[] colorArray = new Color[256];
        int n = 0;
        while (n < 256) {
            colorArray[n] = new Color(n, n, n);
            ++n;
        }
        this.setColorPalette(colorArray);
    }

    public void setColorPalette(Color[] colorArray) {
        int n = colorArray.length;
        this.reds = new byte[n];
        this.greens = new byte[n];
        this.blues = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            this.reds[n2] = (byte)colorArray[n2].getRed();
            this.greens[n2] = (byte)colorArray[n2].getGreen();
            this.blues[n2] = (byte)colorArray[n2].getBlue();
            ++n2;
        }
        this.colorModel = new IndexColorModel(8, n, this.reds, this.greens, this.blues);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public byte[][] getColorPalette() {
        byte[][] byArrayArray = new byte[][]{this.reds, this.greens, this.blues};
        return byArrayArray;
    }

    public void createDefaultColors() {
        this.colorModel = this.createColorModel();
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public void setIndexedColor(int n, Color color) {
        n = (n + 256) % this.reds.length;
        this.reds[n] = (byte)color.getRed();
        this.greens[n] = (byte)color.getGreen();
        this.blues[n] = (byte)color.getBlue();
        this.colorModel = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public JFrame showLegend() {
        int n;
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 80));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        ByteRaster byteRaster = new ByteRaster(256, 20);
        byteRaster.setMinMax(-128.0, 127.0, 0.0, 1.0);
        byte[][] byArray = new byte[256][20];
        int n2 = 0;
        while (n2 < 256) {
            n = 0;
            while (n < 20) {
                byArray[n2][n] = (byte)(-128 + n2);
                ++n;
            }
            ++n2;
        }
        byteRaster.setBlock(0, 0, byArray);
        Color[] colorArray = new Color[256];
        n = 0;
        while (n < 256) {
            colorArray[(128 + n) % 256] = new Color((256 + this.reds[n]) % 256, (256 + this.greens[n]) % 256, (256 + this.blues[n]) % 256);
            ++n;
        }
        byteRaster.setColorPalette(colorArray);
        interactivePanel.addDrawable(byteRaster);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setShowGridLines(boolean bl) {
        this.showGrid = bl;
    }

    public void setGridLineColor(Color color) {
        this.gridColor = color;
    }

    ColorModel createColorModel() {
        this.reds = new byte[256];
        this.greens = new byte[256];
        this.blues = new byte[256];
        int n = 0;
        while (n < 256) {
            double d = n < 128 ? (double)(n - 100) / 255.0 : -1.0;
            double d2 = Math.exp(-d * d * 8.0);
            this.reds[n] = (byte)(255.0 * d2);
            d = n < 128 ? (double)n / 255.0 : (double)(255 - n) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            this.greens[n] = (byte)(255.0 * d2);
            d = n < 128 ? -1.0 : (double)(n - 156) / 255.0;
            d2 = Math.exp(-d * d * 8.0);
            this.blues[n] = (byte)(255.0 * d2);
            ++n;
        }
        IndexColorModel indexColorModel = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
        return indexColorModel;
    }

    public int indexFromPoint(double d, double d2) {
        int n = this.getNx();
        int n2 = this.getNy();
        double d3 = this.getXMin();
        double d4 = this.getXMax();
        double d5 = this.getYMin();
        double d6 = this.getYMax();
        double d7 = (d - d3) / (d4 - d3);
        double d8 = (d2 - d5) / (d6 - d5);
        int n3 = (int)(d7 * (double)n);
        int n4 = (int)(d8 * (double)n2);
        if (n3 < 0 || n4 < 0 || n3 >= n || n4 >= n2) {
            return -1;
        }
        return n4 * n + n3;
    }

    public int xToIndex(double d) {
        double d2;
        int n = this.getNx();
        double d3 = this.getXMin();
        double d4 = (d - d3) / ((d2 = this.getXMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public double indexToX(int n) {
        double d = this.getXMin();
        double d2 = this.getXMax();
        return d + (double)n * (d2 - d) / (double)this.getNx();
    }

    public int yToIndex(double d) {
        double d2;
        int n = this.getNy();
        double d3 = this.getYMin();
        double d4 = (d - d3) / ((d2 = this.getYMax()) - d3);
        int n2 = (int)(d4 * (double)n);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public double indexToY(int n) {
        double d = this.getYMin();
        double d2 = this.getYMax();
        return d + (double)n * (d2 - d) / (double)this.getNy();
    }
}

