/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementPolygon;

public class ControlAnalyticCurve2D
extends ControlElement2D
implements NeedsPreUpdate {
    private static final int ANALCURVE_PROPERTIES_ADDED = 9;
    protected String variable;
    protected int numPoints;
    protected double min = Double.NaN;
    protected double max = Double.NaN;
    protected String functionX;
    protected String functionY;
    protected boolean useJavaSyntax = true;
    protected ElementPolygon polygon;
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected String[] varsX;
    protected String[] varsY;
    protected int indexX;
    protected int indexY;
    private double minAbcise = Double.NaN;
    private double maxAbcise = Double.NaN;
    private static List<String> infoList = null;

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing2d.ElementPolygon";
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 9;
    }

    @Override
    protected Drawable createDrawable() {
        this.polygon = new ElementPolygon();
        this.polygon.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ControlAnalyticCurve2D.this.checkExtremes();
            }
        });
        this.polygon.setClosed(false);
        this.polygon.setCanBeMeasured(false);
        this.variable = "t";
        this.functionX = null;
        this.varsX = new String[0];
        this.indexX = -1;
        this.functionY = null;
        this.varsY = new String[0];
        this.indexY = -1;
        this.changedYfunction = true;
        this.changedXfunction = true;
        return this.polygon;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("javaSyntax");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String";
        }
        if (string.equals("min")) {
            return "int|double";
        }
        if (string.equals("max")) {
            return "int|double";
        }
        if (string.equals("points")) {
            return "int";
        }
        if (string.equals("functionx")) {
            return "String";
        }
        if (string.equals("functiony")) {
            return "String";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.variable != null && this.variable.equals(value.getString())) break;
                this.variable = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 2: {
                this.max = value.getDouble();
                this.polygon.setCanBeMeasured(!Double.isNaN(this.min) && !Double.isNaN(this.max));
                break;
            }
            case 3: {
                this.numPoints = value.getInteger();
                break;
            }
            case 4: {
                if (this.functionX != null && this.functionX.equals(value.getString())) break;
                this.functionX = value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (this.functionY != null && this.functionY.equals(value.getString())) break;
                this.functionY = value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = value.getBoolean();
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 7: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, value.getString());
                return;
            }
            case 8: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, value.getString());
                return;
            }
            default: {
                super.setValue(n - 9, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 2: {
                this.max = Double.NaN;
                this.polygon.setCanBeMeasured(false);
                break;
            }
            case 3: {
                this.numPoints = 0;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.useJavaSyntax = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 7: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                return;
            }
            case 8: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                return;
            }
            default: {
                super.setDefaultValue(n - 9);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "t";
            }
            case 1: 
            case 2: {
                return "Double.NaN";
            }
            case 3: {
                return "0";
            }
            case 4: 
            case 5: {
                return "<none>";
            }
            case 6: {
                return "true";
            }
            case 7: 
            case 8: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(n - 9);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return null;
            }
        }
        return super.getValue(n - 9);
    }

    private boolean isVariableDefined(String string) {
        if (this.variable.equals(string)) {
            return true;
        }
        Value value = this.myGroup.getValue(string);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    private void checkExtremes() {
        if (Double.isNaN(this.min) || Double.isNaN(this.max)) {
            if (this.myParent == null) {
                return;
            }
            DrawingPanel drawingPanel = this.myParent.getDrawingPanel();
            if (Double.isNaN(this.min) && drawingPanel.getXMin() != this.minAbcise) {
                this.preupdate();
            } else if (Double.isNaN(this.max) && drawingPanel.getXMax() != this.maxAbcise) {
                this.preupdate();
            }
        }
    }

    @Override
    public void preupdate() {
        int n;
        int n2;
        int n3;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.changedXfunction && this.functionX != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = ((ParserAndVariables)object).getVariables();
            this.parserX = ((ParserAndVariables)object).getParser();
            n3 = 0;
            n2 = this.varsX.length;
            while (n3 < n2) {
                if (!this.isVariableDefined(this.varsX[n3])) {
                    bl2 = true;
                    break;
                }
                this.parserX.defineVariable(n3, this.varsX[n3]);
                ++n3;
            }
            if (!bl2) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            object = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = ((ParserAndVariables)object).getVariables();
            this.parserY = ((ParserAndVariables)object).getParser();
            n3 = 0;
            n2 = this.varsY.length;
            while (n3 < n2) {
                if (!this.isVariableDefined(this.varsY[n3])) {
                    bl3 = true;
                    break;
                }
                this.parserY.defineVariable(n3, this.varsY[n3]);
                ++n3;
            }
            if (!bl3) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    bl3 = true;
                } else {
                    bl = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (bl2 || bl3) {
            this.invokeActions(1001);
        } else if (bl) {
            this.invokeActions(1002);
        }
        if (this.isUnderEjs) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", bl2);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", bl3);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve2D.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve2D.indexOf(this.variable, this.varsY);
            this.updateIndexes = false;
        }
        object = this.myParent.getDrawingPanel();
        n3 = this.numPoints;
        if (n3 <= 0) {
            n3 = object != null ? Math.max(100, ((DrawingPanel)object).getWidth() / 2) : 100;
        }
        if (this.polygon.getDataArray().length != n3) {
            this.polygon.setData(new double[n3][2]);
        }
        double[][] dArray = this.polygon.getDataArray();
        this.minAbcise = this.min;
        this.maxAbcise = this.max;
        if (Double.isNaN(this.minAbcise)) {
            this.minAbcise = ((DrawingPanel)object).getXMin();
        }
        if (Double.isNaN(this.maxAbcise)) {
            this.maxAbcise = ((DrawingPanel)object).getXMax();
        }
        if (this.isUnderEjs) {
            try {
                int n4 = 0;
                n = this.varsX.length;
                while (n4 < n) {
                    if (n4 != this.indexX) {
                        this.parserX.setVariable(n4, this.myGroup.getDouble(this.varsX[n4]));
                    }
                    ++n4;
                }
                n4 = 0;
                n = this.varsY.length;
                while (n4 < n) {
                    if (n4 != this.indexY) {
                        this.parserY.setVariable(n4, this.myGroup.getDouble(this.varsY[n4]));
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                System.err.println("ControlAnalyticCurve2D: Null String?\n");
                exception.printStackTrace();
            }
        } else {
            int n5 = 0;
            n = this.varsX.length;
            while (n5 < n) {
                if (n5 != this.indexX) {
                    this.parserX.setVariable(n5, this.myGroup.getDouble(this.varsX[n5]));
                }
                ++n5;
            }
            n5 = 0;
            n = this.varsY.length;
            while (n5 < n) {
                if (n5 != this.indexY) {
                    this.parserY.setVariable(n5, this.myGroup.getDouble(this.varsY[n5]));
                }
                ++n5;
            }
        }
        int n6 = 0;
        n = n3 - 1;
        while (n6 <= n) {
            double d = ((double)(n - n6) * this.minAbcise + (double)n6 * this.maxAbcise) / (double)n;
            if (this.functionX == null || bl2) {
                dArray[n6][0] = 0.0;
            } else {
                if (this.indexX >= 0) {
                    this.parserX.setVariable(this.indexX, d);
                }
                dArray[n6][0] = this.parserX.evaluate();
            }
            if (this.functionY == null || bl3) {
                dArray[n6][1] = 0.0;
            } else {
                if (this.indexY >= 0) {
                    this.parserY.setVariable(this.indexY, d);
                }
                dArray[n6][1] = this.parserY.evaluate();
            }
            ++n6;
        }
        this.polygon.setElementChanged();
    }
}

