/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementPolygon;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.tools.ToolForData;

public class ControlPolygonSet2D
extends ControlSet2D
implements NeedsPreUpdate {
    private static final int POLSET2D_ROPERTIES_ADDED = 5;
    private static final int INDEX_SELECTED = 2;
    protected IntegerValue pointValue = new IntegerValue(-1);
    private double[][] xArray = null;
    private double[][] yArray = null;
    private double[][] xFixedArray = new double[][]{{0.0}};
    private double[][] yFixedArray = new double[][]{{0.0}};
    private boolean dataSet = false;
    static ArrayList<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 5;
    }

    @Override
    protected int setNumberOfElements(int n) {
        int n2 = super.setNumberOfElements(n);
        this.xFixedArray = new double[n2][1];
        this.yFixedArray = new double[n2][1];
        return n2;
    }

    @Override
    protected Element createAnElement() {
        ElementPolygon elementPolygon = new ElementPolygon();
        elementPolygon.setData(new double[][]{{0.0, 0.0}, {0.1, 0.0}, {0.1, 0.1}});
        return elementPolygon;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementPolygon)element2).setClosed(((ElementPolygon)element).isClosed());
        ((ElementPolygon)element2).setData(((ElementPolygon)element).getData());
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlPolygonSet2D.getDataInformationMenuEntries(this.getParent().getDrawingPanel(), this.getSet()));
    }

    @Override
    public void preupdate() {
        if (this.dataSet) {
            return;
        }
        if (this.xArray == null) {
            if (this.yArray == null) {
                int n = 0;
                while (n < this.elements.length) {
                    ((ElementPolygon)this.elements[n]).setData(this.xFixedArray[n], this.yFixedArray[n]);
                    ++n;
                }
            } else {
                int n = 0;
                int n2 = Math.min(this.elements.length, this.yArray.length);
                while (n < n2) {
                    ((ElementPolygon)this.elements[n]).setData(this.xFixedArray[n], this.yArray[n]);
                    ++n;
                }
            }
        } else if (this.yArray == null) {
            int n = 0;
            int n3 = Math.min(this.elements.length, this.xArray.length);
            while (n < n3) {
                ((ElementPolygon)this.elements[n]).setData(this.xArray[n], this.yFixedArray[n]);
                ++n;
            }
        } else {
            int n = 0;
            int n4 = Math.min(this.elements.length, Math.min(this.xArray.length, this.yArray.length));
            while (n < n4) {
                ((ElementPolygon)this.elements[n]).setData(this.xArray[n], this.yArray[n]);
                ++n;
            }
        }
    }

    public ArrayList<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("closed");
            infoList.add("data");
            infoList.add("indexSelected");
            infoList.add("xData");
            infoList.add("yData");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("closed")) {
            return "boolean|boolean[]";
        }
        if (string.equals("data")) {
            return "double[][]|Object|double[][][]";
        }
        if (string.equals("indexSelected")) {
            return "int";
        }
        if (string.equals("xData")) {
            return "int|double|double[]|double[][]|Object";
        }
        if (string.equals("yData")) {
            return "int|double|double[]|double[][]|Object";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.elements.length, blArray.length);
                    while (n2 < n3) {
                        ((ElementPolygon)this.elements[n2]).setClosed(blArray[n2]);
                        ++n2;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n4 = 0;
                    while (n4 < this.elements.length) {
                        ((ElementPolygon)this.elements[n4]).setClosed(bl);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof double[][][]) {
                    double[][][] dArray = (double[][][])value.getObject();
                    this.checkNumberOfElements(dArray.length, true);
                    int n5 = 0;
                    int n6 = Math.min(this.elements.length, dArray.length);
                    while (n5 < n6) {
                        ((ElementPolygon)this.elements[n5]).setData(dArray[n5]);
                        ++n5;
                    }
                } else {
                    double[][] dArray = (double[][])value.getObject();
                    int n7 = 0;
                    while (n7 < this.elements.length) {
                        ((ElementPolygon)this.elements[n7]).setData(dArray);
                        ++n7;
                    }
                }
                this.dataSet = true;
                break;
            }
            case 2: {
                this.pointValue.value = value.getInteger();
                break;
            }
            case 3: {
                if (value.getObject() instanceof double[][]) {
                    this.xArray = (double[][])value.getObject();
                    break;
                }
                if (value.getObject() instanceof double[]) {
                    this.xArray = null;
                    double[] dArray = (double[])value.getObject();
                    int n8 = Math.min(this.xFixedArray.length, dArray.length);
                    int n9 = 0;
                    while (n9 < n8) {
                        this.xFixedArray[n9][0] = dArray[n9];
                        ++n9;
                    }
                    n9 = n8;
                    while (n9 < this.xFixedArray.length) {
                        this.xFixedArray[n9][0] = 0.0;
                        ++n9;
                    }
                } else {
                    this.xArray = null;
                    double d = value.getDouble();
                    int n10 = 0;
                    while (n10 < this.xFixedArray.length) {
                        this.xFixedArray[n10][0] = d;
                        ++n10;
                    }
                }
                break;
            }
            case 4: {
                if (value.getObject() instanceof double[][]) {
                    this.yArray = (double[][])value.getObject();
                    break;
                }
                if (value.getObject() instanceof double[]) {
                    this.yArray = null;
                    double[] dArray = (double[])value.getObject();
                    int n11 = Math.min(this.yFixedArray.length, dArray.length);
                    int n12 = 0;
                    while (n12 < n11) {
                        this.yFixedArray[n12][0] = dArray[n12];
                        ++n12;
                    }
                    n12 = n11;
                    while (n12 < this.yFixedArray.length) {
                        this.yFixedArray[n12][0] = 0.0;
                        ++n12;
                    }
                } else {
                    this.yArray = null;
                    double d = value.getDouble();
                    int n13 = 0;
                    while (n13 < this.yFixedArray.length) {
                        this.yFixedArray[n13][0] = d;
                        ++n13;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.elements.length) {
                    ((ElementPolygon)this.elements[n2]).setClosed(true);
                    ++n2;
                }
                break;
            }
            case 1: {
                double[][] dArrayArray = new double[][]{{0.0, 0.0}, {0.1, 0.0}, {0.1, 0.1}};
                int n3 = 0;
                while (n3 < this.elements.length) {
                    ((ElementPolygon)this.elements[n3]).setData(dArrayArray);
                    ++n3;
                }
                this.dataSet = false;
                break;
            }
            case 2: {
                this.pointValue.value = -1;
                break;
            }
            case 3: {
                this.xArray = null;
                int n4 = 0;
                while (n4 < this.xFixedArray.length) {
                    this.xFixedArray[n4][0] = 0.0;
                    ++n4;
                }
                break;
            }
            case 4: {
                this.yArray = null;
                int n5 = 0;
                while (n5 < this.yFixedArray.length) {
                    this.yFixedArray[n5][0] = 0.0;
                    ++n5;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "true";
            }
            case 1: {
                return "new double[][]{ {0.0,0.0}, {0.1,0.0}, {0.1,0.1} }";
            }
            case 2: {
                return "-1";
            }
            case 3: 
            case 4: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 5);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                double[][][] dArrayArray = new double[this.elements.length][][];
                int n2 = 0;
                while (n2 < this.elements.length) {
                    dArrayArray[n2] = ((ElementPolygon)this.elements[n2]).getData();
                    ++n2;
                }
                return new ObjectValue(dArrayArray);
            }
            case 2: {
                return this.pointValue;
            }
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }

    @Override
    protected void propagateSize(ControlElement2D controlElement2D, int n) {
        if (controlElement2D != this) {
            super.propagateSize(controlElement2D);
            return;
        }
        double[][][] dArrayArray = new double[this.elements.length][][];
        int n2 = 0;
        while (n2 < this.elements.length) {
            dArrayArray[n2] = ((ElementPolygon)this.elements[n2]).getData();
            ++n2;
        }
        ObjectValue objectValue = new ObjectValue(dArrayArray);
        this.variableChanged(1, objectValue);
        if (this.isUnderEjs) {
            this.setFieldListValue(1, objectValue);
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.selectedValue.value = this.getSet().getInteractedIndex();
                this.pointValue.value = (Integer)((InteractionTarget)interactionEvent.getInfo()).getDataObject();
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.variableChanged(2, this.pointValue);
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.variableChanged(2, this.pointValue);
                break;
            }
            case 2000: {
                this.selectedValue.value = this.getSet().getInteractedIndex();
                this.pointValue.value = (Integer)((InteractionTarget)interactionEvent.getInfo()).getDataObject();
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.variableChanged(2, this.pointValue);
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedValue.value);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.variableChanged(2, this.pointValue);
            }
        }
    }
}

