/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.colos.ejs.library.control.ConstantParser;

public class JSliderDouble
extends JSlider {
    public static final int RESOLUTION = 100000;
    private boolean interactiveChange = true;
    private boolean outOfLimits = false;
    private int ticks = 0;
    private double scale;
    private double minimum;
    private double maximum = Double.NaN;
    private TitledBorder titledBorder;
    private EtchedBorder etchedBorder;
    private DecimalFormat format = null;
    private DecimalFormat ticksFormat = null;
    private Color currentColor = null;
    private double doubleValue;
    ChangeListener listener;

    public JSliderDouble(ChangeListener changeListener) {
        this.listener = changeListener;
        this.setPaintLabels(false);
        this.setPaintTicks(false);
        this.setPaintTrack(true);
        this.setMinimum(0);
        this.setMaximum(100000);
        this.setValue(0);
        this.doubleValue = 0.0;
        this.setForeground(Color.BLACK);
        this.etchedBorder = new EtchedBorder(1);
        this.titledBorder = new TitledBorder(this.etchedBorder, "");
        this.titledBorder.setTitleJustification(2);
        this.setBorder(this.etchedBorder);
        this.minimum = 0.0;
        this.setDoubleMaximum(1.0);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!JSliderDouble.this.outOfLimits) {
                    JSliderDouble.this.doubleValue = JSliderDouble.this.minimum + (double)JSliderDouble.this.getValue() / JSliderDouble.this.scale;
                }
                if (JSliderDouble.this.format != null) {
                    JSliderDouble.this.titledBorder.setTitle(JSliderDouble.this.format.format(JSliderDouble.this.doubleValue));
                    JSliderDouble.this.repaint();
                }
                JSliderDouble.this.listener.stateChanged(changeEvent);
            }
        });
    }

    public boolean isInteractiveChange() {
        return this.interactiveChange;
    }

    public void setDoubleValue(double d) {
        this.doubleValue = d;
        int n = (int)((d - this.minimum) * this.scale);
        if (n < 0 || n > 100000) {
            this.outOfLimits = true;
            this.setValue(n);
            this.outOfLimits = false;
        } else {
            this.setValue(n);
        }
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public double getDoubleMinimum() {
        return this.minimum;
    }

    public void setDoubleMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        this.minimum = d;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.recomputeTicks();
        this.interactiveChange = false;
        this.setDoubleValue(this.doubleValue);
        this.interactiveChange = true;
    }

    public double getDoubleMaximum() {
        return this.maximum;
    }

    public void setDoubleMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        this.maximum = d;
        this.scale = 100000.0 / (this.maximum - this.minimum);
        this.recomputeTicks();
        this.interactiveChange = false;
        this.setDoubleValue(this.doubleValue);
        this.interactiveChange = true;
    }

    public void setTicksFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            this.ticksFormat = null;
            this.setPaintLabels(false);
        } else {
            if (decimalFormat.equals(this.ticksFormat)) {
                return;
            }
            this.ticksFormat = decimalFormat;
            this.setPaintLabels(true);
        }
        this.recomputeTicks();
    }

    public void setNumberOfTicks(int n) {
        if (n == this.ticks) {
            return;
        }
        this.ticks = n;
        this.recomputeTicks();
    }

    public void setTitleFormat(DecimalFormat decimalFormat) {
        if (decimalFormat == null) {
            this.format = null;
            this.setBorder(this.etchedBorder);
            return;
        }
        if (decimalFormat.equals(this.format)) {
            return;
        }
        this.format = decimalFormat;
        this.titledBorder.setTitle(this.format.format(this.getDoubleValue()));
        this.setBorder(this.titledBorder);
        this.repaint();
    }

    public void setTitleFormat(String string) {
        this.setTitleFormat((DecimalFormat)ConstantParser.formatConstant(string).getObject());
    }

    public void setTitleFont(Font font) {
        this.titledBorder.setTitleFont(font);
    }

    public void setTitleForeground(Color color) {
        this.titledBorder.setTitleColor(color);
        Dictionary dictionary = this.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.elements();
            while (enumeration.hasMoreElements()) {
                Object v = enumeration.nextElement();
                if (!(v instanceof JLabel)) continue;
                ((JLabel)v).setForeground(color);
            }
        }
        this.currentColor = color;
    }

    private void recomputeTicks() {
        if (this.ticks < 2) {
            this.setPaintTicks(false);
            return;
        }
        int n = 100000 / (this.ticks - 1);
        this.setMinorTickSpacing(n);
        this.setMajorTickSpacing(2 * n);
        this.setPaintTicks(true);
        if (this.ticksFormat != null) {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            int n2 = 0;
            while (n2 <= 100000) {
                hashtable.put(new Integer(n2), new JLabel(this.ticksFormat.format(this.minimum + (double)n2 / this.scale)));
                n2 += 2 * n;
            }
            this.setLabelTable(hashtable);
        }
        if (this.currentColor != null) {
            this.setTitleForeground(this.currentColor);
        }
    }
}

