/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;

public class Password
extends JDialog {
    private JLabel messageLabel;
    private JPasswordField passwordField;
    private String password;
    private boolean pass;

    public static boolean verify(String string, String string2) {
        if (string == null || string.equals("")) {
            return true;
        }
        Password password = new Password();
        password.password = string;
        if (string2 == null || string2.equals("")) {
            password.messageLabel.setText(ControlsRes.getString("Password.Message.Short"));
        } else {
            password.messageLabel.setText(String.valueOf(ControlsRes.getString("Password.Message.File")) + " \"" + XML.getName(string2) + "\".");
        }
        password.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - password.getBounds().width) / 2;
        int n2 = (dimension.height - password.getBounds().height) / 2;
        password.setLocation(n, n2);
        password.pass = false;
        password.passwordField.setText("");
        password.setVisible(true);
        password.dispose();
        return password.pass;
    }

    private Password() {
        super((Frame)null, true);
        this.setTitle(ControlsRes.getString("Password.Title"));
        this.createGUI();
        this.setResizable(false);
        this.passwordField.requestFocusInWindow();
    }

    private void createGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.messageLabel = new JLabel();
        JLabel jLabel = new JLabel(ControlsRes.getString("Password.Label"));
        this.passwordField = new JPasswordField(20);
        this.passwordField.setToolTipText(ControlsRes.getString("Password.Tooltip"));
        this.passwordField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = String.copyValueOf(Password.this.passwordField.getPassword());
                if (Password.this.password != null && !string.equals(Password.this.password)) {
                    Toolkit.getDefaultToolkit().beep();
                    Password.this.passwordField.setText("");
                } else {
                    Password.this.pass = true;
                    Password.this.setVisible(false);
                }
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    Password.this.passwordField.requestFocusInWindow();
                    Password.this.setVisible(false);
                }
            }
        });
        JButton jButton = new JButton(ControlsRes.getString("Password.Button.Cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Password.this.passwordField.requestFocusInWindow();
                Password.this.setVisible(false);
            }
        });
        JButton jButton2 = new JButton(ControlsRes.getString("Password.Button.Enter"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = String.copyValueOf(Password.this.passwordField.getPassword());
                if (Password.this.password != null && !string.equals(Password.this.password)) {
                    Toolkit.getDefaultToolkit().beep();
                    Password.this.passwordField.setText("");
                    Password.this.passwordField.requestFocusInWindow();
                } else {
                    Password.this.pass = true;
                    Password.this.setVisible(false);
                }
            }
        });
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(20, 15, 10, 15);
        gridBagLayout.setConstraints(this.messageLabel, gridBagConstraints);
        jPanel.add(this.messageLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.add(this.passwordField);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        container.add((Component)jPanel3, "South");
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 4, 4));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(jButton2);
        jPanel3.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel3.add(jButton);
    }
}

