/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.Selectable;

public class InteractivePanel
extends DrawingPanel
implements InteractiveMouseHandler {
    public static final int MOUSE_PRESSED = 1;
    public static final int MOUSE_RELEASED = 2;
    public static final int MOUSE_DRAGGED = 3;
    public static final int MOUSE_CLICKED = 4;
    public static final int MOUSE_ENTERED = 5;
    public static final int MOUSE_EXITED = 6;
    public static final int MOUSE_MOVED = 7;
    protected boolean containsInteractive = false;
    protected int mouseAction = 0;
    protected MouseEvent mouseEvent = null;
    protected InteractiveMouseHandler interactive = null;
    private Interactive iaDraggable = null;
    private Selectable iaSelectable = null;

    public InteractivePanel(InteractiveMouseHandler interactiveMouseHandler) {
        this();
        this.interactive = interactiveMouseHandler;
    }

    public InteractivePanel() {
        this.removeMouseListener(this.mouseController);
        this.removeMouseMotionListener(this.mouseController);
        this.mouseController = new IADMouseController();
        this.addMouseListener(this.mouseController);
        this.addMouseMotionListener(this.mouseController);
        this.interactive = this;
    }

    @Override
    public void addDrawable(Drawable drawable) {
        super.addDrawable(drawable);
        if (drawable instanceof Interactive) {
            this.containsInteractive = true;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.containsInteractive = false;
    }

    @Override
    protected void scaleX(ArrayList<Drawable> arrayList) {
        double d = this.xminPreferred;
        double d2 = this.xmaxPreferred;
        super.scaleX(arrayList);
        if (this.autoscaleX && this.mouseAction == 3) {
            if (this.xminPreferred > d) {
                this.xminPreferred = d;
            }
            if (this.xmaxPreferred < d2) {
                this.xmaxPreferred = d2;
            }
        }
    }

    @Override
    protected void scaleY(ArrayList<Drawable> arrayList) {
        double d = this.yminPreferred;
        double d2 = this.ymaxPreferred;
        super.scaleY(arrayList);
        if (this.autoscaleY && this.mouseAction == 3) {
            if (this.yminPreferred > d) {
                this.yminPreferred = d;
            }
            if (this.ymaxPreferred < d2) {
                this.ymaxPreferred = d2;
            }
        }
    }

    public void setInteractiveMouseHandler(InteractiveMouseHandler interactiveMouseHandler) {
        this.interactive = interactiveMouseHandler;
    }

    @Override
    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        switch (interactivePanel.getMouseAction()) {
            case 4: {
                Interactive interactive = this.getInteractive();
                if (interactivePanel.getMouseClickCount() < 2 || interactive == null || !(interactive instanceof Selectable)) {
                    return;
                }
                if (this.iaSelectable != null && this.iaSelectable != interactive) {
                    this.iaSelectable.setSelected(false);
                }
                this.iaSelectable = (Selectable)interactive;
                this.iaSelectable.toggleSelected();
                this.invalidateImage();
                if (this.getIgnoreRepaint()) break;
                interactivePanel.repaint();
                break;
            }
            case 3: {
                if (this.iaDraggable == null) {
                    return;
                }
                double d = interactivePanel.getMouseX();
                double d2 = interactivePanel.getMouseY();
                if (!this.autoscaleX && mouseEvent.getX() < 1 + this.leftGutter) {
                    d = interactivePanel.pixToX(1 + this.leftGutter);
                }
                if (!this.autoscaleX && mouseEvent.getX() > interactivePanel.getWidth() - 1 - this.rightGutter) {
                    d = interactivePanel.pixToX(interactivePanel.getWidth() - 1 - this.rightGutter);
                }
                if (!this.autoscaleY && mouseEvent.getY() < 1 + this.topGutter) {
                    d2 = interactivePanel.pixToY(1 + this.topGutter);
                }
                if (!this.autoscaleY && mouseEvent.getY() > interactivePanel.getHeight() - 1 - this.bottomGutter) {
                    d2 = interactivePanel.pixToY(interactivePanel.getHeight() - 1 - this.bottomGutter);
                }
                this.iaDraggable.setXY(d, d2);
                this.invalidateImage();
                if (this.getIgnoreRepaint()) break;
                interactivePanel.repaint();
                break;
            }
            case 2: {
                if (!this.autoscaleX && !this.autoscaleY || this.getIgnoreRepaint()) break;
                interactivePanel.repaint();
            }
        }
    }

    public Interactive getCurrentDraggable() {
        return this.iaDraggable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interactive getInteractive() {
        if (!this.containsInteractive) {
            return null;
        }
        if (this.iaDraggable != null) {
            return this.iaDraggable;
        }
        if (this.iaSelectable != null && this.iaSelectable.isSelected()) {
            Interactive interactive = this.iaSelectable.findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY());
            return interactive;
        }
        Object[] objectArray = null;
        ArrayList arrayList = this.drawableList;
        synchronized (arrayList) {
            objectArray = this.drawableList.toArray();
        }
        int n = objectArray.length - 1;
        while (n >= 0) {
            Interactive interactive;
            Object object = objectArray[n];
            if (object instanceof Interactive && (interactive = ((Interactive)object).findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY())) != null) {
                return interactive;
            }
            --n;
        }
        return null;
    }

    @Override
    public void setShowCoordinates(boolean bl) {
        this.showCoordinates = bl;
    }

    public int getMouseButton() {
        switch (this.mouseEvent.getModifiers()) {
            case 16: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public int getMouseClickCount() {
        return this.mouseEvent.getClickCount();
    }

    public int getMouseAction() {
        return this.mouseAction;
    }

    public int getMouseIntX() {
        return this.mouseEvent.getX();
    }

    public int getMouseIntY() {
        return this.mouseEvent.getY();
    }

    public double getMouseX() {
        return this.pixToX(this.mouseEvent.getX());
    }

    public double getMouseY() {
        return this.pixToY(this.mouseEvent.getY());
    }

    public void saveMouseEvent(int n, MouseEvent mouseEvent) {
        this.mouseAction = n;
        this.mouseEvent = mouseEvent;
    }

    protected class IADMouseController
    extends MouseInputAdapter {
        protected IADMouseController() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 1;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
                InteractivePanel.this.iaDraggable = null;
                InteractivePanel.this.iaDraggable = InteractivePanel.this.getInteractive();
                if (InteractivePanel.this.iaDraggable != null) {
                    if (InteractivePanel.this.iaDraggable instanceof Selectable) {
                        InteractivePanel.this.setMouseCursor(((Selectable)InteractivePanel.this.iaDraggable).getPreferredCursor());
                    } else {
                        InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
                    }
                }
            }
            if (InteractivePanel.this.showCoordinates) {
                String string = InteractivePanel.this.coordinateStrBuilder.getCoordinateString(InteractivePanel.this, mouseEvent);
                InteractivePanel.this.blMessageBox.setText(string);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 2;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
            }
            InteractivePanel.this.iaDraggable = null;
            if (InteractivePanel.this.showCoordinates) {
                InteractivePanel.this.blMessageBox.setText(null);
            }
            InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (InteractivePanel.this.showCoordinates) {
                InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 5;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(0));
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 6;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 4;
            if (InteractivePanel.this.interactive == null) {
                return;
            }
            InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 3;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
            }
            if (InteractivePanel.this.showCoordinates) {
                String string = InteractivePanel.this.coordinateStrBuilder.getCoordinateString(InteractivePanel.this, mouseEvent);
                InteractivePanel.this.blMessageBox.setText(string);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            InteractivePanel.this.mouseEvent = mouseEvent;
            InteractivePanel.this.mouseAction = 7;
            InteractivePanel.this.iaDraggable = null;
            if (InteractivePanel.this.interactive != null) {
                InteractivePanel.this.interactive.handleMouseAction(InteractivePanel.this, mouseEvent);
                Interactive interactive = InteractivePanel.this.getInteractive();
                if (interactive == null) {
                    InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(1));
                } else if (interactive instanceof Selectable) {
                    InteractivePanel.this.setMouseCursor(((Selectable)interactive).getPreferredCursor());
                } else {
                    InteractivePanel.this.setMouseCursor(Cursor.getPredefinedCursor(12));
                }
            }
        }
    }
}

