/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.axes.AbstractPolarAxis;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.display.axes.PolarAxes;

public class PolarType2
extends AbstractPolarAxis
implements PolarAxes {
    public PolarType2(PlottingPanel plottingPanel, String string, String string2, double d) {
        super(plottingPanel);
        this.defaultLeftGutter = 25;
        this.defaultTopGutter = 25;
        this.defaultRightGutter = 25;
        this.defaultBottomGutter = 25;
        this.titleLine.setJustification(0);
        this.titleLine.setFont(this.titleFont);
        if (plottingPanel == null) {
            return;
        }
        plottingPanel.setPreferredGutters(this.defaultLeftGutter, this.defaultTopGutter, this.defaultRightGutter, this.defaultBottomGutter);
        plottingPanel.setAxes(this);
        plottingPanel.setCoordinateStringBuilder(CoordinateStringBuilder.createPolar(string, string2, d));
    }

    public PolarType2(PlottingPanel plottingPanel) {
        this(plottingPanel, "r=", " phi=", 0.0);
    }

    @Override
    public void setXLabel(String string, String string2) {
    }

    @Override
    public void setYLabel(String string, String string2) {
    }

    @Override
    public String getXLabel() {
        return "";
    }

    @Override
    public String getYLabel() {
        return "";
    }

    public void setXLog(boolean bl) {
    }

    public void setYLog(boolean bl) {
    }

    @Override
    public void setShowMajorXGrid(boolean bl) {
    }

    @Override
    public void setShowMinorXGrid(boolean bl) {
    }

    @Override
    public void setShowMajorYGrid(boolean bl) {
    }

    @Override
    public void setShowMinorYGrid(boolean bl) {
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        int n = drawingPanel.getLeftGutter() + drawingPanel.getRightGutter();
        int n2 = drawingPanel.getTopGutter() + drawingPanel.getLeftGutter();
        if (this.interiorColor != null) {
            graphics.setColor(this.interiorColor);
            graphics.fillRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n, drawingPanel.getHeight() - n2);
            graphics.setColor(this.gridcolor);
            graphics.drawRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n, drawingPanel.getHeight() - n2);
        }
        graphics2D.clipRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), drawingPanel.getWidth() - n, drawingPanel.getHeight() - n2);
        double d = Math.abs(drawingPanel.getXMax()) + Math.abs(drawingPanel.getYMax());
        d = Math.max(d, Math.abs(drawingPanel.getXMax()) + Math.abs(drawingPanel.getYMin()));
        d = Math.max(d, Math.abs(drawingPanel.getXMin()) + Math.abs(drawingPanel.getYMax()));
        d = Math.max(d, Math.abs(drawingPanel.getXMin()) + Math.abs(drawingPanel.getYMin()));
        double d2 = this.drawRings(d, drawingPanel, graphics);
        this.drawSpokes(d, drawingPanel, graphics);
        graphics2D.setClip(shape);
        this.drawRAxis(d2, d, drawingPanel, graphics);
        this.titleLine.setX((drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0);
        if (drawingPanel.getTopGutter() > 20) {
            this.titleLine.setY(drawingPanel.getYMax() + 5.0 / drawingPanel.getYPixPerUnit());
        } else {
            this.titleLine.setY(drawingPanel.getYMax() - 25.0 / drawingPanel.getYPixPerUnit());
        }
        this.titleLine.setColor(drawingPanel.getForeground());
        this.titleLine.draw(drawingPanel, graphics);
    }
}

