/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.Group;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.displayejs.Resolution;
import org.opensourcephysics.displayejs.Style;

public abstract class AbstractInteractiveElement
implements InteractiveElement {
    public static int SENSIBILITY = 5;
    protected boolean canBeMeasured = true;
    protected boolean visible = true;
    protected boolean positionEnabled = false;
    protected boolean sizeEnabled = false;
    protected boolean positionGroupEnabled = true;
    protected boolean sizeGroupEnabled = false;
    protected int actualSensitivity = SENSIBILITY;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double z = 0.0;
    protected double sizex = 0.1;
    protected double sizey = 0.1;
    protected double sizez = 0.1;
    protected final Style style = new Style(this);
    protected Resolution resolution = null;
    protected Group group = null;
    protected ElementSet set = null;
    protected int setIndex = -1;
    protected Control control = null;
    protected Object dataObject = null;
    protected boolean hasChanged = true;
    protected DrawingPanel panelWithValidProjection = null;
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();

    @Override
    public void copyFrom(InteractiveElement interactiveElement) {
        this.setX(interactiveElement.getX());
        this.setY(interactiveElement.getY());
        this.setZ(interactiveElement.getZ());
        this.setSizeX(interactiveElement.getSizeX());
        this.setSizeY(interactiveElement.getSizeY());
        this.setSizeZ(interactiveElement.getSizeZ());
        this.setVisible(interactiveElement.isVisible());
        this.setEnabled(0, interactiveElement.isEnabled(0));
        this.setEnabled(1, interactiveElement.isEnabled(1));
        this.getStyle().copyFrom(interactiveElement.getStyle());
        this.setResolution(interactiveElement.getResolution());
        this.setGroup(interactiveElement.getGroup());
        this.setGroupEnabled(0, interactiveElement.isGroupEnabled(0));
        this.setGroupEnabled(1, interactiveElement.isGroupEnabled(1));
        this.setControl(interactiveElement.getControl());
    }

    @Override
    public void initializeMemberOfSet() {
    }

    @Override
    public void setSensitivity(int n) {
        this.actualSensitivity = n <= 0 ? SENSIBILITY : n;
    }

    @Override
    public int getSensitivity() {
        return this.actualSensitivity;
    }

    @Override
    public void setX(double d) {
        this.x = d;
        this.hasChanged = true;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public void setY(double d) {
        this.y = d;
        this.hasChanged = true;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setZ(double d) {
        this.z = d;
        this.hasChanged = true;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public void setXY(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.hasChanged = true;
    }

    @Override
    public void setXYZ(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.hasChanged = true;
    }

    @Override
    public void setSizeX(double d) {
        this.sizex = d;
        this.hasChanged = true;
    }

    @Override
    public double getSizeX() {
        return this.sizex;
    }

    @Override
    public void setSizeY(double d) {
        this.sizey = d;
        this.hasChanged = true;
    }

    @Override
    public double getSizeY() {
        return this.sizey;
    }

    @Override
    public void setSizeZ(double d) {
        this.sizez = d;
        this.hasChanged = true;
    }

    @Override
    public double getSizeZ() {
        return this.sizez;
    }

    @Override
    public void setSizeXY(double d, double d2) {
        this.sizex = d;
        this.sizey = d2;
        this.hasChanged = true;
    }

    @Override
    public void setSizeXYZ(double d, double d2, double d3) {
        this.sizex = d;
        this.sizey = d2;
        this.sizez = d3;
        this.hasChanged = true;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void canBeMeasured(boolean bl) {
        this.canBeMeasured = bl;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public void setResolution(Resolution resolution) {
        this.resolution = resolution;
        this.hasChanged = true;
    }

    @Override
    public Resolution getResolution() {
        return this.resolution;
    }

    @Override
    public void setGroup(Group group) {
        if (this.group != null) {
            this.group.removeElement(this);
        }
        this.group = group;
        if (this.group != null) {
            this.group.addElement(this);
        }
        this.hasChanged = true;
    }

    @Override
    public Group getGroup() {
        return this.group;
    }

    @Override
    public void setGroupEnabled(boolean bl) {
        this.positionGroupEnabled = this.sizeGroupEnabled = bl;
    }

    @Override
    public boolean isGroupEnabled() {
        return this.positionGroupEnabled || this.sizeGroupEnabled;
    }

    @Override
    public void setGroupEnabled(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.positionGroupEnabled = bl;
                break;
            }
            case 1: {
                this.sizeGroupEnabled = bl;
            }
        }
    }

    @Override
    public boolean isGroupEnabled(int n) {
        switch (n) {
            case 0: {
                return this.positionGroupEnabled;
            }
            case 1: {
                return this.sizeGroupEnabled;
            }
        }
        return false;
    }

    @Override
    public void setSet(ElementSet elementSet, int n) {
        this.set = elementSet;
        this.setIndex = n;
    }

    @Override
    public ElementSet getSet() {
        return this.set;
    }

    @Override
    public int getSetIndex() {
        return this.setIndex;
    }

    @Override
    public void setControl(Control control) {
        this.control = control;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public String toXML() {
        return this.toString();
    }

    @Override
    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    @Override
    public Object getDataObject() {
        return this.dataObject;
    }

    @Override
    public abstract Interactive findInteractive(DrawingPanel var1, int var2, int var3);

    @Override
    public void needsToProject(DrawingPanel drawingPanel) {
        this.panelWithValidProjection = null;
    }

    @Override
    public abstract Object3D[] getObjects3D(DrawingPanel3D var1);

    @Override
    public abstract void draw(DrawingPanel3D var1, Graphics2D var2, int var3);

    @Override
    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        this.draw(drawingPanel3D, graphics2D);
    }

    @Override
    public abstract void draw(DrawingPanel var1, Graphics var2);

    @Override
    public void setEnabled(boolean bl) {
        this.positionEnabled = this.sizeEnabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return this.positionEnabled || this.sizeEnabled;
    }

    @Override
    public void setEnabled(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.positionEnabled = bl;
                break;
            }
            case 1: {
                this.sizeEnabled = bl;
            }
        }
    }

    @Override
    public boolean isEnabled(int n) {
        switch (n) {
            case 0: {
                return this.positionEnabled;
            }
            case 1: {
                return this.sizeEnabled;
            }
        }
        return false;
    }

    @Override
    public void addListener(InteractionListener interactionListener) {
        if (this.set != null) {
            System.out.println("Warning: elements in sets should not add listeners! " + this.toString());
        }
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    @Override
    public void removeListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners = new ArrayList<InteractionListener>();
    }

    @Override
    public void invokeActions(InteractionEvent interactionEvent) {
        for (InteractionListener interactionListener : this.listeners) {
            interactionListener.interactionPerformed(interactionEvent);
        }
    }

    @Override
    public boolean isMeasured() {
        return this.canBeMeasured && this.visible;
    }

    @Override
    public double getXMin() {
        if (this.group == null) {
            return this.x - Math.abs(this.sizex);
        }
        return this.group.x + this.x - Math.abs(this.sizex * this.group.sizex);
    }

    @Override
    public double getXMax() {
        if (this.group == null) {
            return this.x + Math.abs(this.sizex);
        }
        return this.group.x + this.x + Math.abs(this.sizex * this.group.sizex);
    }

    @Override
    public double getYMin() {
        if (this.group == null) {
            return this.y - Math.abs(this.sizey);
        }
        return this.group.y + this.y - Math.abs(this.sizey * this.group.sizey);
    }

    @Override
    public double getYMax() {
        if (this.group == null) {
            return this.y + Math.abs(this.sizey);
        }
        return this.group.y + this.y + Math.abs(this.sizey * this.group.sizey);
    }

    @Override
    public double getZMin() {
        if (this.group == null) {
            return this.z - Math.abs(this.sizez);
        }
        return this.group.z + this.z - Math.abs(this.sizez * this.group.sizez);
    }

    @Override
    public double getZMax() {
        if (this.group == null) {
            return this.z + Math.abs(this.sizez);
        }
        return this.group.z + this.z + Math.abs(this.sizez * this.group.sizez);
    }
}

