/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetElementSize
implements InteractionTarget {
    protected InteractiveElement element;

    InteractionTargetElementSize(InteractiveElement interactiveElement) {
        this.element = interactiveElement;
    }

    @Override
    public InteractionSource getSource() {
        return this.element;
    }

    @Override
    public Point3D getHotspot(DrawingPanel drawingPanel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX() + this.element.getSizeX(), this.element.getY() + this.element.getSizeY(), this.element.getZ() + this.element.getSizeZ());
        }
        return new Point3D(this.element.getGroup().getX() + (this.element.getX() + this.element.getSizeX()) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.element.getY() + this.element.getSizeY()) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.element.getZ() + this.element.getSizeZ()) * this.element.getGroup().getSizeZ());
    }

    @Override
    public void updateHotspot(DrawingPanel drawingPanel, Point3D point3D) {
        if (this.element.getGroup() == null) {
            this.element.setSizeXYZ(point3D.x - this.element.getX(), point3D.y - this.element.getY(), point3D.z - this.element.getZ());
        } else if (this.element.isGroupEnabled(1)) {
            double d = this.element.getX() + this.element.getSizeX();
            double d2 = this.element.getY() + this.element.getSizeY();
            double d3 = this.element.getZ() + this.element.getSizeZ();
            d = d == 0.0 ? this.element.getGroup().getSizeX() : (point3D.x - this.element.getGroup().getX()) / d;
            d2 = d2 == 0.0 ? this.element.getGroup().getSizeY() : (point3D.y - this.element.getGroup().getY()) / d2;
            d3 = d3 == 0.0 ? this.element.getGroup().getSizeZ() : (point3D.z - this.element.getGroup().getZ()) / d3;
            this.element.getGroup().setSizeXYZ(d, d2, d3);
        } else {
            double d = this.element.getGroup().getSizeX();
            double d4 = this.element.getGroup().getSizeY();
            double d5 = this.element.getGroup().getSizeZ();
            d = d == 0.0 ? this.element.getSizeX() : (point3D.x - this.element.getGroup().getX()) / d - this.element.getX();
            d4 = d4 == 0.0 ? this.element.getSizeY() : (point3D.y - this.element.getGroup().getY()) / d4 - this.element.getY();
            d5 = d5 == 0.0 ? this.element.getSizeZ() : (point3D.z - this.element.getGroup().getZ()) / d5 - this.element.getZ();
            this.element.setSizeXYZ(d, d4, d5);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return this.element;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.element.setEnabled(0, bl);
    }

    @Override
    public boolean isEnabled() {
        return this.element.isEnabled(0);
    }

    @Override
    public void setXY(double d, double d2) {
        this.element.setXY(d, d2);
    }

    @Override
    public void setX(double d) {
        this.element.setX(d);
    }

    @Override
    public void setY(double d) {
        this.element.setY(d);
    }

    @Override
    public double getX() {
        return this.element.getX();
    }

    @Override
    public double getY() {
        return this.element.getY();
    }

    @Override
    public boolean isMeasured() {
        return true;
    }

    @Override
    public double getXMin() {
        return this.element.getXMin();
    }

    @Override
    public double getXMax() {
        return this.element.getXMax();
    }

    @Override
    public double getYMin() {
        return this.element.getYMin();
    }

    @Override
    public double getYMax() {
        return this.element.getYMax();
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.element.draw(drawingPanel, graphics);
    }
}

