/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetTracePoint
extends InteractionTargetElementPosition {
    Point3D point;

    InteractionTargetTracePoint(InteractiveElement interactiveElement, Point3D point3D) {
        super(interactiveElement);
        this.point = point3D;
    }

    @Override
    public Point3D getHotspot(DrawingPanel drawingPanel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.element.getX() + this.point.x, this.element.getY() + this.point.y, this.element.getZ() + this.point.z);
        }
        return new Point3D(this.element.getGroup().getX() + (this.element.getX() + this.point.x) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.element.getY() + this.point.y) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.element.getZ() + this.point.z) * this.element.getGroup().getSizeZ());
    }

    @Override
    public void updateHotspot(DrawingPanel drawingPanel, Point3D point3D) {
        if (this.element.getGroup() == null) {
            this.element.setXYZ(point3D.x - this.point.x, point3D.y - this.point.y, point3D.z - this.point.z);
        } else if (this.element.isGroupEnabled(0)) {
            this.element.getGroup().setXYZ(point3D.x - (this.element.getX() + this.point.x) * this.element.getGroup().getSizeX(), point3D.y - (this.element.getY() + this.point.y) * this.element.getGroup().getSizeY(), point3D.z - (this.element.getZ() + this.point.z) * this.element.getGroup().getSizeZ());
        } else {
            double d = this.element.getGroup().getSizeX();
            double d2 = this.element.getGroup().getSizeY();
            double d3 = this.element.getGroup().getSizeZ();
            d = d == 0.0 ? this.element.getX() - this.point.x : (point3D.x - this.element.getGroup().getX()) / d - this.point.x;
            d2 = d2 == 0.0 ? this.element.getY() - this.point.y : (point3D.y - this.element.getGroup().getY()) / d2 - this.point.y;
            d3 = d3 == 0.0 ? this.element.getZ() - this.point.z : (point3D.z - this.element.getGroup().getZ()) / d3 - this.point.z;
            this.element.setXYZ(d, d2, d3);
        }
    }
}

